/*
 * Decompiled with CFR 0.152.
 */
package Ace2;

public class PhredPolyFileEntry {
    static final int I_CALLED_BASE = 0;
    static final int I_CALLED_BASE_POSITION = 1;
    static final int I_CALLED_BASE_AREA = 2;
    static final int I_CALLED_BASE_RELATIVE_AREA = 3;
    static final int I_UNCALLED_BASE = 4;
    static final int I_UNCALLED_BASE_POSITION = 5;
    static final int I_UNCALLED_BASE_AREA = 6;
    static final int I_UNCALLED_BASE_RELATIVE_AREA = 7;
    static final int I_CALLED_BASE_AMP_A = 8;
    static final int I_CALLED_BASE_AMP_C = 9;
    static final int I_CALLED_BASE_AMP_G = 10;
    static final int I_CALLED_BASE_AMP_T = 11;
    static final int I_UNCALLED_BASE_AMP_A = 12;
    static final int I_UNCALLED_BASE_AMP_C = 13;
    static final int I_UNCALLED_BASE_AMP_G = 14;
    static final int I_UNCALLED_BASE_AMP_T = 15;
    char called_base;
    int called_base_position;
    float called_base_area;
    float called_base_relative_area;
    char uncalled_base;
    int uncalled_base_position;
    float uncalled_base_area;
    float uncalled_base_relative_area;
    float called_base_amp_a;
    float called_base_amp_c;
    float called_base_amp_g;
    float called_base_amp_t;
    float uncalled_base_amp_a;
    float uncalled_base_amp_c;
    float uncalled_base_amp_g;
    float uncalled_base_amp_t;
    boolean is_patched_phred = false;

    public PhredPolyFileEntry(String line) {
        String[] fields = line.split("\\s+");
        this.is_patched_phred = fields.length == 16;
        this.called_base = fields[0].charAt(0);
        this.called_base_position = Integer.parseInt(fields[1]);
        this.called_base_area = this.parse_float(fields[2]);
        this.called_base_relative_area = this.parse_float(fields[3]);
        this.uncalled_base = fields[4].charAt(0);
        this.uncalled_base_position = Integer.parseInt(fields[5]);
        this.uncalled_base_area = this.parse_float(fields[6]);
        this.uncalled_base_relative_area = this.parse_float(fields[7]);
        this.called_base_amp_a = this.parse_float(fields[8]);
        this.called_base_amp_c = this.parse_float(fields[9]);
        this.called_base_amp_g = this.parse_float(fields[10]);
        this.called_base_amp_t = this.parse_float(fields[11]);
        if (this.is_patched_phred) {
            this.uncalled_base_amp_a = this.parse_float(fields[12]);
            this.uncalled_base_amp_c = this.parse_float(fields[13]);
            this.uncalled_base_amp_g = this.parse_float(fields[14]);
            this.uncalled_base_amp_t = this.parse_float(fields[15]);
        } else {
            this.uncalled_base_amp_a = this.called_base_amp_a;
            this.uncalled_base_amp_c = this.called_base_amp_c;
            this.uncalled_base_amp_g = this.called_base_amp_g;
            this.uncalled_base_amp_t = this.called_base_amp_t;
        }
    }

    private float parse_float(String s) {
        float result = s.equals("nan") ? 0.0f : Float.parseFloat(s);
        return result;
    }

    public void complement() {
        this.called_base = this.complement_base(this.called_base);
        this.uncalled_base = this.complement_base(this.uncalled_base);
        float tmp = this.called_base_amp_a;
        this.called_base_amp_a = this.called_base_amp_t;
        this.called_base_amp_t = tmp;
        tmp = this.called_base_amp_c;
        this.called_base_amp_c = this.called_base_amp_g;
        this.called_base_amp_g = tmp;
        tmp = this.uncalled_base_amp_a;
        this.uncalled_base_amp_a = this.uncalled_base_amp_t;
        this.uncalled_base_amp_t = tmp;
        tmp = this.uncalled_base_amp_c;
        this.uncalled_base_amp_c = this.uncalled_base_amp_g;
        this.uncalled_base_amp_g = tmp;
    }

    private char complement_base(char b) {
        char c;
        switch (b) {
            case 'a': {
                c = 't';
                break;
            }
            case 'A': {
                c = 'T';
                break;
            }
            case 'c': {
                c = 'g';
                break;
            }
            case 'C': {
                c = 'G';
                break;
            }
            case 'g': {
                c = 'c';
                break;
            }
            case 'G': {
                c = 'C';
                break;
            }
            case 't': {
                c = 'a';
                break;
            }
            case 'T': {
                c = 'A';
                break;
            }
            case '*': {
                c = '*';
                break;
            }
            case 'n': {
                c = 'n';
                break;
            }
            case 'N': {
                c = 'N';
                break;
            }
            default: {
                c = b;
                System.out.println("reverse: warning, don't know how to rc " + b);
            }
        }
        return c;
    }

    public float get_called_base_amplitude() {
        float amp = 0.0f;
        if (this.called_base == 'A') {
            amp = this.called_base_amp_a;
        } else if (this.called_base == 'C') {
            amp = this.called_base_amp_c;
        } else if (this.called_base == 'G') {
            amp = this.called_base_amp_g;
        } else if (this.called_base == 'T') {
            amp = this.called_base_amp_t;
        } else {
            System.err.println("ERROR: unhandled called base " + this.called_base);
        }
        return amp;
    }

    public float get_uncalled_base_amplitude() {
        float amp = 0.0f;
        if (this.uncalled_base == 'A') {
            amp = this.uncalled_base_amp_a;
        } else if (this.uncalled_base == 'C') {
            amp = this.uncalled_base_amp_c;
        } else if (this.uncalled_base == 'G') {
            amp = this.uncalled_base_amp_g;
        } else if (this.uncalled_base == 'T') {
            amp = this.uncalled_base_amp_t;
        } else {
            System.err.println("ERROR: unhandled uncalled base " + this.uncalled_base);
        }
        return amp;
    }
}

