/*
 * Decompiled with CFR 0.152.
 */
package Ace2;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class ProteinTool {
    private static Hashtable dna_to_code;
    private static Hashtable code_to_dna;
    private static Hashtable code_to_name;
    private static final String STOP_STRING = "end";
    public static final char STOP_CODE = '!';

    public ProteinTool() {
        if (dna_to_code == null) {
            ProteinTool.protein_init();
        }
    }

    public char dna_to_code(String codon) {
        String code = (String)dna_to_code.get(codon.toUpperCase());
        if (code == null) {
            return '?';
        }
        if (code.length() == 1) {
            return code.charAt(0);
        }
        if (code.equals(STOP_STRING)) {
            return '!';
        }
        System.out.println("dna_to_code: wtf???");
        return '?';
    }

    public String code_to_name(char code) {
        if (code == '!') {
            return "Stop";
        }
        return (String)code_to_name.get(new Character(code).toString().toUpperCase());
    }

    public Enumeration code_to_dna(String code) {
        Vector v = (Vector)code_to_dna.get(code.toUpperCase());
        return v == null ? null : v.elements();
    }

    private static void protein_init() {
        dna_to_code = new Hashtable();
        code_to_dna = new Hashtable();
        code_to_name = new Hashtable();
        dna_to_code.put("AAA", "K");
        dna_to_code.put("AAC", "N");
        dna_to_code.put("AAG", "K");
        dna_to_code.put("AAT", "N");
        dna_to_code.put("ACA", "T");
        dna_to_code.put("ACC", "T");
        dna_to_code.put("ACG", "T");
        dna_to_code.put("ACT", "T");
        dna_to_code.put("AGA", "R");
        dna_to_code.put("AGC", "S");
        dna_to_code.put("AGG", "R");
        dna_to_code.put("AGT", "S");
        dna_to_code.put("ATA", "I");
        dna_to_code.put("ATC", "I");
        dna_to_code.put("ATG", "M");
        dna_to_code.put("ATT", "I");
        dna_to_code.put("CAA", "Q");
        dna_to_code.put("CAC", "H");
        dna_to_code.put("CAG", "Q");
        dna_to_code.put("CAT", "H");
        dna_to_code.put("CCA", "P");
        dna_to_code.put("CCC", "P");
        dna_to_code.put("CCG", "P");
        dna_to_code.put("CCT", "P");
        dna_to_code.put("CGA", "R");
        dna_to_code.put("CGC", "R");
        dna_to_code.put("CGG", "R");
        dna_to_code.put("CGT", "R");
        dna_to_code.put("CTA", "L");
        dna_to_code.put("CTC", "L");
        dna_to_code.put("CTG", "L");
        dna_to_code.put("CTT", "L");
        dna_to_code.put("GAA", "E");
        dna_to_code.put("GAC", "D");
        dna_to_code.put("GAG", "E");
        dna_to_code.put("GAT", "D");
        dna_to_code.put("GCA", "A");
        dna_to_code.put("GCC", "A");
        dna_to_code.put("GCG", "A");
        dna_to_code.put("GCT", "A");
        dna_to_code.put("GGA", "G");
        dna_to_code.put("GGC", "G");
        dna_to_code.put("GGG", "G");
        dna_to_code.put("GGT", "G");
        dna_to_code.put("GTA", "V");
        dna_to_code.put("GTC", "V");
        dna_to_code.put("GTG", "V");
        dna_to_code.put("GTT", "V");
        dna_to_code.put("TAA", STOP_STRING);
        dna_to_code.put("TAC", "Y");
        dna_to_code.put("TAG", STOP_STRING);
        dna_to_code.put("TAT", "Y");
        dna_to_code.put("TCA", "S");
        dna_to_code.put("TCC", "S");
        dna_to_code.put("TCG", "S");
        dna_to_code.put("TCT", "S");
        dna_to_code.put("TGA", STOP_STRING);
        dna_to_code.put("TGC", "C");
        dna_to_code.put("TGG", "W");
        dna_to_code.put("TGT", "C");
        dna_to_code.put("TTA", "L");
        dna_to_code.put("TTC", "F");
        dna_to_code.put("TTG", "L");
        dna_to_code.put("TTT", "F");
        code_to_name.put("A", "Ala");
        code_to_name.put("C", "Cys");
        code_to_name.put("D", "Asp");
        code_to_name.put("E", "Glu");
        code_to_name.put("F", "Phe");
        code_to_name.put("G", "Gly");
        code_to_name.put("H", "His");
        code_to_name.put("I", "Ile");
        code_to_name.put("K", "Lys");
        code_to_name.put("L", "Leu");
        code_to_name.put("M", "Met");
        code_to_name.put("N", "Asn");
        code_to_name.put("P", "Pro");
        code_to_name.put("Q", "Gln");
        code_to_name.put("R", "Arg");
        code_to_name.put("S", "Ser");
        code_to_name.put("T", "Thr");
        code_to_name.put("V", "Val");
        code_to_name.put("W", "Trp");
        code_to_name.put("Y", "Tyr");
        code_to_name.put(STOP_STRING, "Ter");
        Vector<String> v = new Vector<String>();
        v.addElement("GCT");
        v.addElement("GCC");
        v.addElement("GCA");
        v.addElement("GCG");
        code_to_dna.put("A", v);
        v = new Vector();
        v.addElement("TGT");
        v.addElement("TGC");
        code_to_dna.put("C", v);
        v = new Vector();
        v.addElement("GAT");
        v.addElement("GAC");
        code_to_dna.put("D", v);
        v = new Vector();
        v.addElement("GAA");
        v.addElement("GAG");
        code_to_dna.put("E", v);
        v = new Vector();
        v.addElement("TTT");
        v.addElement("TTC");
        code_to_dna.put("F", v);
        v = new Vector();
        v.addElement("GGT");
        v.addElement("GGC");
        v.addElement("GGA");
        v.addElement("GGG");
        code_to_dna.put("G", v);
        v = new Vector();
        v.addElement("CAT");
        v.addElement("CAC");
        code_to_dna.put("H", v);
        v = new Vector();
        v.addElement("ATT");
        v.addElement("ATC");
        v.addElement("ATA");
        code_to_dna.put("I", v);
        v = new Vector();
        v.addElement("AAA");
        v.addElement("AAG");
        code_to_dna.put("K", v);
        v = new Vector();
        v.addElement("TTA");
        v.addElement("TTG");
        v.addElement("CTT");
        v.addElement("CTC");
        v.addElement("CTA");
        v.addElement("CTG");
        code_to_dna.put("L", v);
        v = new Vector();
        v.addElement("ATG");
        code_to_dna.put("M", v);
        v = new Vector();
        v.addElement("AAT");
        v.addElement("AAC");
        code_to_dna.put("N", v);
        v = new Vector();
        v.addElement("CCT");
        v.addElement("CCC");
        v.addElement("CCA");
        v.addElement("CCG");
        code_to_dna.put("P", v);
        v = new Vector();
        v.addElement("CAA");
        v.addElement("CAG");
        code_to_dna.put("Q", v);
        v = new Vector();
        v.addElement("CGT");
        v.addElement("CGC");
        v.addElement("CGA");
        v.addElement("CGG");
        v.addElement("AGA");
        v.addElement("AGG");
        code_to_dna.put("R", v);
        v = new Vector();
        v.addElement("TCT");
        v.addElement("TCC");
        v.addElement("TCA");
        v.addElement("TCG");
        v.addElement("AGT");
        v.addElement("AGC");
        code_to_dna.put("S", v);
        v = new Vector();
        v.addElement("ACT");
        v.addElement("ACC");
        v.addElement("ACA");
        v.addElement("ACG");
        code_to_dna.put("T", v);
        v = new Vector();
        v.addElement("GTT");
        v.addElement("GTC");
        v.addElement("GTA");
        v.addElement("GTG");
        code_to_dna.put("V", v);
        v = new Vector();
        v.addElement("TGG");
        code_to_dna.put("W", v);
        v = new Vector();
        v.addElement("TAT");
        v.addElement("TAC");
        code_to_dna.put("Y", v);
        v = new Vector();
        v.addElement("TAA");
        v.addElement("TGA");
        v.addElement("TAG");
        code_to_dna.put(STOP_STRING, v);
    }

    public static void main(String[] argv) {
        ProteinTool p1 = new ProteinTool();
        ProteinTool p2 = new ProteinTool();
        ProteinTool p3 = new ProteinTool();
        System.out.println(p1.dna_to_code("aaa"));
        System.out.println(p1.code_to_name('k'));
        Enumeration e = p1.code_to_dna("y");
        while (e.hasMoreElements()) {
            System.out.println((String)e.nextElement());
        }
    }
}

