/*
 * Decompiled with CFR 0.152.
 */
package Ace2;

import Ace2.ChromosomeDisambiguator;
import Ace2.SAMUtils;
import Ace2.WorkingFile;
import Funk.Str;
import IsoView.RegionParser;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordIterator;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.ValidationStringency;
import java.io.File;
import java.io.PrintStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReadMateExtractorPaired {
    private File bam = null;
    private ArrayList<RegionParser> intervals = new ArrayList();
    private int FLUSH_CHECK_INTERVAL = 10000;
    private HashMap<String, SAMRecord> mapped_f;
    private HashMap<String, SAMRecord> mapped_r;
    private HashMap<String, SAMRecord> unmapped;
    boolean VERBOSE = false;
    boolean EXTRACT_UNIQUE_IDS = true;
    private PrintStream ps_fwd;
    private PrintStream ps_rev;
    private PrintStream ps_unpaired;
    private HashSet<String> SAW_IDS;

    public ReadMateExtractorPaired() {
        this.hash_reset();
    }

    private void hash_reset() {
        this.mapped_f = new HashMap();
        this.mapped_r = new HashMap();
        this.unmapped = new HashMap();
    }

    public void set_bam(File bam) {
        this.bam = bam;
    }

    public void add_interval(String interval) throws ParseException {
        RegionParser rp = new RegionParser();
        if (!rp.parse(interval)) {
            throw new ParseException("interval not parsable: " + interval, 0);
        }
        this.intervals.add(rp);
    }

    public void extract() throws Exception {
        if (this.bam == null) {
            throw new Exception("specify bam file");
        }
        SamReader reader = SamReaderFactory.makeDefault().validationStringency(ValidationStringency.SILENT).open(this.bam);
        if (this.intervals.size() == 0) {
            throw new Exception("specify interval(s)");
        }
        String basename = this.bam.getName();
        WorkingFile wf_fwd = new WorkingFile(basename + ".fwd.fastq");
        WorkingFile wf_rev = new WorkingFile(basename + ".rev.fastq");
        WorkingFile wf_unpaired = new WorkingFile(basename + ".unpaired.fastq");
        this.ps_fwd = wf_fwd.getPrintStream();
        this.ps_rev = wf_rev.getPrintStream();
        this.ps_unpaired = wf_unpaired.getPrintStream();
        ChromosomeDisambiguator cd = new ChromosomeDisambiguator(reader);
        SAMSequenceDictionary dict = reader.getFileHeader().getSequenceDictionary();
        this.SAW_IDS = new HashSet();
        for (RegionParser interval : this.intervals) {
            this.hash_reset();
            String ref_name_bam = cd.find(interval.reference);
            SAMRecordIterator query = reader.queryOverlapping(ref_name_bam, interval.start.intValue(), interval.end.intValue());
            int reads_read = 0;
            int unpaired_reads = 0;
            while (query.hasNext()) {
                SAMRecord sr = (SAMRecord)query.next();
                if (sr.getReadUnmappedFlag()) {
                    this.unmapped.put(sr.getReadName(), sr);
                } else if (sr.getReadPairedFlag()) {
                    if (sr.getFirstOfPairFlag()) {
                        this.mapped_f.put(sr.getReadName(), sr);
                    } else {
                        this.mapped_r.put(sr.getReadName(), sr);
                    }
                } else {
                    ++unpaired_reads;
                    this.write_unpaired(sr, "unpaired");
                }
                if (++reads_read % this.FLUSH_CHECK_INTERVAL != 0) continue;
                this.flush_check();
            }
            query.close();
            this.flush_check();
            this.mate_dump(reader, this.mapped_f, true);
            this.mate_dump(reader, this.mapped_r, false);
            if (this.unmapped.size() > 0) {
                System.err.println("WTF: leftover unmapped");
            }
            System.err.println("unpaired reads: " + unpaired_reads);
        }
        wf_fwd.finish();
        wf_rev.finish();
        wf_unpaired.finish();
    }

    private void mate_dump(SamReader reader, HashMap<String, SAMRecord> bucket, boolean is_fwd) {
        for (SAMRecord sr : bucket.values()) {
            SAMRecord sr_f = null;
            SAMRecord sr_r = null;
            if (is_fwd) {
                sr_f = sr;
            } else {
                sr_r = sr;
            }
            SAMRecord mate = reader.queryMate(sr);
            if (mate == null) {
                System.err.println("ERROR: can't find mate for " + sr.getReadName() + "; writing to unpaired bucket");
                this.write_unpaired(sr, "cannot_find_mate");
                continue;
            }
            if (this.VERBOSE) {
                System.err.println("found mate for " + sr.getReadName());
            }
            if (is_fwd) {
                sr_r = mate;
            } else {
                sr_f = mate;
            }
            if (sr_f != null && sr_r != null) {
                this.write_pair(sr_f, sr_r);
                continue;
            }
            System.err.println("gurgle: mate query doesn't have F + R");
        }
    }

    private void flush_check() {
        HashSet<String> all_ids = new HashSet<String>();
        all_ids.addAll(this.mapped_f.keySet());
        all_ids.addAll(this.mapped_r.keySet());
        all_ids.addAll(this.unmapped.keySet());
        ArrayList<String> prunable = new ArrayList<String>();
        for (String id : all_ids) {
            boolean have_f = this.mapped_f.containsKey(id);
            boolean have_r = this.mapped_r.containsKey(id);
            boolean have_unmapped = this.unmapped.containsKey(id);
            SAMRecord sr_f = null;
            SAMRecord sr_r = null;
            if (have_f && have_r && have_unmapped) {
                System.err.println("that's unpossible!");
            } else if (have_f && have_r) {
                sr_f = this.mapped_f.get(id);
                sr_r = this.mapped_r.get(id);
            } else if (have_f && have_unmapped) {
                sr_f = this.mapped_f.get(id);
                sr_r = this.unmapped.get(id);
            } else if (have_r && have_unmapped) {
                sr_f = this.unmapped.get(id);
                sr_r = this.mapped_r.get(id);
            }
            if (sr_f == null || sr_r == null) continue;
            this.write_pair(sr_f, sr_r);
            prunable.add(id);
        }
        for (String id : prunable) {
            this.mapped_f.remove(id);
            this.mapped_r.remove(id);
            this.unmapped.remove(id);
        }
    }

    private void add_basic_tags(SAMRecord sr, ArrayList<String> tags) {
        tags.add(sr.getReadName());
        if (sr.getReadUnmappedFlag()) {
            tags.add("unmapped");
        } else {
            tags.add("mapped");
            tags.add(sr.getReferenceName() + ":" + Integer.toString(sr.getAlignmentStart()) + "-" + Integer.toString(sr.getAlignmentEnd()));
        }
    }

    private void write_pair(SAMRecord sr_f, SAMRecord sr_r) {
        if (this.duplicate_check(sr_f, "paired")) {
            return;
        }
        ArrayList<String> tags_f = new ArrayList<String>();
        ArrayList<String> tags_r = new ArrayList<String>();
        this.add_basic_tags(sr_f, tags_f);
        this.add_basic_tags(sr_r, tags_r);
        this.rc_fix(sr_f, tags_f);
        this.rc_fix(sr_r, tags_r);
        SAMUtils.write_fastq(this.ps_fwd, sr_f, Str.join(" ", tags_f));
        SAMUtils.write_fastq(this.ps_rev, sr_r, Str.join(" ", tags_r));
    }

    private void rc_fix(SAMRecord sr, ArrayList<String> tags) {
        if (!sr.getReadUnmappedFlag() && sr.getReadNegativeStrandFlag()) {
            String bases_rc = new String(sr.getReadBases());
            String fixed = Str.reverse_complement(bases_rc);
            char[] fixed_c = fixed.toCharArray();
            byte[] fixed_b = new byte[fixed_c.length];
            for (int i = 0; i < fixed_c.length; ++i) {
                fixed_b[i] = (byte)fixed_c[i];
            }
            sr.setReadBases(fixed_b);
            StringBuilder sb = new StringBuilder(sr.getBaseQualityString());
            sr.setBaseQualityString(sb.reverse().toString());
            tags.add("rc_fixed");
        }
    }

    public static void main(String[] argv) {
        try {
            ReadMateExtractorPaired rmep = new ReadMateExtractorPaired();
            for (int i = 0; i < argv.length; ++i) {
                if (argv[i].equals("-bam")) {
                    rmep.set_bam(new File(argv[++i]));
                    continue;
                }
                if (argv[i].equals("-interval")) {
                    ++i;
                    while (i < argv.length && argv[i].indexOf("-") != 0) {
                        rmep.add_interval(argv[i++]);
                    }
                    --i;
                    continue;
                }
                if (argv[i].equals("-v")) {
                    rmep.VERBOSE = true;
                    continue;
                }
                System.err.println("unknown arg " + argv[i]);
                System.exit(1);
            }
            rmep.extract();
        }
        catch (Exception e) {
            System.err.println("ERROR: " + e);
            e.printStackTrace();
            ReadMateExtractorPaired.usage();
            System.exit(1);
        }
    }

    public static void usage() {
        System.err.println("usage:");
        System.err.println("  -bam whatever.bam");
        System.err.println("  -interval chrX:1234-5678 [-interval ...] ");
    }

    private void write_unpaired(SAMRecord sr, String tag) {
        if (this.duplicate_check(sr, "unpaired")) {
            return;
        }
        ArrayList<String> tags = new ArrayList<String>();
        this.add_basic_tags(sr, tags);
        tags.add(tag);
        this.rc_fix(sr, tags);
        SAMUtils.write_fastq(this.ps_unpaired, sr, Str.join(" ", tags));
    }

    private boolean duplicate_check(SAMRecord sr, String label) {
        boolean is_duplicate = false;
        if (this.EXTRACT_UNIQUE_IDS) {
            String id = sr.getReadName();
            if (this.SAW_IDS.contains(id)) {
                System.err.println("SKIPPING duplicate ID of type " + label + ": " + id);
                is_duplicate = true;
            } else {
                this.SAW_IDS.add(id);
            }
        }
        return is_duplicate;
    }
}

