/*
 * Decompiled with CFR 0.152.
 */
package Ace2;

import Ace2.Base;
import Ace2.BaseCountSummary;
import Ace2.ChromosomeDisambiguator;
import Ace2.FASTAIndexedFAI;
import Ace2.HashCounter;
import Ace2.Reporter;
import Ace2.StrandCounter;
import Ace2.WorkingFile;
import Funk.DelimitedFile;
import Funk.Str;
import htsjdk.samtools.AlignmentBlock;
import htsjdk.samtools.Cigar;
import htsjdk.samtools.CigarElement;
import htsjdk.samtools.CigarOperator;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordIterator;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.ValidationStringency;
import htsjdk.samtools.util.CloseableIterator;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReadReport {
    private int target_basenum;
    private int min_base_quality = 15;
    private int min_mapping_quality = 1;
    private String out_file_name = "read_report.tab";
    private boolean summary_mode = false;
    private boolean count_optical_duplicates = false;
    private Reporter passthrough = null;
    private String colname_ref = "reference";
    private String colname_base = "base_num";
    private int max_softclip_length = 0;
    private int skip_read_min_quality_cutoff = 0;
    private float skip_read_min_quality_fraction = 0.0f;
    private int ignore_edge_distance = 0;
    private String fasta_file;
    private int background_error_flanking = 0;
    private float BACKGROUND_MIN_DOMINANT_ALLELE_FREQUENCY = 0.8f;
    boolean VERBOSE = false;

    public void report(File bam_file, String ref_name, int target_basenum) {
        this.target_basenum = target_basenum;
        SamReader sfr = SamReaderFactory.makeDefault().validationStringency(ValidationStringency.SILENT).open(bam_file);
        ChromosomeDisambiguator cd = new ChromosomeDisambiguator(sfr);
        SAMRecordIterator iterator = sfr.queryOverlapping(cd.find(ref_name), target_basenum, target_basenum);
        this.get_some((CloseableIterator<SAMRecord>)iterator, ref_name + "." + target_basenum, ref_name);
    }

    public void report(File bam_file, String ref_name, File passthrough_report) {
        try {
            SamReader sfr = SamReaderFactory.makeDefault().validationStringency(ValidationStringency.SILENT).open(bam_file);
            ChromosomeDisambiguator cd = new ChromosomeDisambiguator(sfr);
            DelimitedFile df = new DelimitedFile();
            df.set_delimiter_mandatory(false);
            df.parse(passthrough_report);
            ArrayList<String> headers = new ArrayList<String>();
            Vector v = df.get_labels();
            for (Object o : v) {
                headers.add((String)o);
            }
            headers.add("A");
            headers.add("C");
            headers.add("G");
            headers.add("T");
            headers.add("XT_A");
            headers.add("XT_C");
            headers.add("XT_G");
            headers.add("XT_T");
            headers.add("single_read_support_A");
            headers.add("single_read_support_C");
            headers.add("single_read_support_G");
            headers.add("single_read_support_T");
            headers.add("double_read_support_A");
            headers.add("double_read_support_C");
            headers.add("double_read_support_G");
            headers.add("double_read_support_T");
            if (this.background_error_flanking > 0) {
                headers.add("background_total");
                headers.add("background_variant");
                headers.add("background_spectrum");
            }
            this.passthrough = new Reporter();
            this.passthrough.set_output_filename(passthrough_report + ".read_report.tab");
            this.passthrough.set_headers(headers);
            boolean read_ref_name = ref_name == null;
            for (Object o : df.get_rows()) {
                Hashtable row = (Hashtable)o;
                for (Object ko : row.keySet()) {
                    String key = (String)ko;
                    this.passthrough.set_value(key, (String)row.get(key));
                }
                String s_base = (String)row.get(this.colname_base);
                if (s_base == null) {
                    throw new IOException("FATAL ERROR: column " + this.colname_base + " doesn't exist");
                }
                this.target_basenum = Integer.parseInt(s_base);
                if (read_ref_name && (ref_name = (String)row.get(this.colname_ref)) == null) {
                    throw new IOException("FATAL: no reference name (command line or input)");
                }
                System.err.println("target: " + ref_name + "." + this.target_basenum);
                SAMRecordIterator iterator = sfr.queryOverlapping(cd.find(ref_name), this.target_basenum, this.target_basenum);
                this.get_some((CloseableIterator<SAMRecord>)iterator, ref_name + "." + this.target_basenum, ref_name);
                iterator.close();
                this.passthrough.end_row();
            }
            this.passthrough.close();
        }
        catch (Exception e) {
            System.err.println("ERROR: " + e);
            e.printStackTrace();
        }
    }

    public void set_column_reference(String s) {
        this.colname_ref = s;
    }

    public void set_column_base_num(String s) {
        this.colname_base = s;
    }

    public void set_summary_mode(boolean v) {
        this.summary_mode = v;
    }

    public void set_outfile(String out_file) {
        this.out_file_name = out_file;
    }

    public void set_min_mapping_quality(int q) {
        this.min_mapping_quality = q;
    }

    public void set_min_base_quality(int q) {
        this.min_base_quality = q;
    }

    public void set_max_softclip_length(int len) {
        this.max_softclip_length = len;
    }

    public void set_skip_read_min_quality_cutoff(int q) {
        this.skip_read_min_quality_cutoff = q;
    }

    public void set_ignore_edge_distance(int d) {
        this.ignore_edge_distance = d;
    }

    public void set_background_error_flanking(int f) {
        this.background_error_flanking = f;
    }

    public void set_skip_read_min_quality_fraction(float f) {
        this.skip_read_min_quality_fraction = f;
    }

    public void set_fasta_file(String f) {
        this.fasta_file = f;
    }

    public void count_optical_duplicates(boolean v) {
        this.count_optical_duplicates = v;
    }

    private void get_some(CloseableIterator<SAMRecord> iterator, String site_name, String ref_name) {
        int background_total = 0;
        int background_variant = 0;
        HashCounter background_spectra_counts = new HashCounter();
        Reporter rpt = null;
        if (!this.summary_mode && this.passthrough == null) {
            rpt = new Reporter();
            rpt.add_header("site");
            rpt.add_header("read_name");
            rpt.add_header("read_mapq");
            rpt.add_header("strand");
            rpt.add_header("base");
            rpt.add_header("base_quality");
        }
        try {
            HashMap<String, Integer> base2count;
            if (rpt != null) {
                rpt.set_output_filename(this.out_file_name);
            }
            HashMap<String, HashCounter> base2xt = new HashMap<String, HashCounter>();
            HashMap<Integer, BaseCountSummary> base2sum = new HashMap<Integer, BaseCountSummary>();
            StrandCounter sc = new StrandCounter();
            int raw_overlapping_reads = 0;
            int cooked_overlapping_reads = 0;
            int background_window_start = 0;
            int background_window_end = 0;
            char[] reference_chunk_uc = null;
            if (this.background_error_flanking > 0) {
                FASTAIndexedFAI fai = new FASTAIndexedFAI(this.fasta_file);
                background_window_start = this.target_basenum - this.background_error_flanking;
                background_window_end = this.target_basenum + this.background_error_flanking;
                int chunk_len = this.background_error_flanking * 2 + 1;
                byte[] chunk = fai.get_region(ref_name, background_window_start, chunk_len);
                reference_chunk_uc = new char[chunk_len];
                for (int i = 0; i < chunk_len; ++i) {
                    reference_chunk_uc[i] = Character.toUpperCase((char)chunk[i]);
                }
            }
            while (iterator.hasNext()) {
                SAMRecord sr = (SAMRecord)iterator.next();
                String trace_name = sr.getReadName();
                int mapq = sr.getMappingQuality();
                if (mapq < this.min_mapping_quality) {
                    this.verbose_msg("reject read: MAPQ filter failed", sr);
                    continue;
                }
                if (!this.count_optical_duplicates && sr.getDuplicateReadFlag()) {
                    this.verbose_msg("reject read: duplicate", sr);
                    continue;
                }
                if (this.max_softclip_length > 0) {
                    Cigar c = sr.getCigar();
                    boolean ok = true;
                    for (CigarElement ce : c.getCigarElements()) {
                        CigarOperator co = ce.getOperator();
                        if (!co.equals((Object)CigarOperator.SOFT_CLIP) || ce.getLength() <= this.max_softclip_length) continue;
                        ok = false;
                    }
                    if (!ok) {
                        this.verbose_msg("reject read: soft clip filter failed", sr);
                        continue;
                    }
                }
                byte[] bases = sr.getReadBases();
                byte[] quals = sr.getBaseQualities();
                if (this.skip_read_min_quality_cutoff > 0) {
                    int count_lq = 0;
                    for (int i = 0; i < quals.length; ++i) {
                        if (quals[i] >= this.skip_read_min_quality_cutoff) continue;
                        ++count_lq;
                    }
                    float frac_lq = (float)count_lq / (float)quals.length;
                    if (frac_lq > this.skip_read_min_quality_fraction) {
                        this.verbose_msg("reject read: max lq fraction filter failed: " + frac_lq, sr);
                        continue;
                    }
                }
                if (rpt != null) {
                    rpt.set_value("site", site_name);
                    rpt.set_value("read_name", trace_name);
                    rpt.set_value("read_mapq", Integer.toString(mapq));
                    rpt.set_value("strand", sr.getReadNegativeStrandFlag() ? "-" : "+");
                }
                int ignore_left = 0;
                int ignore_right = 0;
                if (this.ignore_edge_distance > 0) {
                    ignore_left = this.ignore_edge_distance - 1;
                    ignore_right = bases.length - this.ignore_edge_distance;
                }
                for (AlignmentBlock ab : sr.getAlignmentBlocks()) {
                    int len = ab.getLength();
                    int read_i = ab.getReadStart() - 1;
                    int reference_basenum = ab.getReferenceStart();
                    if (read_i < 0 || reference_basenum < 1) continue;
                    int end = read_i + len;
                    while (read_i < end) {
                        if (quals[read_i] < this.min_base_quality) {
                            if (reference_basenum == this.target_basenum) {
                                this.verbose_msg("reject qual at target: " + quals[read_i] + " idx=" + read_i, sr);
                            }
                        } else if (this.ignore_edge_distance <= 0 || read_i > ignore_left && read_i < ignore_right) {
                            if (reference_basenum == this.target_basenum) {
                                String base_uc;
                                HashCounter counts_xt;
                                ++raw_overlapping_reads;
                                char sam_base = (char)bases[read_i];
                                ++cooked_overlapping_reads;
                                if (this.VERBOSE) {
                                    System.err.println("basic count at target " + sr.getReadName() + (sr.getReadNegativeStrandFlag() ? "-" : "+") + " => " + sam_base);
                                }
                                if (rpt != null) {
                                    rpt.set_value("base", Character.toString(sam_base));
                                    rpt.set_value("base_quality", Integer.toString(quals[read_i]));
                                    rpt.end_row();
                                }
                                if ((counts_xt = (HashCounter)base2xt.get(base_uc = Character.toString(sam_base).toUpperCase())) == null) {
                                    counts_xt = new HashCounter();
                                    base2xt.put(base_uc, counts_xt);
                                }
                                sc.add_read(sr, Base.valueOf(sam_base));
                                for (SAMRecord.SAMTagAndValue tav : sr.getAttributes()) {
                                    if (!tav.tag.equals("XT")) continue;
                                    this.verbose_msg("save XT for " + base_uc + " " + tav.value.toString(), sr);
                                    counts_xt.add(tav.value.toString());
                                }
                            } else if (reference_basenum >= background_window_start && reference_basenum <= background_window_end) {
                                int ri = reference_basenum - background_window_start;
                                char reference_base = reference_chunk_uc[ri];
                                char this_base = Character.toUpperCase((char)bases[read_i]);
                                boolean is_reference = this_base == reference_base;
                                BaseCountSummary bcs = (BaseCountSummary)base2sum.get(reference_basenum);
                                if (bcs == null) {
                                    bcs = new BaseCountSummary();
                                    base2sum.put(reference_basenum, bcs);
                                }
                                bcs.add_base(Base.valueOf(this_base), is_reference);
                                int ri_before = ri - 1;
                                int ri_after = ri + 1;
                                if (ri_before >= 0 && ri_after < reference_chunk_uc.length) {
                                    if (reference_base == 'C' && this_base == 'A' && reference_chunk_uc[ri_before] == 'C' && reference_chunk_uc[ri_after] == 'G') {
                                        if (this.VERBOSE) {
                                            System.err.println("CCG>CAG at " + reference_basenum);
                                        }
                                        bcs.add_CCG_CAG();
                                    } else if (reference_base == 'G' && this_base == 'T' && reference_chunk_uc[ri_before] == 'C' && reference_chunk_uc[ri_after] == 'G') {
                                        if (this.VERBOSE) {
                                            System.err.println("CGG>CTG at " + reference_basenum);
                                        }
                                        bcs.add_CGG_CTG();
                                    }
                                }
                            }
                        }
                        ++read_i;
                        ++reference_basenum;
                    }
                }
            }
            for (Integer pos : base2sum.keySet()) {
                BaseCountSummary bcs = (BaseCountSummary)base2sum.get(pos);
                if (bcs.get_dominant_allele_frequency() >= this.BACKGROUND_MIN_DOMINANT_ALLELE_FREQUENCY) {
                    if (bcs.is_variant_allele_dominant()) {
                        System.err.println("SKIPPING HOMOZYGOUS VARIANT: target=" + this.target_basenum + " freq at " + pos + " = " + bcs.get_dominant_allele_frequency());
                        continue;
                    }
                    background_total += bcs.get_count_total();
                    background_variant += bcs.get_count_variant();
                    if (this.VERBOSE) {
                        System.err.println("spectrum target=" + this.target_basenum + " pos=" + pos);
                    }
                    bcs.get_background_spectra(background_spectra_counts, this.VERBOSE);
                    continue;
                }
                System.err.println("SKIPPING HETEROZYGOUS: target=" + this.target_basenum + " freq at " + pos + " = " + bcs.get_dominant_allele_frequency());
            }
            if (rpt != null) {
                rpt.close();
            }
            sc.build_counts();
            if (this.summary_mode) {
                PrintStream ps;
                base2count = sc.get_all_counts_string();
                ArrayList<String> bases = new ArrayList<String>(base2count.keySet());
                Collections.sort(bases);
                WorkingFile wf = null;
                if (this.out_file_name.equals("-")) {
                    ps = new PrintStream(System.out);
                } else {
                    wf = new WorkingFile(this.out_file_name);
                    ps = wf.getPrintStream();
                }
                for (String base : bases) {
                    ps.println(base + "\t" + base2count.get(base));
                }
                if (wf != null) {
                    wf.finish();
                }
            } else if (this.passthrough != null) {
                this.passthrough.set_value("A", "0");
                this.passthrough.set_value("C", "0");
                this.passthrough.set_value("G", "0");
                this.passthrough.set_value("T", "0");
                base2count = sc.get_all_counts_string();
                for (String base : base2count.keySet()) {
                    this.passthrough.set_value(base, Integer.toString(base2count.get(base)));
                }
                for (String base : base2xt.keySet()) {
                    ArrayList<String> xt_summary = new ArrayList<String>();
                    HashCounter counts_xt = (HashCounter)base2xt.get(base);
                    if (counts_xt == null) continue;
                    HashMap<String, Integer> cxt = counts_xt.get_counts();
                    for (String xt : cxt.keySet()) {
                        xt_summary.add(xt + "=" + cxt.get(xt));
                    }
                    this.passthrough.set_value("XT_" + base, Str.join(",", xt_summary));
                }
                sc.populate_report(this.passthrough);
                if (this.background_error_flanking > 0) {
                    this.passthrough.set_value("background_total", Integer.toString(background_total));
                    this.passthrough.set_value("background_variant", Integer.toString(background_variant));
                    this.passthrough.set_value("background_spectrum", BaseCountSummary.summarize_background_spectrum(background_spectra_counts));
                }
            }
        }
        catch (Exception e) {
            System.err.println("ERROR: " + e);
            System.exit(1);
        }
    }

    public void config_summary() {
        System.err.println("configuration summary:");
        System.err.println("  minimum base quality: " + this.min_base_quality);
        System.err.println("  minimum mapping quality: " + this.min_mapping_quality);
        System.err.println("  count optical/PCR duplicates?: " + this.count_optical_duplicates);
        System.err.print("  reject reads with soft clips?: ");
        if (this.max_softclip_length > 0) {
            System.err.println("yes, max len=" + this.max_softclip_length);
        } else {
            System.err.println("no");
        }
        System.err.print("  reject reads based on overall quality?: ");
        if (this.skip_read_min_quality_cutoff > 0) {
            System.err.println("yes, quality=" + this.skip_read_min_quality_cutoff + " fraction=" + this.skip_read_min_quality_fraction);
        } else {
            System.err.println("no");
        }
        System.err.print("  ignore sites near read edges?: ");
        if (this.ignore_edge_distance > 0) {
            System.err.println("yes, within " + this.ignore_edge_distance);
        } else {
            System.err.println("no");
        }
        System.err.print("  calculate background error?: ");
        if (this.background_error_flanking > 0) {
            System.err.println("yes, flanking count=" + this.background_error_flanking);
        } else {
            System.err.println("no");
        }
    }

    public void config_sanity_check() {
        if (!(this.skip_read_min_quality_cutoff <= 0 && !(this.skip_read_min_quality_fraction > 0.0f) || this.skip_read_min_quality_cutoff != 0 && this.skip_read_min_quality_fraction != 0.0f)) {
            System.err.println("ERROR: both -skip-read-quality-* parameters must be specified");
            System.exit(1);
        }
        if (this.background_error_flanking > 0 && this.fasta_file == null) {
            System.err.println("ERROR: -calculate-background-error requires -fasta FILE");
            System.exit(1);
        }
    }

    public static void main(String[] argv) {
        int NULL = -1;
        String tname = null;
        int basenum = NULL;
        File bam = null;
        String outfile = "read_report.tab";
        File passthrough_report = null;
        HashMap report = new HashMap();
        ReadReport pr = new ReadReport();
        for (int i = 0; i < argv.length; ++i) {
            if (argv[i].equals("-ref")) {
                tname = new String(argv[++i]);
                continue;
            }
            if (argv[i].equals("-base")) {
                basenum = Integer.parseInt(argv[++i]);
                continue;
            }
            if (argv[i].equals("-passthrough")) {
                passthrough_report = new File(argv[++i]);
                continue;
            }
            if (argv[i].equals("-outfile")) {
                pr.set_outfile(argv[++i]);
                continue;
            }
            if (argv[i].equals("-bam")) {
                bam = new File(argv[++i]);
                continue;
            }
            if (argv[i].equals("-summary")) {
                pr.set_summary_mode(true);
                continue;
            }
            if (argv[i].equals("-count-optical-duplicates")) {
                pr.count_optical_duplicates(true);
                continue;
            }
            if (argv[i].equals("-min-quality")) {
                pr.set_min_base_quality(Integer.parseInt(argv[++i]));
                continue;
            }
            if (argv[i].equals("-min-mapq")) {
                pr.set_min_mapping_quality(Integer.parseInt(argv[++i]));
                continue;
            }
            if (argv[i].equals("-f-reference")) {
                pr.set_column_reference(argv[++i]);
                continue;
            }
            if (argv[i].equals("-f-base-num")) {
                pr.set_column_base_num(argv[++i]);
                continue;
            }
            if (argv[i].equals("-demo")) {
                bam = new File("tcga-10-0926-11a-01w_mini_tp53.bam");
                tname = "chr17";
                basenum = 7518132;
                continue;
            }
            if (argv[i].equals("-max-softclip-length")) {
                pr.set_max_softclip_length(Integer.parseInt(argv[++i]));
                continue;
            }
            if (argv[i].equals("-skip-read-quality-cutoff")) {
                pr.set_skip_read_min_quality_cutoff(Integer.parseInt(argv[++i]));
                continue;
            }
            if (argv[i].equals("-skip-read-quality-fraction")) {
                pr.set_skip_read_min_quality_fraction(Float.parseFloat(argv[++i]));
                continue;
            }
            if (argv[i].equals("-ignore-edge-distance")) {
                pr.set_ignore_edge_distance(Integer.parseInt(argv[++i]));
                continue;
            }
            if (argv[i].equals("-fasta")) {
                pr.set_fasta_file(argv[++i]);
                continue;
            }
            if (argv[i].equals("-calculate-background-error")) {
                pr.set_background_error_flanking(Integer.parseInt(argv[++i]));
                continue;
            }
            if (argv[i].equals("-verbose")) {
                pr.VERBOSE = true;
                continue;
            }
            System.err.println("ERROR: unknown argument " + argv[i]);
            ReadReport.usage();
        }
        pr.config_sanity_check();
        if (bam != null) {
            pr.config_summary();
            if (passthrough_report != null) {
                pr.report(bam, tname, passthrough_report);
            } else if (tname != null && basenum != NULL) {
                pr.report(bam, tname, basenum);
            } else {
                ReadReport.usage();
            }
        } else {
            ReadReport.usage();
        }
    }

    private void verbose_msg(String msg, SAMRecord sr) {
        if (this.VERBOSE) {
            System.err.println(msg + " " + sr.getReadName() + " " + (sr.getReadNegativeStrandFlag() ? "-" : "+"));
        }
    }

    private static void usage() {
        System.err.println("usage:");
        System.err.println("  input data:");
        System.err.println("    -bam [bamfile]");
        System.err.println("    -min-quality [value] (default: 15)");
        System.err.println("    -min-mapq [value] (default: 1)");
        System.err.println("  target site:");
        System.err.println("    -ref [reference sequence name (e.g. chr1)]");
        System.err.println("    -base [base number]");
        System.err.println("  output:");
        System.err.println("    -outfile [output .tab report (default: read_report.tab)]");
        System.err.println("             (specify \"-\" to write to STDOUT)");
        System.err.println("  misc:");
        System.err.println("    -summary [only report counts]");
        System.err.println("    -count-optical-duplicates [default: no]");
        System.exit(1);
    }
}

