/*
 * Decompiled with CFR 0.152.
 */
package Ace2;

import Ace2.AceViewerConfig;
import Ace2.Codon;
import Ace2.Exon;
import Ace2.PadMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RefGene {
    private String symbol;
    private String accession;
    private String strand;
    private String protein;
    private int cds_start;
    private int cds_end;
    private ArrayList<Exon> exons;
    private boolean is_initialized = false;
    private boolean is_broken = true;
    private int consensus_adjust = 0;
    public static boolean VERBOSE = false;

    public RefGene(String[] fields) {
        this.setup(fields);
    }

    public RefGene(HashMap<String, String> row) {
        String[] fields = new String[]{"refGene", row.get("name2"), row.get("name"), row.get("strand"), row.get("cdsStart"), row.get("cdsEnd"), row.get("exonStarts"), row.get("exonEnds"), row.get("exonFrames")};
        this.setup(fields);
    }

    private void setup(String[] fields) {
        if ((fields.length == 10 || fields.length == 9) && fields[0].equals("refGene")) {
            this.symbol = new String(fields[1]);
            this.accession = new String(fields[2]);
            this.strand = new String(fields[3]);
            this.cds_start = Integer.parseInt(fields[4]);
            this.cds_end = Integer.parseInt(fields[5]);
            this.exons = new ArrayList();
            String[] starts = fields[6].split(",");
            String[] ends = fields[7].split(",");
            String[] frames = fields[8].split(",");
            String string = this.protein = fields.length == 10 ? new String(fields[9]) : null;
            if (starts.length == ends.length) {
                int ec = 1;
                for (int i = 0; i < starts.length; ++i) {
                    Exon ex = new Exon(Integer.toString(ec++), Integer.parseInt(starts[i]), Integer.parseInt(ends[i]), Integer.parseInt(frames[i]));
                    this.exons.add(ex);
                }
            } else {
                System.err.println("WTF: starts/ends size mismatch");
            }
        } else {
            System.err.println("error instantiating refGene data: flen=" + fields.length);
        }
    }

    public boolean is_initialized() {
        return this.is_initialized;
    }

    public boolean is_broken() {
        return this.is_broken;
    }

    public boolean is_rc() {
        return this.strand.equals("-");
    }

    public String get_strand() {
        return this.strand;
    }

    public void consensus_adjust(int i) {
        this.consensus_adjust = i;
        this.cds_start -= i;
        this.cds_end -= i;
        for (Exon exon : this.exons) {
            exon.start -= i;
            exon.end -= i;
        }
    }

    public void consensus_setup(PadMap pm) {
        StringBuffer sb;
        int ei;
        this.is_broken = false;
        char[] consensus = pm.get_padded_sequence();
        int exon_count = this.exons.size();
        Exon ex = null;
        for (ei = 0; ei < exon_count; ++ei) {
            ex = this.exons.get(ei);
            if (VERBOSE) {
                System.err.println("cds:" + this.cds_start + " start:" + ex.start + " end:" + ex.end);
            }
            if (this.cds_start < ex.start || this.cds_start > ex.end) continue;
            if (!VERBOSE) break;
            System.err.println("HEY NOW: found CDS in exon index " + ei);
            break;
        }
        boolean is_rc = this.is_rc();
        Codon codon = null;
        int codon_counter = 0;
        if (VERBOSE) {
            System.err.println("cons setup for " + this.accession);
        }
        if (!this.is_broken) {
            int upcsn = this.cds_start + 1;
            int max_unpadded = pm.get_max_unpadded();
            boolean codon_hosed = false;
            do {
                char c;
                int pcsn;
                if (upcsn < 1) {
                    pcsn = 1;
                    c = 'a';
                    codon_hosed = true;
                } else if (upcsn > max_unpadded) {
                    pcsn = 1;
                    c = 'a';
                    codon_hosed = true;
                } else {
                    pcsn = pm.get_unpadded_to_padded(upcsn);
                    if (pcsn == -999999) {
                        c = 'a';
                        codon_hosed = true;
                        pcsn = 1;
                        break;
                    }
                    c = consensus[pcsn - 1];
                }
                if (c == '*' || c == '-') {
                    System.err.println("wanted upcsn:" + upcsn + " got pcsn:" + pcsn + ", got pad/deletion => That's unpossible!!! --Ralph");
                    this.is_initialized = true;
                    this.is_broken = true;
                    break;
                }
                if (VERBOSE) {
                    System.err.println("at " + upcsn + "/" + pcsn + " nt:" + c + " hosed:" + codon_hosed + " xpadded:" + (pcsn + this.consensus_adjust));
                }
                if (codon == null) {
                    codon = new Codon(++codon_counter, is_rc);
                }
                if (codon_hosed) {
                    codon.set_unmappable(codon_hosed);
                } else {
                    codon.increment_valid_bases();
                }
                if (is_rc) {
                    // empty if block
                }
                codon.append(c, upcsn, pcsn);
                if (codon.complete()) {
                    if (VERBOSE) {
                        System.err.println("finished codon " + codon_counter + ": " + codon + " => " + codon.to_code());
                    }
                    ex.add_codon(codon);
                    codon = null;
                    codon_hosed = false;
                }
                if (upcsn >= ex.end) {
                    if (VERBOSE) {
                        System.err.println("jumping to next exon, load_index=" + (codon == null ? "null" : Integer.valueOf(codon.get_load_index())) + " partial=" + codon);
                        System.err.println("current frame offset=" + ex.frame_offset);
                        if (is_rc) {
                            sb = new StringBuffer(ex.toString());
                            sb = sb.reverse();
                            System.err.println("so far: " + sb.toString() + "<<<");
                        } else {
                            System.err.println("so far: " + ex.toString());
                        }
                    }
                    if (++ei >= exon_count) {
                        System.err.println("out of exons, stopping translation...");
                        break;
                    }
                    ex = this.exons.get(ei);
                    if (VERBOSE) {
                        System.err.println("new exon frame offset: " + ex.frame_offset);
                    }
                    upcsn = ex.start + 1;
                    continue;
                }
                ++upcsn;
            } while (upcsn <= this.cds_end);
        }
        if (is_rc) {
            Collections.reverse(this.exons);
            int exno = 0;
            int cc = 0;
            for (Exon e : this.exons) {
                e.set_id(Integer.valueOf(++exno).toString());
                e.set_rc(true);
                ArrayList<Codon> cos = e.get_codons();
                if (cos == null) continue;
                Collections.reverse(cos);
                for (Codon co : cos) {
                    co.set_codon_number(++cc);
                }
            }
        }
        boolean all_mappable = true;
        Codon first_codon = null;
        block4: for (Exon e : this.exons) {
            for (Codon co : e.get_codons()) {
                if (co.is_unmappable()) {
                    all_mappable = false;
                    continue block4;
                }
                if (first_codon != null) continue;
                first_codon = co;
            }
        }
        if (all_mappable) {
            char code;
            if (this.protein != null && this.protein.length() > 0) {
                sb = new StringBuffer();
                for (Exon ex2 : this.exons) {
                    sb.append(ex2.get_protein_sequence());
                }
                String translated = sb.toString();
                String p2 = this.protein + '!';
                if (!p2.equals(translated)) {
                    System.err.println("ERROR: CDS map sanity check failed for " + this.accession + ", translated protein != refseq protein");
                    this.is_broken = true;
                }
            } else if (first_codon != null && (code = first_codon.to_code()) != 'M') {
                System.err.println("ERROR: CDS map sanity check failed for " + this.accession + ", first mapped codon is not M");
                this.is_broken = true;
            }
        }
        if (VERBOSE) {
            System.err.println("exon count: " + this.exons.size());
            System.err.println("is_broken: " + this.is_broken);
            for (Exon e : this.exons) {
                System.err.println("exon " + e);
            }
        }
        for (Exon exon : this.exons) {
            exon.build_consensus_ranges();
        }
        this.is_initialized = true;
    }

    public boolean is_visible(int csv, int cev) {
        boolean result = false;
        for (Exon exon : this.exons) {
            if (!exon.intersects(csv, cev)) continue;
            result = true;
            break;
        }
        return result;
    }

    public ArrayList<Exon> get_visible_exons(int csv, int cev) {
        ArrayList<Exon> results = new ArrayList<Exon>();
        for (Exon exon : this.exons) {
            if (!exon.intersects(csv, cev)) continue;
            results.add(exon);
        }
        return results;
    }

    public String get_accession() {
        return this.accession;
    }

    public String get_symbol() {
        return this.symbol;
    }

    public int get_exon_count() {
        return this.exons.size();
    }

    public Exon get_exon_id(String id) {
        Exon result = null;
        for (Exon e : this.exons) {
            if (!e.id.equals(id)) continue;
            result = e;
            break;
        }
        return result;
    }

    public ArrayList<Exon> get_exons() {
        return this.exons;
    }

    public static char complement(char c) {
        char result = '\u0000';
        switch (c) {
            case 'a': {
                result = 't';
                break;
            }
            case 'A': {
                result = 'T';
                break;
            }
            case 'c': {
                result = 'g';
                break;
            }
            case 'C': {
                result = 'G';
                break;
            }
            case 'g': {
                result = 'c';
                break;
            }
            case 'G': {
                result = 'C';
                break;
            }
            case 't': {
                result = 'a';
                break;
            }
            case 'T': {
                result = 'A';
                break;
            }
            case 'n': {
                result = 'n';
                break;
            }
            case 'N': {
                result = 'N';
                break;
            }
            case '*': {
                result = '*';
                break;
            }
            case '-': {
                result = '-';
                break;
            }
            default: {
                System.err.println("error, don't know to complement nt " + c);
                result = c;
            }
        }
        return result;
    }

    public void intron_splice_adjust(AceViewerConfig config) {
        if (config.intron_compressor != null) {
            int offset = config.intron_compressor.get_start_shift(this.cds_start, false);
            this.cds_start -= offset;
            this.cds_end -= offset;
            ArrayList<Exon> filtered = new ArrayList<Exon>();
            for (Exon exon : this.exons) {
                if (config.intron_compressor.is_completely_trimmed(exon.start, exon.end, false)) {
                    System.err.println("removing completely-trimmed exon " + exon.id);
                    continue;
                }
                exon.intron_splice_adjust(config.intron_compressor, config.assembly.get_padmap());
                if (VERBOSE) {
                    System.err.println("post-slice range for " + exon.id + "=" + exon.start + "-" + exon.end);
                }
                filtered.add(exon);
            }
            this.exons = filtered;
        }
    }
}

