/*
 * Decompiled with CFR 0.152.
 */
package Ace2;

import Ace2.AceViewerConfig;
import Ace2.PadMap;
import java.util.Arrays;

public class Ruler {
    private AceViewerConfig config;

    public Ruler(AceViewerConfig config) {
        this.config = config;
    }

    public String get_ruler_for(int csv, int len, PadMap pm) {
        char[] consensus_padded = this.config.assembly.get_consensus_sequence();
        if (!this.config.COUNTER_UNPADDED) {
            System.err.println("ERROR: padded ruler sequence not yet supported");
        }
        int prebuf_size = 20;
        int postbuf_size = 20;
        if (csv > prebuf_size) {
            csv -= prebuf_size;
        } else {
            prebuf_size = 0;
        }
        int ruler_label_num = pm.get_padded_to_unpadded(csv) + this.config.ruler_start;
        int mod = 10;
        int dot_spacing = 5;
        int lsize = Integer.toString(ruler_label_num).length();
        if (lsize >= 7) {
            mod = 20;
            dot_spacing = 10;
        }
        char[] buf = new char[len + prebuf_size + postbuf_size];
        Arrays.fill(buf, ' ');
        int end = prebuf_size + len + postbuf_size;
        int ci = csv;
        int ci_max = pm.get_padded_sequence().length;
        int i = 0;
        while (i < end) {
            if (ci > ci_max) {
                buf[i] = 32;
            } else {
                ruler_label_num = pm.get_padded_to_unpadded(ci) + this.config.ruler_start;
                if (ruler_label_num % mod == 0) {
                    if (ruler_label_num != 0) {
                        String label = Integer.toString(ruler_label_num);
                        int si = i - label.length() / 2;
                        char[] la = label.toCharArray();
                        if (si >= 0 && si + la.length < buf.length) {
                            System.arraycopy(la, 0, buf, si, la.length);
                        }
                    }
                } else if (ruler_label_num == 1) {
                    buf[i] = 49;
                } else if (ruler_label_num % dot_spacing == 0) {
                    buf[i] = 46;
                }
            }
            ++i;
            ++ci;
        }
        return new String(buf, prebuf_size, len);
    }
}

