/*
 * Decompiled with CFR 0.152.
 */
package Ace2;

import Ace2.SAMConsensusMapping;
import htsjdk.samtools.SAMRecord;

public class SAMAlternatePeakAmplitudeRatios {
    static final String TAG_ALTERNATE_PEAK_AMPLITUDE_RATIOS = "YR";
    static final int SAM_CHARACTER_DYNAMIC_RANGE = 92;
    private byte[] ratios;

    public SAMAlternatePeakAmplitudeRatios(SAMRecord sr) {
        this.setup(sr);
    }

    private void setup(SAMRecord sr) {
        Object p = sr.getAttribute(TAG_ALTERNATE_PEAK_AMPLITUDE_RATIOS);
        if (p == null) {
            System.err.println("ERROR: no trace alternate peak amplitude ratios tag YR");
        } else {
            this.ratios = ((String)p).getBytes();
            int len = this.ratios.length;
            for (int i = 0; i < len; ++i) {
                float cooked = Math.round((float)(this.ratios[i] - 33) / 92.0f * 100.0f);
                this.ratios[i] = (byte)cooked;
            }
        }
    }

    public byte get_alternate_peak_amplitude_ratio_for_consensus(SAMConsensusMapping scm, int cpos) {
        boolean result = false;
        int pi = scm.get_padded_index(cpos);
        byte[] padded = scm.get_sequence_buffer();
        int unpadded_i = 0;
        for (int i = 0; i < pi; ++i) {
            if (padded[i] == 42 || padded[i] == 45 || padded[i] == 62 || padded[i] == 60) continue;
            ++unpadded_i;
        }
        return this.ratios[unpadded_i];
    }
}

