/*
 * Decompiled with CFR 0.152.
 */
package Ace2;

import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.ValidationStringency;
import java.io.File;

public class SAMAmbigCounter {
    static int REPORT_INTERVAL = 100000;
    int total_nt = 0;
    int total_n = 0;
    int total_other = 0;
    int read_count = 0;
    int read_count_ambig_tags = 0;
    int reads_with_n = 0;
    int h0 = 0;
    int h1 = 0;
    int h2 = 0;
    int not_primary = 0;

    public void count(SamReader reader) {
        this.total_nt = 0;
        this.total_n = 0;
        this.total_other = 0;
        this.read_count = 0;
        this.read_count_ambig_tags = 0;
        this.reads_with_n = 0;
        this.h0 = 0;
        this.h1 = 0;
        this.h2 = 0;
        this.not_primary = 0;
        block4: for (SAMRecord sr : reader) {
            if (++this.read_count % REPORT_INTERVAL == 0) {
                this.report();
            }
            byte[] read = sr.getReadBases();
            boolean has_n = false;
            block5: for (int i = 0; i < read.length; ++i) {
                ++this.total_nt;
                switch (read[i]) {
                    case 65: 
                    case 67: 
                    case 71: 
                    case 84: 
                    case 97: 
                    case 99: 
                    case 103: 
                    case 116: {
                        continue block5;
                    }
                    case 78: 
                    case 110: {
                        ++this.total_n;
                        has_n = true;
                        continue block5;
                    }
                    default: {
                        System.err.println("other: " + (char)read[i]);
                        ++this.total_other;
                    }
                }
            }
            if (has_n) {
                ++this.reads_with_n;
            }
            if (sr.getNotPrimaryAlignmentFlag()) {
                ++this.not_primary;
            }
            for (SAMRecord.SAMTagAndValue tav : sr.getAttributes()) {
                if (tav.tag.equals("SQ") || tav.tag.equals("E2") || tav.tag.equals("U2")) {
                    ++this.read_count_ambig_tags;
                    continue block4;
                }
                if (tav.tag.equals("H0")) {
                    ++this.h0;
                    continue;
                }
                if (tav.tag.equals("H1")) {
                    ++this.h1;
                    continue;
                }
                if (!tav.tag.equals("H2")) continue;
                ++this.h2;
            }
        }
        System.err.println("done");
        this.report();
    }

    private void report() {
        System.err.println("            reads: " + this.read_count);
        System.err.println("       reads w/Ns: " + this.reads_with_n);
        System.err.println("non-primary reads: " + this.not_primary);
        System.err.println(" reads w/SQ|E2|U2: " + this.read_count_ambig_tags);
        System.err.println("       reads w/H0: " + this.h0);
        System.err.println("       reads w/H1: " + this.h1);
        System.err.println("       reads w/H2: " + this.h2);
        System.err.println("");
        System.err.println("   total nt: " + this.total_nt);
        System.err.println("    total n: " + this.total_n);
        System.err.println("total other: " + this.total_other);
    }

    public static void main(String[] argv) {
        SAMAmbigCounter counter = new SAMAmbigCounter();
        if (argv.length == 0) {
            System.err.println("specify sam/bam file");
        } else {
            SamReader reader = SamReaderFactory.makeDefault().validationStringency(ValidationStringency.SILENT).open(new File(argv[0]));
            counter.count(reader);
        }
    }
}

