/*
 * Decompiled with CFR 0.152.
 */
package Ace2;

import Ace2.HashList;
import htsjdk.samtools.SAMRecord;
import java.util.ArrayList;
import java.util.Collections;

public class SAMCache {
    HashList<Integer, SAMRecord> plus;
    HashList<Integer, SAMRecord> minus;
    boolean VERBOSE = false;

    public SAMCache() {
        this.clear();
    }

    public void clear() {
        this.plus = new HashList();
        this.minus = new HashList();
    }

    public void add(SAMRecord sr) {
        if (!sr.getReadUnmappedFlag()) {
            HashList<Integer, SAMRecord> hash = sr.getReadNegativeStrandFlag() ? this.minus : this.plus;
            hash.add(sr.getAlignmentStart(), sr);
            if (this.VERBOSE) {
                System.err.println("save " + sr.getReadName() + " " + sr.getAlignmentStart() + " " + (sr.getReadNegativeStrandFlag() ? "-" : "+"));
            }
        }
    }

    public SAMRecord find_mate(SAMRecord sr) {
        SAMRecord result = null;
        int as = sr.getMateAlignmentStart();
        ArrayList<SAMRecord> list = sr.getMateNegativeStrandFlag() ? this.minus.get(as) : this.plus.get(as);
        String qname = sr.getReadName();
        int match_count = 0;
        if (this.VERBOSE) {
            System.err.print("want " + sr.getReadName() + " " + as + " " + (sr.getReadNegativeStrandFlag() ? "-" : "+") + "result=");
        }
        if (list != null) {
            for (SAMRecord s2 : list) {
                if (!s2.getReadName().equals(qname)) continue;
                if (this.VERBOSE) {
                    System.err.println("HIT!");
                }
                if (match_count++ > 0) {
                    System.err.println("WTF: multiple matching mates for " + qname + " at " + as + ", this_dup:" + s2.getDuplicateReadFlag() + " last_dup:" + result.getDuplicateReadFlag());
                }
                result = s2;
            }
        }
        if (result == null && this.VERBOSE) {
            System.err.println("MISS! as=" + as + " cache=" + this.get_cache_range());
        }
        return result;
    }

    public String get_cache_range() {
        ArrayList<Integer> keys = new ArrayList<Integer>(this.plus.keySet());
        Integer start = Collections.min(keys);
        Integer end = Collections.max(keys);
        return start + "-" + end;
    }
}

