/*
 * Decompiled with CFR 0.152.
 */
package Ace2;

import Ace2.AceViewerConfig;
import Ace2.Base;
import Ace2.SAMRegion;
import Ace2.SAMResource;
import htsjdk.samtools.AlignmentBlock;
import htsjdk.samtools.SAMRecord;
import java.util.Arrays;

public class SAMConsensusGenerator {
    private AceViewerConfig config;

    public SAMConsensusGenerator(AceViewerConfig config) {
        this.config = config;
    }

    public byte[] generate_consensus() {
        int i;
        SAMRegion region = this.config.sams.get(0).get_region();
        int start_base = this.config.ruler_start;
        int region_len = region.range.end - region.range.start + 1;
        int[] count_a = new int[region_len];
        int[] count_c = new int[region_len];
        int[] count_g = new int[region_len];
        int[] count_t = new int[region_len];
        Arrays.fill(count_a, 0);
        Arrays.fill(count_c, 0);
        Arrays.fill(count_g, 0);
        Arrays.fill(count_t, 0);
        byte[] result = new byte[region_len];
        Arrays.fill(result, (byte)78);
        for (SAMResource resource : this.config.sams) {
            SAMRecord[] sams = resource.get_sams();
            if (sams == null) {
                System.err.println("ERROR: no SAM records retrieved!");
                continue;
            }
            System.err.println("SAM count:" + sams.length);
            for (int si = 0; si < sams.length; ++si) {
                SAMRecord sr = sams[si];
                byte[] bases = sr.getReadBases();
                for (AlignmentBlock ab : sr.getAlignmentBlocks()) {
                    int read_i = ab.getReadStart() - 1;
                    int ref_i = ab.getReferenceStart() - start_base - 1;
                    int end = read_i + ab.getLength();
                    for (i = read_i; i < end && ref_i < region_len; ++i, ++ref_i) {
                        if (ref_i < 0) continue;
                        Base b = Base.valueOf((char)bases[i]);
                        Object bucket = null;
                        if (b.equals((Object)Base.BASE_A)) {
                            int n = ref_i;
                            count_a[n] = count_a[n] + 1;
                            continue;
                        }
                        if (b.equals((Object)Base.BASE_C)) {
                            int n = ref_i;
                            count_c[n] = count_c[n] + 1;
                            continue;
                        }
                        if (b.equals((Object)Base.BASE_G)) {
                            int n = ref_i;
                            count_g[n] = count_g[n] + 1;
                            continue;
                        }
                        if (!b.equals((Object)Base.BASE_T)) continue;
                        int n = ref_i;
                        count_t[n] = count_t[n] + 1;
                    }
                }
            }
        }
        for (i = 0; i < region_len; ++i) {
            int best_nt = 78;
            int count = count_a[i];
            int best_count = 0;
            if (count > best_count) {
                best_count = count;
                best_nt = 97;
            }
            if ((count = count_c[i]) > best_count) {
                best_count = count;
                best_nt = 99;
            }
            if ((count = count_g[i]) > best_count) {
                best_count = count;
                best_nt = 103;
            }
            if ((count = count_t[i]) > best_count) {
                best_count = count;
                best_nt = 116;
            }
            result[i] = best_nt;
        }
        return result;
    }
}

