/*
 * Decompiled with CFR 0.152.
 */
package Ace2;

import Ace2.ConsensusExtender;
import Ace2.IndelEvent;
import Ace2.SAMQuery;
import Ace2.SAMRegion;
import Ace2.WorkingFile;
import Funk.Str;
import htsjdk.samtools.AlignmentBlock;
import htsjdk.samtools.Cigar;
import htsjdk.samtools.CigarElement;
import htsjdk.samtools.CigarOperator;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordIterator;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.ValidationStringency;
import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SAMConsensusGenerator2 {
    SamReader reader;
    int MIN_READ_QUALITY = 15;
    int MIN_READS_TO_ACCEPT_INDEL = 3;
    double INDEL_COVERAGE_ACCEPT_FRACTION = 0.5;
    String fasta_tags;
    boolean EXTEND_FLANKING_REFERENCE = true;
    static final int I_A = 0;
    static final int I_C = 1;
    static final int I_G = 2;
    static final int I_T = 3;
    int[][] READ_COUNTS;

    public SAMConsensusGenerator2(SamReader reader) {
        this.reader = reader;
    }

    public SAMConsensusGenerator2(File bam_file) {
        this(SamReaderFactory.makeDefault().validationStringency(ValidationStringency.SILENT).open(bam_file));
    }

    public SAMConsensusGenerator2(String bam_file_name) {
        this(new File(bam_file_name));
    }

    public void set_extend_flanking_reference(boolean v) {
        this.EXTEND_FLANKING_REFERENCE = v;
    }

    public String generate_consensus(String ref_name) {
        HashMap<String, IndelEvent> indel_tracker = new HashMap<String, IndelEvent>();
        String result = null;
        this.fasta_tags = null;
        byte[] code2base = new byte[]{65, 67, 71, 84};
        SAMFileHeader h = this.reader.getFileHeader();
        SAMSequenceRecord ssr = h.getSequence(ref_name);
        if (ssr == null) {
            System.err.println("ERROR: no header record for " + ref_name);
        } else {
            int ref_i;
            int slen = ssr.getSequenceLength();
            this.READ_COUNTS = new int[4][slen];
            SAMQuery sq = new SAMQuery(this.reader);
            SAMRecordIterator query = sq.query(new SAMRegion(ref_name));
            int usable_count = 0;
            while (query.hasNext()) {
                int read_i;
                int len;
                SAMRecord sr = (SAMRecord)query.next();
                if (sr.getReadUnmappedFlag()) continue;
                ++usable_count;
                byte[] quals = sr.getBaseQualities();
                byte[] read = sr.getReadBases();
                for (AlignmentBlock ab : sr.getAlignmentBlocks()) {
                    len = ab.getLength();
                    read_i = ab.getReadStart() - 1;
                    ref_i = ab.getReferenceStart() - 1;
                    if (read_i < 0) {
                        System.err.println("ERROR: can't include " + sr.getReadName() + ", read_i < 0");
                        continue;
                    }
                    if (ref_i < 0) {
                        System.err.println("ERROR: can't include " + sr.getReadName() + ", ref_i < 0");
                        continue;
                    }
                    int end = read_i + len;
                    while (read_i < end) {
                        if (read_i <= quals.length && quals[read_i] >= this.MIN_READ_QUALITY) {
                            if (read[read_i] == 65 || read[read_i] == 97) {
                                int[] nArray = this.READ_COUNTS[0];
                                int n = ref_i;
                                nArray[n] = nArray[n] + 1;
                            } else if (read[read_i] == 67 || read[read_i] == 99) {
                                int[] nArray = this.READ_COUNTS[1];
                                int n = ref_i;
                                nArray[n] = nArray[n] + 1;
                            } else if (read[read_i] == 71 || read[read_i] == 103) {
                                int[] nArray = this.READ_COUNTS[2];
                                int n = ref_i;
                                nArray[n] = nArray[n] + 1;
                            } else if (read[read_i] == 84 || read[read_i] == 116) {
                                int[] nArray = this.READ_COUNTS[3];
                                int n = ref_i;
                                nArray[n] = nArray[n] + 1;
                            } else {
                                System.err.println("unknown base: " + read[read_i]);
                            }
                        }
                        ++read_i;
                        ++ref_i;
                    }
                }
                int ref_base = sr.getUnclippedStart();
                read_i = 0;
                Cigar c = sr.getCigar();
                for (CigarElement ce : c.getCigarElements()) {
                    CigarOperator co = ce.getOperator();
                    len = ce.getLength();
                    if (co.equals((Object)CigarOperator.MATCH_OR_MISMATCH) || co.equals((Object)CigarOperator.SOFT_CLIP)) {
                        ref_base += len;
                        read_i += len;
                        continue;
                    }
                    if (co.equals((Object)CigarOperator.SKIPPED_REGION)) {
                        ref_base += len;
                        continue;
                    }
                    if (co.equals((Object)CigarOperator.INSERTION)) {
                        this.bucket_indel(indel_tracker, ce, ref_base, new String(read, read_i, len));
                        read_i += len;
                        continue;
                    }
                    if (co.equals((Object)CigarOperator.DELETION)) {
                        this.bucket_indel(indel_tracker, ce, ref_base, null);
                        ref_base += len;
                        continue;
                    }
                    System.err.println("unhandled CIGAR operator " + co);
                    System.exit(1);
                }
            }
            query.close();
            if (usable_count == 0) {
                return null;
            }
            byte[] consensus = new byte[slen];
            Arrays.fill(consensus, (byte)78);
            for (ref_i = 0; ref_i < consensus.length; ++ref_i) {
                int max_i = -1;
                int max_cov = 0;
                for (int base_type = 0; base_type < 4; ++base_type) {
                    if (this.READ_COUNTS[base_type][ref_i] <= max_cov) continue;
                    max_i = base_type;
                    max_cov = this.READ_COUNTS[base_type][ref_i];
                }
                consensus[ref_i] = max_i == -1 ? 78 : code2base[max_i];
            }
            HashSet<Integer> i_deleted = new HashSet<Integer>();
            int[] indel_event_count = new int[slen];
            HashMap<Integer, IndelEvent> i_inserted = new HashMap<Integer, IndelEvent>();
            ArrayList<String> usable_ie_tags = new ArrayList<String>();
            for (IndelEvent ie : indel_tracker.values()) {
                boolean usable;
                int i_start = ie.reference_base - 2;
                int i_end = -1;
                if (ie.is_insertion()) {
                    i_end = i_start + 1;
                } else if (ie.is_deletion()) {
                    i_end = i_start + ie.length + 1;
                } else {
                    System.err.println("ERROR: say what?");
                }
                int coverage_before = this.get_coverage(i_start);
                int coverage_after = this.get_coverage(i_end);
                int coverage_avg = -1;
                if (coverage_before == -1 && coverage_after == -1) {
                    System.err.println("that's unpossible!");
                    System.exit(1);
                } else {
                    coverage_avg = coverage_before == -1 ? coverage_after : (coverage_after == -1 ? coverage_before : (coverage_before + coverage_after) / 2);
                }
                int min_required = (int)((double)coverage_avg * this.INDEL_COVERAGE_ACCEPT_FRACTION);
                boolean bl = usable = ie.count >= min_required;
                if (ie.count < this.MIN_READS_TO_ACCEPT_INDEL) {
                    usable = false;
                }
                System.err.println("event:" + ie + " coverage:" + ie.count + " flank_coverage:" + coverage_avg + " required:" + min_required + " pass:" + usable);
                if (!usable) continue;
                System.err.println("usable " + ie);
                if (ie.is_deletion()) {
                    int mask_start = ie.reference_base - 1;
                    int mask_end = mask_start + ie.length;
                    for (int i = mask_start; i < mask_end; ++i) {
                        int n = i;
                        indel_event_count[n] = indel_event_count[n] + 1;
                        i_deleted.add(i);
                    }
                } else if (ie.is_insertion()) {
                    if (ie.reference_base <= 1) {
                        System.err.println("insertion before ref start");
                        usable = false;
                    } else if (ie.reference_base >= slen) {
                        System.err.println("insertion after ref end");
                        usable = false;
                    } else {
                        int trigger_i;
                        int n = trigger_i = ie.reference_base - 1;
                        indel_event_count[n] = indel_event_count[n] + 1;
                        if (i_inserted.containsKey(trigger_i)) {
                            System.err.println("already assigned insertion at index " + trigger_i + ", ignoring additional event " + ie);
                            usable = false;
                        } else {
                            i_inserted.put(trigger_i, ie);
                        }
                    }
                }
                if (!usable) continue;
                usable_ie_tags.add(ie.toString());
            }
            StringBuilder cons = new StringBuilder();
            for (int i = 0; i < consensus.length; ++i) {
                if (i_deleted.contains(i)) {
                    System.err.println("HEY NOW: deleted base index " + i);
                    continue;
                }
                if (i_inserted.containsKey(i)) {
                    IndelEvent ie = (IndelEvent)i_inserted.get(i);
                    cons.append(ie.sequence);
                }
                cons.append((char)consensus[i]);
            }
            String extension_l = null;
            String extension_r = null;
            if (this.EXTEND_FLANKING_REFERENCE) {
                ConsensusExtender ce = new ConsensusExtender(this.reader);
                extension_l = ce.get_extension(ref_name, false);
                extension_r = ce.get_extension(ref_name, true);
            }
            String cons_main = cons.toString();
            if (extension_l == null) {
                cons_main = cons_main.replaceFirst("^[nN]+", "");
            } else {
                usable_ie_tags.add("extend_L:" + extension_l);
            }
            if (extension_r == null) {
                cons_main = cons_main.replaceFirst("[nN]+$", "");
            } else {
                usable_ie_tags.add("extend_R:" + extension_r);
            }
            if (cons_main.indexOf("N") > -1 || cons_main.indexOf("n") > -1) {
                System.err.println("WARNING: Ns in output");
            }
            result = (extension_l == null ? "" : extension_l) + cons_main + (extension_r == null ? "" : extension_r);
            this.fasta_tags = Str.join(",", usable_ie_tags);
        }
        return result;
    }

    private void bucket_indel(HashMap<String, IndelEvent> tracker, CigarElement ce, int ref_i, String sequence) {
        IndelEvent lookup = new IndelEvent(ce.getOperator(), ref_i, ce.getLength(), sequence);
        String key = lookup.get_hash_key();
        IndelEvent ie = tracker.get(key);
        if (ie == null) {
            ie = lookup;
            tracker.put(key, ie);
        }
        ++ie.count;
    }

    private int get_coverage(int index) {
        int coverage = 0;
        if (index == -1 || index >= this.READ_COUNTS[0].length) {
            coverage = -1;
        } else {
            for (int i = 0; i < 4; ++i) {
                coverage += this.READ_COUNTS[i][index];
            }
        }
        return coverage;
    }

    public ArrayList<String> get_references(String ref_match) {
        SAMFileHeader h = this.reader.getFileHeader();
        SAMSequenceDictionary ssd = h.getSequenceDictionary();
        ArrayList<String> refs = new ArrayList<String>();
        for (SAMSequenceRecord ssr : ssd.getSequences()) {
            String reference_name = ssr.getSequenceName();
            System.out.println(reference_name);
            if (ref_match != null && reference_name != null && reference_name.indexOf(ref_match) == -1) continue;
            refs.add(reference_name);
        }
        return refs;
    }

    public ArrayList<String> get_references() {
        return this.get_references(null);
    }

    public String build_fasta_string(String reference, String consensus) {
        StringBuilder sb = new StringBuilder();
        sb.append(">" + reference + " length=" + consensus.length());
        String tags = this.get_fasta_tags();
        if (tags != null) {
            sb.append(" " + tags);
        }
        sb.append(System.getProperty("line.separator"));
        sb.append(consensus);
        sb.append(System.getProperty("line.separator"));
        return sb.toString();
    }

    public static void main(String[] argv) {
        SAMConsensusGenerator2 scg = null;
        String ref_name = null;
        String outfile = null;
        String bam_file = null;
        String ref_match = null;
        for (int i = 0; i < argv.length; ++i) {
            if (argv[i].equals("-bam")) {
                bam_file = argv[++i];
                scg = new SAMConsensusGenerator2(bam_file);
                continue;
            }
            if (argv[i].equals("-ref")) {
                ref_name = new String(argv[++i]);
                continue;
            }
            if (argv[i].equals("-no-extend")) {
                scg.set_extend_flanking_reference(false);
                continue;
            }
            if (argv[i].equals("-ref-match")) {
                ref_match = argv[++i];
                continue;
            }
            if (!argv[i].equals("-out")) continue;
            outfile = argv[++i];
        }
        if (outfile == null) {
            outfile = bam_file + ".consensus.fa";
        }
        if (scg == null) {
            SAMConsensusGenerator2.usage();
        } else {
            try {
                ArrayList<String> refs = null;
                if (ref_name != null) {
                    refs = new ArrayList();
                    refs.add(ref_name);
                } else {
                    refs = scg.get_references();
                }
                System.err.println("references to query: " + refs.size());
                WorkingFile wf = new WorkingFile(outfile);
                PrintStream ps = wf.getPrintStream();
                int qcount = 0;
                for (String rn : refs) {
                    System.err.println("query " + ++qcount + " " + rn);
                    String cons = scg.generate_consensus(rn);
                    if (cons == null) continue;
                    ps.print(scg.build_fasta_string(rn, cons));
                }
                wf.finish();
            }
            catch (Exception e) {
                System.err.println("ERROR: " + e);
                e.printStackTrace();
            }
        }
    }

    private static void usage() {
        System.err.println("usage: SAMConsensusGenerator2 -bam [bamfile] [-ref [reference_name]]");
        System.exit(1);
    }

    public String get_fasta_tags() {
        return this.fasta_tags;
    }
}

