/*
 * Decompiled with CFR 0.152.
 */
package Ace2;

import Ace2.PadMap;
import Ace2.SAMConsensusMapping;
import Ace2.UniqueReadName;
import htsjdk.samtools.Cigar;
import htsjdk.samtools.CigarElement;
import htsjdk.samtools.CigarOperator;
import htsjdk.samtools.SAMRecord;
import java.io.IOException;

public class SAMConsensusMapFactory {
    private char[] consensus;
    private byte[] reference_sequence;
    private PadMap pm;
    private int start_offset = 0;
    private UniqueReadName urn;
    private boolean is_prepadded;
    private static final int MIN_HIGH_QUALITY = 20;
    private static final int NULL_HACK = -123456;
    private static final boolean VERBOSE = false;

    public SAMConsensusMapFactory(char[] consensus, byte[] reference_sequence, PadMap pm, int start_offset, boolean is_prepadded) {
        this.consensus = consensus;
        this.reference_sequence = reference_sequence;
        this.pm = pm;
        this.start_offset = start_offset;
        this.is_prepadded = is_prepadded;
        this.urn = new UniqueReadName();
    }

    public SAMConsensusMapping map(SAMRecord sr) throws IOException {
        int i;
        CigarOperator co;
        int ci;
        if (this.is_prepadded) {
            return this.map_prepadded(sr);
        }
        int sou = sr.getUnclippedStart() - this.start_offset;
        int ri = 0;
        int first_aligned_ri = -123456;
        boolean custom_sequence = false;
        Cigar c = sr.getCigar();
        if (sou < 1) {
            ci = sou;
            custom_sequence = true;
        } else {
            ci = this.pm.get_unpadded_to_padded(sou);
        }
        for (CigarElement ce : c.getCigarElements()) {
            co = ce.getOperator();
            if (co.equals((Object)CigarOperator.INSERTION)) {
                if ((ci -= ce.getLength()) == -123456 || ci < 0) continue;
                first_aligned_ri = 0;
                continue;
            }
            if (co.equals((Object)CigarOperator.MATCH_OR_MISMATCH) || co.equals((Object)CigarOperator.HARD_CLIP) || co.equals((Object)CigarOperator.EQ) || co.equals((Object)CigarOperator.X) || co.equals((Object)CigarOperator.SOFT_CLIP)) break;
            System.err.println("WARNING: blowing off CIGAR operator " + co);
        }
        SAMConsensusMapping scm = new SAMConsensusMapping(sr);
        scm.asm_start_padded = ci < 1 ? 1 : ci;
        --ci;
        scm.suffix = this.urn.get_suffix(sr.getReadName(), sr.getReadNegativeStrandFlag());
        byte[] read = sr.getReadBases();
        StringBuffer aligned = new StringBuffer();
        int first_insertion_cpos = -123456;
        int last_insertion_cpos = -123456;
        int first_soft_clip_cpos = -123456;
        block1: for (CigarElement ce : c.getCigarElements()) {
            co = ce.getOperator();
            int len = ce.getLength();
            if (co.equals((Object)CigarOperator.MATCH_OR_MISMATCH) || co.equals((Object)CigarOperator.SOFT_CLIP) || co.equals((Object)CigarOperator.EQ) || co.equals((Object)CigarOperator.X)) {
                if (co.equals((Object)CigarOperator.SOFT_CLIP) && first_soft_clip_cpos == -123456) {
                    first_soft_clip_cpos = ci + this.start_offset;
                }
                while (i < len && ci < this.consensus.length) {
                    if (ci < 0) {
                        ++ci;
                        ++ri;
                        custom_sequence = true;
                    } else if (this.consensus[ci++] == '*') {
                        aligned.append('*');
                        --i;
                        custom_sequence = true;
                    } else {
                        if (ri >= read.length) {
                            System.err.println("WTF: ri past end of read for " + sr.getReadName() + "." + scm.suffix);
                            continue block1;
                        }
                        if (first_aligned_ri == -123456) {
                            first_aligned_ri = ri;
                        }
                        aligned.append((char)read[ri++]);
                    }
                    ++i;
                }
                continue;
            }
            if (co.equals((Object)CigarOperator.HARD_CLIP)) {
                custom_sequence = true;
                for (i = 0; i < len && ci < this.consensus.length; ++i) {
                    if (ci < 0) {
                        ++ci;
                        continue;
                    }
                    if (this.consensus[ci++] == '*') {
                        aligned.append('_');
                        --i;
                        continue;
                    }
                    aligned.append('_');
                }
                continue;
            }
            if (co.equals((Object)CigarOperator.PADDING)) continue;
            if (co.equals((Object)CigarOperator.INSERTION)) {
                int start = ci + this.start_offset;
                int end = ci + (len - 1) + this.start_offset;
                if (first_insertion_cpos == -123456) {
                    first_insertion_cpos = start;
                }
                if (end > last_insertion_cpos) {
                    last_insertion_cpos = end;
                }
                while (i < len) {
                    if (ci < 0) {
                        ++ri;
                        custom_sequence = true;
                    } else {
                        if (first_aligned_ri == -123456) {
                            first_aligned_ri = ri;
                        }
                        aligned.append((char)read[ri++]);
                        if (ci >= this.consensus.length) continue block1;
                        if (this.consensus[ci] != '*') {
                            System.err.println("WTF: insertion not reflected in consensus! at " + (ci + this.start_offset) + " for " + sr.getReadName());
                        }
                        ++ci;
                    }
                    ++i;
                }
                continue;
            }
            if (co.equals((Object)CigarOperator.DELETION) || co.equals((Object)CigarOperator.SKIPPED_REGION)) {
                custom_sequence = true;
                char marker = co.equals((Object)CigarOperator.DELETION) ? (char)'-' : (sr.getReadNegativeStrandFlag() ? (char)'<' : '>');
                while (i < len && ci < this.consensus.length) {
                    if (ci >= 0) {
                        if (this.consensus[ci] == '*') {
                            --i;
                            aligned.append(co.equals((Object)CigarOperator.DELETION) ? (char)'*' : marker);
                        } else {
                            aligned.append(marker);
                        }
                    }
                    ++i;
                    ++ci;
                }
                continue;
            }
            throw new IOException("ERROR: unhandled SAM operator " + co);
        }
        int cs = sr.getAlignmentStart();
        if (first_insertion_cpos != -123456 && first_insertion_cpos < cs) {
            cs = first_insertion_cpos;
        }
        scm.clip_start_padded = this.translate_clip_base(cs);
        int ce = sr.getAlignmentEnd();
        if (last_insertion_cpos != -123456 && last_insertion_cpos > ce) {
            ce = last_insertion_cpos;
        }
        scm.clip_end_padded = this.translate_clip_base(ce);
        scm.asm_end_padded = ci;
        char[] padded = aligned.toString().toCharArray();
        scm.padded_sequence = new byte[padded.length];
        for (i = 0; i < padded.length; ++i) {
            scm.padded_sequence[i] = (byte)padded[i];
        }
        byte[] quals = sr.getBaseQualities();
        scm.padded_quality = new byte[scm.padded_sequence.length];
        if (first_aligned_ri > 0) {
            custom_sequence = true;
        }
        int qi = first_aligned_ri > 0 ? first_aligned_ri : 0;
        for (i = 0; i < scm.padded_sequence.length; ++i) {
            if (scm.padded_sequence[i] == 42 || scm.padded_sequence[i] == 95 || scm.padded_sequence[i] == 45 || scm.padded_sequence[i] == 37 || scm.padded_sequence[i] == 62 || scm.padded_sequence[i] == 60) {
                scm.padded_quality[i] = -1;
                custom_sequence = true;
                continue;
            }
            if (qi >= quals.length) {
                System.err.println("ERROR: quality info out of bounds for " + sr.getReadName());
                scm.padded_quality[i] = -1;
                continue;
            }
            scm.padded_quality[i] = quals[qi++];
        }
        if (!custom_sequence) {
            scm.padded_quality = null;
            scm.padded_sequence = null;
        }
        return scm;
    }

    public SAMConsensusMapping map_prepadded(SAMRecord sr) throws IOException {
        int i;
        CigarOperator co;
        int ci;
        int sou = sr.getUnclippedStart() - this.start_offset;
        int ri = 0;
        int first_aligned_ri = -123456;
        boolean custom_sequence = false;
        Cigar c = sr.getCigar();
        if (sou < 1) {
            System.err.println("alignment starts before 1st consensus base");
            ci = sou;
            custom_sequence = true;
        } else {
            ci = sou;
        }
        for (CigarElement ce : c.getCigarElements()) {
            co = ce.getOperator();
            if (co.equals((Object)CigarOperator.INSERTION)) {
                if ((ci -= ce.getLength()) == -123456 || ci < 0) continue;
                first_aligned_ri = 0;
                continue;
            }
            if (co.equals((Object)CigarOperator.MATCH_OR_MISMATCH) || co.equals((Object)CigarOperator.HARD_CLIP) || co.equals((Object)CigarOperator.EQ) || co.equals((Object)CigarOperator.X) || co.equals((Object)CigarOperator.SOFT_CLIP)) break;
            System.err.println("WARNING: blowing off CIGAR operator " + co);
        }
        SAMConsensusMapping scm = new SAMConsensusMapping(sr);
        scm.asm_start_padded = ci < 1 ? 1 : ci;
        --ci;
        scm.suffix = this.urn.get_suffix(sr.getReadName(), sr.getReadNegativeStrandFlag());
        byte[] read = sr.getReadBases();
        StringBuffer aligned = new StringBuffer();
        int first_insertion_cpos = -123456;
        int last_insertion_cpos = -123456;
        int first_soft_clip_cpos = -123456;
        block1: for (CigarElement ce : c.getCigarElements()) {
            co = ce.getOperator();
            int len = ce.getLength();
            if (co.equals((Object)CigarOperator.MATCH_OR_MISMATCH) || co.equals((Object)CigarOperator.SOFT_CLIP) || co.equals((Object)CigarOperator.EQ) || co.equals((Object)CigarOperator.X)) {
                if (co.equals((Object)CigarOperator.SOFT_CLIP) && first_soft_clip_cpos == -123456) {
                    first_soft_clip_cpos = ci + this.start_offset;
                }
                while (i < len && ci < this.consensus.length) {
                    if (ci < 0) {
                        ++ci;
                        ++ri;
                        custom_sequence = true;
                    } else {
                        if (ri >= read.length) {
                            System.err.println("WTF: ri past end of read for " + sr.getReadName() + "." + scm.suffix);
                            continue block1;
                        }
                        if (first_aligned_ri == -123456) {
                            first_aligned_ri = ri;
                        }
                        aligned.append((char)read[ri++]);
                        ++ci;
                    }
                    ++i;
                }
                continue;
            }
            if (co.equals((Object)CigarOperator.HARD_CLIP)) {
                custom_sequence = true;
                for (i = 0; i < len && ci < this.consensus.length; ++i) {
                    if (ci < 0) {
                        ++ci;
                        continue;
                    }
                    if (this.consensus[ci++] == '*') {
                        aligned.append('_');
                        --i;
                        continue;
                    }
                    aligned.append('_');
                }
                continue;
            }
            if (co.equals((Object)CigarOperator.PADDING)) continue;
            if (co.equals((Object)CigarOperator.INSERTION)) {
                System.err.println("WTF: insertion in pre-padded alignment!");
                continue;
            }
            if (co.equals((Object)CigarOperator.DELETION) || co.equals((Object)CigarOperator.SKIPPED_REGION)) {
                custom_sequence = true;
                char marker = co.equals((Object)CigarOperator.DELETION) ? (char)'-' : (sr.getReadNegativeStrandFlag() ? (char)'<' : '>');
                while (i < len && ci < this.consensus.length) {
                    if (ci >= 0) {
                        aligned.append(marker);
                    }
                    ++i;
                    ++ci;
                }
                continue;
            }
            throw new IOException("ERROR: unhandled SAM operator " + co);
        }
        int cs = sr.getAlignmentStart();
        if (first_insertion_cpos != -123456 && first_insertion_cpos < cs) {
            cs = first_insertion_cpos;
        }
        scm.clip_start_padded = this.translate_clip_base_prepadded(cs);
        int ce = sr.getAlignmentEnd();
        if (last_insertion_cpos != -123456 && last_insertion_cpos > ce) {
            ce = last_insertion_cpos;
        }
        scm.clip_end_padded = this.translate_clip_base_prepadded(ce);
        scm.asm_end_padded = ci;
        char[] padded = aligned.toString().toCharArray();
        scm.padded_sequence = new byte[padded.length];
        for (i = 0; i < padded.length; ++i) {
            scm.padded_sequence[i] = (byte)padded[i];
        }
        byte[] quals = sr.getBaseQualities();
        scm.padded_quality = new byte[scm.padded_sequence.length];
        if (first_aligned_ri > 0) {
            custom_sequence = true;
        }
        int qi = first_aligned_ri > 0 ? first_aligned_ri : 0;
        for (i = 0; i < scm.padded_sequence.length; ++i) {
            if (scm.padded_sequence[i] == 42 || scm.padded_sequence[i] == 95 || scm.padded_sequence[i] == 45 || scm.padded_sequence[i] == 37 || scm.padded_sequence[i] == 62 || scm.padded_sequence[i] == 60) {
                scm.padded_quality[i] = -1;
                custom_sequence = true;
                continue;
            }
            if (qi >= quals.length) {
                System.err.println("ERROR: quality info out of bounds for " + sr.getReadName());
                scm.padded_quality[i] = -1;
                continue;
            }
            scm.padded_quality[i] = quals[qi++];
        }
        if (!custom_sequence) {
            scm.padded_quality = null;
            scm.padded_sequence = null;
        }
        return scm;
    }

    public static void main(String[] argv) {
    }

    private int translate_clip_base_prepadded(int unpadded_base_num) {
        int clip_base = unpadded_base_num - this.start_offset;
        return clip_base < 1 ? 1 : clip_base;
    }

    private int translate_clip_base(int unpadded_base_num) {
        int clip_base;
        int sou = unpadded_base_num - this.start_offset;
        int mup = this.pm.get_max_unpadded();
        if (sou < 1) {
            clip_base = sou;
        } else if (sou > mup) {
            int mapped = this.pm.get_unpadded_to_padded(mup);
            if (mapped == -999999) {
                System.err.println("ERROR: bogus map translation position");
            }
            int extra = sou - mup;
            clip_base = mapped + extra;
        } else {
            clip_base = this.pm.get_unpadded_to_padded(sou);
            if (clip_base == -999999) {
                System.err.println("ERROR: bogus map translation position");
            }
        }
        return clip_base < 1 ? 1 : clip_base;
    }
}

