/*
 * Decompiled with CFR 0.152.
 */
package Ace2;

import Ace2.AssemblySequence;
import htsjdk.samtools.SAMRecord;
import java.util.Arrays;

public class SAMConsensusMapping
implements AssemblySequence {
    byte[] padded_sequence = null;
    byte[] padded_quality = null;
    int asm_start_padded;
    int asm_end_padded;
    int clip_start_padded;
    int clip_end_padded;
    String suffix;
    SAMRecord sr;

    public SAMConsensusMapping(SAMRecord sr) {
        this.sr = sr;
    }

    public String get_name() {
        return this.sr.getReadName() + "." + this.suffix;
    }

    public int get_asm_start() {
        return this.asm_start_padded;
    }

    public int get_asm_end() {
        return this.asm_end_padded;
    }

    public int get_clip_start() {
        return this.clip_start_padded;
    }

    public int get_clip_end() {
        return this.clip_end_padded;
    }

    public boolean is_complemented() {
        return this.sr.getReadNegativeStrandFlag();
    }

    public byte[] get_sequence_buffer() {
        return this.padded_sequence == null ? this.sr.getReadBases() : this.padded_sequence;
    }

    public byte[] get_quality_buffer() {
        return this.padded_quality == null ? this.sr.getBaseQualities() : this.padded_quality;
    }

    public void get_visible_sequence(char[] buf, int csv) {
        int end_index;
        int start_index;
        int chunk_size = buf.length;
        byte[] seq_buf = this.get_sequence_buffer();
        Arrays.fill(buf, ' ');
        int leading_pads = this.asm_start_padded - csv;
        if (leading_pads < 0) {
            leading_pads = 0;
        }
        if ((start_index = csv - this.asm_start_padded) < 0) {
            start_index = 0;
        }
        if ((end_index = start_index + (chunk_size - leading_pads)) > seq_buf.length) {
            end_index = seq_buf.length;
        }
        int si = start_index;
        int ti = leading_pads;
        for (si = start_index; si < end_index; ++si) {
            buf[ti++] = (char)seq_buf[si];
        }
    }

    public int get_quality(int cpos) {
        int i = cpos - this.asm_start_padded;
        byte[] qual_buf = this.get_quality_buffer();
        int qual = i < 0 || i >= qual_buf.length ? -1 : qual_buf[i];
        return qual;
    }

    public char get_base(int cpos) {
        byte[] seq_buf = this.get_sequence_buffer();
        int i = cpos - this.asm_start_padded;
        char result = i < 0 || i >= seq_buf.length ? (char)' ' : (char)seq_buf[i];
        return result;
    }

    public SAMRecord get_samrecord() {
        return this.sr;
    }

    public int get_padded_index(int cpos) {
        return cpos - this.get_asm_start();
    }

    public void apply_alignment_shift(int shift_bases) {
        this.asm_start_padded += shift_bases;
        this.clip_start_padded += shift_bases;
        this.apply_end_shift(shift_bases);
    }

    public void apply_end_shift(int shift_bases) {
        this.asm_end_padded += shift_bases;
        this.clip_end_padded += shift_bases;
    }

    public void set_sequence_buffer(byte[] buf) {
        this.padded_sequence = buf;
    }

    public void set_quality_buffer(byte[] buf) {
        this.padded_quality = buf;
    }
}

