/*
 * Decompiled with CFR 0.152.
 */
package Ace2;

import Ace2.IndelInfo;
import Ace2.SAMIndelFilter;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.ValidationStringency;
import java.io.File;
import java.io.IOException;

public class SAMDumpIndels {
    private static int MIN_QUALITY = 15;

    public void report(SamReader reader) throws IOException {
        SAMIndelFilter sif = new SAMIndelFilter();
        for (SAMRecord sr : reader) {
            if (!sif.filter(sr)) continue;
            String name = sr.getReadName();
            for (IndelInfo ii : sif.get_indels()) {
                System.out.println(sr.getReadName() + "," + ii.indel_type + "," + ii.length);
            }
        }
    }

    public static void main(String[] argv) {
        try {
            SAMDumpIndels rpt = new SAMDumpIndels();
            SamReader reader = SamReaderFactory.makeDefault().validationStringency(ValidationStringency.SILENT).open(new File(argv[0]));
            rpt.report(reader);
        }
        catch (Exception e) {
            System.err.println("ERROR: " + e);
        }
    }
}

