/*
 * Decompiled with CFR 0.152.
 */
package Ace2;

import Ace2.Chromosome;
import Ace2.IndelInfo;
import Ace2.MultiplexedWriter;
import Ace2.NIB;
import Ace2.SAMIndelFilter;
import Ace2.SAMMismatchFilter;
import Ace2.SAMUtils;
import Ace2.UniqueReadName;
import Ace2.WorkingDirectory;
import Ace2.WorkingFile;
import Funk.Str;
import Funk.Sys;
import Funk.Timer;
import htsjdk.samtools.CigarOperator;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileWriter;
import htsjdk.samtools.SAMFileWriterFactory;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordIterator;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.ValidationStringency;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SAMExtractUnmapped {
    private File sam_file;
    private String report_basename;
    private static int HQ_MISMATCH_EXTRACT_THRESHOLD = 4;
    private static int HQ_MISMATCH_WINDOW_SIZE = HQ_MISMATCH_EXTRACT_THRESHOLD * 3;
    private static String SAM_INTERESTING_TAG = "XU";
    public static final int FLAG_HAS_HQMM = 1;
    public static final int FLAG_HAS_HQMM_SC = 2;
    public static final int FLAG_HAS_HQMM_EC = 4;
    public static final int FLAG_HAS_HQ_INSERTION = 8;
    public static final int FLAG_HAS_HQ_DELETION = 16;
    private int TRACKER_BUCKET_SIZE = 1000000;
    private int MAX_FILEHANDLES = 100;
    private static boolean VERBOSE = false;
    private static boolean EXTRACT_INDELS = true;
    private static boolean EXTRACT_DUPLICATES = true;
    private static boolean QUERY_UNMAPPED = false;
    private static boolean PASS_1_ONLY = false;
    private static boolean PASS_2_ONLY = false;
    private static boolean WRITE_BAM = false;
    private static boolean ENABLE_READ_LIMIT = false;
    private static int READ_LIMIT = 0;
    private static boolean EXTRACT_INTERESTING_MATES = true;
    private static boolean REMOVE_INTERMEDIATE_FILES = true;
    private static boolean SORT_RESULTS = true;
    private static String OUT_DIR = null;
    private String CURRENT_REFERENCE_NAME = null;
    private boolean USABLE_REFERENCE_SEQUENCE;
    private SAMMismatchFilter MMF = null;
    private File temp_dir = null;
    private static String UNMAPPED_IDS_TAG = ".unmapped_ids.";
    private static String INTERESTING_IDS_TAG = ".interesting_ids.";

    public SAMExtractUnmapped(File sam_file, String report_basename) {
        this.sam_file = sam_file;
        this.report_basename = report_basename;
    }

    public void set_temp_dir(File temp_dir) {
        this.temp_dir = temp_dir;
    }

    public void report() throws FileNotFoundException, IOException {
        HashSet<String> warned_ref;
        long read_count = 0L;
        long duplicate_count = 0L;
        long mapped_count = 0L;
        long unmapped_count = 0L;
        int unmapped_without_pairing_count = 0;
        int unmapped_with_mapped_mates = 0;
        boolean pass_1_enabled = true;
        boolean pass_2_enabled = true;
        if (PASS_1_ONLY) {
            pass_2_enabled = false;
        }
        if (PASS_2_ONLY) {
            pass_1_enabled = false;
        }
        if (WRITE_BAM && (PASS_1_ONLY || PASS_2_ONLY)) {
            System.err.println("ERROR: bam output must use combined pass");
            System.exit(1);
        }
        SamReader reader = SamReaderFactory.makeDefault().validationStringency(ValidationStringency.SILENT).open(this.sam_file);
        SAMRecordIterator query = QUERY_UNMAPPED ? reader.queryUnmapped() : reader.iterator();
        HashMap<Integer, Integer> lengths = new HashMap<Integer, Integer>();
        SAMIndelFilter sif = new SAMIndelFilter();
        UniqueReadName urn = new UniqueReadName();
        urn.set_inthash_mode(true, 19);
        String base_fn = null;
        WorkingDirectory wd = null;
        if (this.temp_dir == null) {
            base_fn = this.report_basename;
        } else if (PASS_1_ONLY || PASS_2_ONLY) {
            System.err.println("ERROR: -temp-dir not compatible w/partial processing");
            System.exit(1);
        } else {
            File f = new File(this.report_basename).getCanonicalFile();
            File parent = f.getParentFile();
            File target_dir = parent == null ? new File(".") : parent;
            wd = new WorkingDirectory(this.temp_dir, target_dir);
            base_fn = wd.get_file(f.getName()).getCanonicalPath();
        }
        MultiplexedWriter mw_paired_reads = null;
        SAMFileWriter sfw = null;
        String bam_fn = null;
        if (WRITE_BAM) {
            bam_fn = base_fn + ".seu.unsorted.bam";
            File outfile = new File(bam_fn);
            SAMFileHeader header_in = reader.getFileHeader();
            sfw = new SAMFileWriterFactory().makeBAMWriter(header_in, false, outfile, 1);
        } else {
            mw_paired_reads = new MultiplexedWriter(base_fn + ".mate_mapped.fastq.", false);
        }
        MultiplexedWriter mw_unmapped_ids = new MultiplexedWriter(base_fn + UNMAPPED_IDS_TAG, false);
        mw_unmapped_ids.set_bucket_size(this.TRACKER_BUCKET_SIZE);
        mw_unmapped_ids.set_max_open_filehandles(this.MAX_FILEHANDLES);
        MultiplexedWriter mw_interesting = new MultiplexedWriter(base_fn + ".interesting_ids.", false);
        mw_interesting.set_bucket_size(this.TRACKER_BUCKET_SIZE);
        mw_interesting.set_max_open_filehandles(this.MAX_FILEHANDLES);
        if (pass_1_enabled) {
            System.err.println("starting pass 1");
            WorkingFile wf_mate_unmapped = null;
            PrintStream ps_mate_unmapped = null;
            if (!WRITE_BAM) {
                wf_mate_unmapped = new WorkingFile(base_fn + ".mate_unmapped.fastq");
                ps_mate_unmapped = wf_mate_unmapped.getPrintStream();
            }
            Timer t = new Timer("time_before_first_unmapped");
            boolean start_time_reported = false;
            warned_ref = new HashSet<String>();
            while (query.hasNext()) {
                SAMRecord sr = (SAMRecord)query.next();
                if (ENABLE_READ_LIMIT && ++read_count > (long)READ_LIMIT) {
                    System.err.println("read limit enabled: stopping at read #" + read_count);
                    break;
                }
                if (sr.getDuplicateReadFlag()) {
                    ++duplicate_count;
                    if (!EXTRACT_DUPLICATES) continue;
                }
                String name = sr.getReadName();
                Integer length = sr.getReadLength();
                Integer count = (Integer)lengths.get(length);
                if (count == null) {
                    count = 0;
                }
                lengths.put(length, count + 1);
                if (sr.getReadUnmappedFlag()) {
                    String rname;
                    ++unmapped_count;
                    if (!start_time_reported) {
                        t.finish();
                        start_time_reported = true;
                    }
                    String info = name + "." + urn.get_suffix(name, sr.getReadNegativeStrandFlag());
                    ArrayList<String> stuff = new ArrayList<String>();
                    stuff.add("unmapped");
                    stuff.add("flags");
                    stuff.add(Integer.toString(sr.getFlags()));
                    if (sr.getDuplicateReadFlag()) {
                        stuff.add("duplicate");
                    }
                    if (!sr.getReadPairedFlag()) {
                        stuff.add("unpaired");
                        ++unmapped_without_pairing_count;
                        if (WRITE_BAM) {
                            sfw.addAlignment(sr);
                            continue;
                        }
                        SAMUtils.write_fastq(ps_mate_unmapped, sr, info, stuff);
                        continue;
                    }
                    if (sr.getMateUnmappedFlag()) {
                        stuff.add("mate_unmapped");
                        if (WRITE_BAM) {
                            sfw.addAlignment(sr);
                            continue;
                        }
                        SAMUtils.write_fastq(ps_mate_unmapped, sr, info, stuff);
                        continue;
                    }
                    stuff.add("has_mapped_mate");
                    stuff.add(SAMUtils.bucket_reference_name(sr.getMateReferenceName(), false));
                    stuff.add(Integer.toString(sr.getMateAlignmentStart()));
                    stuff.add(sr.getMateNegativeStrandFlag() ? "-" : "+");
                    String mate_refname = SAMUtils.bucket_reference_name(sr.getMateReferenceName(), true);
                    if (mate_refname.equals("other") && !warned_ref.contains(rname = sr.getMateReferenceName())) {
                        System.err.println("non-standard mapped mate reference name " + rname + " for read " + SAMUtils.get_printable_read_name(sr) + " (only warning)");
                        warned_ref.add(rname);
                    }
                    mw_unmapped_ids.write_bucketed(mate_refname, sr.getMateAlignmentStart(), name);
                    ++unmapped_with_mapped_mates;
                    if (WRITE_BAM) {
                        sfw.addAlignment(sr);
                        continue;
                    }
                    SAMUtils.write_fastq(mw_paired_reads.getPrintStream(mate_refname), sr, info, stuff);
                    continue;
                }
                if (this.interesting_check(sr, sif, null) > 0) {
                    if (VERBOSE) {
                        System.err.println("interesting mapped read " + sr.getReferenceName() + " " + sr.getAlignmentStart());
                    }
                    mw_interesting.write_bucketed(SAMUtils.bucket_reference_name(sr.getReferenceName(), true), sr.getAlignmentStart(), name);
                    if (EXTRACT_INTERESTING_MATES && sr.getReadPairedFlag() && !sr.getMateUnmappedFlag()) {
                        if (VERBOSE) {
                            System.err.println("  mate mapped to " + sr.getMateReferenceName() + " " + sr.getMateAlignmentStart());
                        }
                        mw_interesting.write_bucketed(SAMUtils.bucket_reference_name(sr.getMateReferenceName(), true), sr.getMateAlignmentStart(), name);
                    }
                }
                ++mapped_count;
            }
            mw_unmapped_ids.finish();
            mw_interesting.finish();
            System.err.println("pass 1 complete");
            System.err.println("  unmapped count: " + unmapped_count);
            System.err.println("  unmapped w/mapped mates: " + unmapped_with_mapped_mates);
            if (wf_mate_unmapped != null) {
                wf_mate_unmapped.finish();
            }
        } else {
            System.err.println("pass 1 disabled");
        }
        if (pass_2_enabled) {
            reader = SamReaderFactory.makeDefault().validationStringency(ValidationStringency.SILENT).open(this.sam_file);
            String last_refname = null;
            int last_bucket = -1;
            HashSet<String> unmapped_pair_ids = null;
            HashSet<String> interesting_pair_ids = null;
            PrintStream ps = null;
            warned_ref = new HashSet();
            read_count = 0L;
            for (SAMRecord sr : reader) {
                String name;
                String rname;
                if (sr.getReadUnmappedFlag()) continue;
                if (ENABLE_READ_LIMIT && ++read_count > (long)READ_LIMIT) {
                    System.err.println("read limit enabled: stopping at read #" + read_count);
                    break;
                }
                if (!EXTRACT_DUPLICATES && sr.getDuplicateReadFlag()) continue;
                String refname = SAMUtils.bucket_reference_name(sr.getReferenceName(), true);
                if (refname.equals("other") && !warned_ref.contains(rname = sr.getReferenceName())) {
                    System.err.println("non-standard reference name " + rname + " for read " + SAMUtils.get_printable_read_name(sr) + " (only warning)");
                    warned_ref.add(rname);
                }
                boolean need_id_update = false;
                int as = sr.getAlignmentStart();
                if (last_refname == null || !last_refname.equals(refname)) {
                    need_id_update = true;
                    if (!WRITE_BAM) {
                        ps = mw_paired_reads.getPrintStream(refname);
                    }
                    last_refname = refname;
                } else {
                    int bn = mw_unmapped_ids.get_bucket_number(as);
                    if (last_bucket != bn) {
                        need_id_update = true;
                        last_bucket = bn;
                    }
                }
                if (need_id_update) {
                    unmapped_pair_ids = mw_unmapped_ids.getBucketedHashSet(refname, as);
                    interesting_pair_ids = mw_interesting.getBucketedHashSet(refname, as);
                    System.err.println("ID set size for " + refname + " @ " + as + "/" + last_bucket + " unmapped=" + unmapped_pair_ids.size() + " interesting=" + interesting_pair_ids.size());
                }
                boolean usable = false;
                ArrayList<String> stuff = new ArrayList<String>();
                if (sr.getDuplicateReadFlag()) {
                    stuff.add("duplicate");
                }
                if (sr.getReadPairedFlag() && !sr.getMateUnmappedFlag()) {
                    stuff.add("mate");
                    stuff.add(SAMUtils.bucket_reference_name(sr.getMateReferenceName(), false));
                    stuff.add(Integer.toString(sr.getMateAlignmentStart()));
                }
                if (unmapped_pair_ids.contains(name = sr.getReadName())) {
                    usable = true;
                    stuff.add("has_unmapped_mate");
                }
                if (interesting_pair_ids.contains(name)) {
                    usable = true;
                }
                if (!usable) continue;
                int seu_flags = this.interesting_check(sr, sif, stuff);
                stuff.add("alignEnd");
                stuff.add(Integer.toString(sr.getAlignmentEnd()));
                stuff.add("flags");
                stuff.add(Integer.toString(sr.getFlags()));
                String tag = null;
                if (stuff.size() > 0) {
                    tag = Str.join(",", stuff);
                }
                String info = name + "." + urn.get_suffix(name, sr.getReadNegativeStrandFlag());
                info = info + " mapped," + SAMUtils.bucket_reference_name(sr.getReferenceName(), false) + "," + sr.getAlignmentStart() + "," + (sr.getReadNegativeStrandFlag() ? "-" : "+") + "," + (tag == null ? "" : tag);
                if (WRITE_BAM) {
                    sr.setAttribute(SAM_INTERESTING_TAG, (Object)seu_flags);
                    sfw.addAlignment(sr);
                    continue;
                }
                SAMUtils.write_fastq(ps, sr, info);
            }
        } else {
            System.err.println("pass 2 disabled");
        }
        if (mw_paired_reads != null) {
            mw_paired_reads.finish();
        }
        if (sfw != null) {
            sfw.close();
        }
        if (pass_1_enabled && pass_2_enabled) {
            if (REMOVE_INTERMEDIATE_FILES) {
                mw_unmapped_ids.delete();
                mw_interesting.delete();
            }
            if (WRITE_BAM && SORT_RESULTS) {
                String sorted_bam_bn = base_fn + ".seu.sorted";
                ArrayList<String> commands = new ArrayList<String>();
                commands.add("/bin/env samtools sort " + bam_fn + " " + sorted_bam_bn);
                commands.add("/bin/env samtools index " + sorted_bam_bn + ".bam");
                for (String cmd : commands) {
                    int exit = Sys.exec_command(cmd, true);
                    if (exit == 0) continue;
                    System.err.println("ERROR: command exited with code " + exit);
                }
            }
            System.err.println("read count: " + read_count);
            System.err.println("optical/pcr duplicate count: " + duplicate_count);
            System.err.println("mapped count: " + mapped_count);
            System.err.println("unmapped count: " + unmapped_count);
            System.err.println("unmapped reads without pairing info: " + unmapped_without_pairing_count);
            System.err.println("read lengths:");
            for (Integer len : lengths.keySet()) {
                System.err.println("  " + len + ": " + lengths.get(len));
            }
        } else {
            System.err.println("only partial processing, so not deleting read ID files");
        }
        if (wd != null) {
            wd.finish();
        }
    }

    public static void main(String[] argv) {
        String bam_file = null;
        boolean span_test = false;
        File temp_dir = null;
        for (int i = 0; i < argv.length; ++i) {
            if (argv[i].equals("-bam")) {
                bam_file = new String(argv[++i]);
                continue;
            }
            if (argv[i].equals("-nib")) {
                NIB.DEFAULT_NIB_DIR = new String(argv[++i]);
                continue;
            }
            if (argv[i].equals("-query-unmapped")) {
                QUERY_UNMAPPED = true;
                continue;
            }
            if (argv[i].equals("-pass-1-only")) {
                PASS_1_ONLY = true;
                continue;
            }
            if (argv[i].equals("-pass-2-only")) {
                PASS_2_ONLY = true;
                continue;
            }
            if (argv[i].equals("-write-bam")) {
                WRITE_BAM = true;
                continue;
            }
            if (argv[i].equals("-cleanup")) {
                SAMExtractUnmapped.clean_tempfiles();
                System.exit(0);
                continue;
            }
            if (argv[i].equals("-limit")) {
                ENABLE_READ_LIMIT = true;
                READ_LIMIT = Integer.parseInt(argv[++i]);
                continue;
            }
            if (argv[i].equals("-no-sort")) {
                SORT_RESULTS = false;
                continue;
            }
            if (argv[i].equals("-no-indels")) {
                EXTRACT_INDELS = false;
                continue;
            }
            if (argv[i].equals("-no-interesting-mates")) {
                EXTRACT_INTERESTING_MATES = false;
                continue;
            }
            if (argv[i].equals("-no-clean")) {
                REMOVE_INTERMEDIATE_FILES = false;
                continue;
            }
            if (argv[i].equals("-no-duplicates")) {
                EXTRACT_DUPLICATES = false;
                continue;
            }
            if (argv[i].equals("-out-dir")) {
                OUT_DIR = new String(argv[++i]);
                continue;
            }
            if (argv[i].equals("-temp-dir")) {
                temp_dir = new File(argv[++i]);
                continue;
            }
            if (argv[i].equals("-tmpdir")) {
                String dir = System.getenv("TMPDIR");
                if (dir == null) {
                    System.err.println("ERROR: no TMPDIR environment variable; use -temp-dir X to specify manually");
                    System.exit(1);
                    continue;
                }
                temp_dir = new File(dir);
                continue;
            }
            if (argv[i].equals("-span-test")) {
                span_test = true;
                continue;
            }
            System.err.println("ERROR: unknown argument " + argv[i]);
            SAMExtractUnmapped.usage();
        }
        if (bam_file == null) {
            System.err.println("ERROR: specify -bam [file] and -nib [directory]");
            SAMExtractUnmapped.usage();
        } else {
            try {
                File bam = new File(bam_file);
                String basename = bam.getName();
                if (OUT_DIR != null) {
                    File f = new File(new File(OUT_DIR), basename);
                    basename = f.getCanonicalPath();
                }
                SAMExtractUnmapped seu = new SAMExtractUnmapped(bam, basename);
                if (temp_dir != null) {
                    System.err.println("using scratch directory: " + temp_dir);
                    seu.set_temp_dir(temp_dir);
                }
                seu.report();
            }
            catch (Exception e) {
                System.err.println("ERROR: " + e);
                e.printStackTrace();
            }
        }
    }

    private int interesting_check(SAMRecord sr, SAMIndelFilter sif, ArrayList<String> stuff) throws IOException {
        int result_flag = 0;
        boolean binary_mode = stuff == null;
        String rn = sr.getReferenceName();
        if (this.CURRENT_REFERENCE_NAME == null || !this.CURRENT_REFERENCE_NAME.equals(rn)) {
            System.err.println("reference sequence: " + rn);
            this.CURRENT_REFERENCE_NAME = rn;
            Chromosome c = Chromosome.valueOfString(rn);
            if (c == null) {
                this.MMF = null;
                this.USABLE_REFERENCE_SEQUENCE = false;
                System.err.println("ignoring reads mapped to reference " + rn);
            } else {
                NIB nib = new NIB(rn);
                this.MMF = new SAMMismatchFilter(nib.read_all());
                this.USABLE_REFERENCE_SEQUENCE = true;
                this.MMF.get_config().ENABLE_MISMAP_FILTER = false;
            }
        }
        if (this.USABLE_REFERENCE_SEQUENCE) {
            this.MMF.filter(sr);
            int hq = this.MMF.get_hq_mismatches_window(HQ_MISMATCH_WINDOW_SIZE);
            int hq_start_clip = this.MMF.get_start_clipped_hq_mismatches(sr);
            int hq_end_clip = this.MMF.get_end_clipped_hq_mismatches(sr);
            int hq_usable = hq + hq_start_clip + hq_end_clip;
            if (hq_usable >= HQ_MISMATCH_EXTRACT_THRESHOLD) {
                if (binary_mode) {
                    return 1;
                }
                stuff.add("hqmm");
                stuff.add(Integer.toString(hq));
                if (hq > 0) {
                    result_flag |= 1;
                }
                if (hq_start_clip > 0) {
                    stuff.add("hqmm_sc");
                    stuff.add(Integer.toString(hq_start_clip));
                    result_flag |= 2;
                }
                if (hq_end_clip > 0) {
                    stuff.add("hqmm_ec");
                    stuff.add(Integer.toString(hq_end_clip));
                    result_flag |= 4;
                }
            }
            if (VERBOSE) {
                System.err.println("read=" + SAMUtils.get_printable_read_name(sr));
            }
            if (EXTRACT_INDELS && sif.filter(sr)) {
                if (VERBOSE) {
                    System.err.println("  usable indels");
                }
                if (binary_mode) {
                    return 1;
                }
                for (IndelInfo ii : sif.get_indels()) {
                    if (ii.indel_type.equals((Object)CigarOperator.INSERTION)) {
                        stuff.add("insertion");
                        result_flag |= 8;
                        continue;
                    }
                    if (ii.indel_type.equals((Object)CigarOperator.DELETION)) {
                        stuff.add("deletion");
                        result_flag |= 0x10;
                        continue;
                    }
                    System.err.println("ERROR PROCESSING INDEL");
                }
            } else if (VERBOSE) {
                System.err.println("  no usable indels");
            }
        }
        return result_flag;
    }

    private static void usage() {
        System.err.println("  -bam [file]");
        System.err.println("  -nib [file]");
        System.err.println("  [-no-indels]");
        System.err.println("  [-no-duplicates]");
        System.exit(1);
    }

    public static void clean_tempfiles() {
        File dir = new File(".");
        String[] files = dir.list();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].indexOf(UNMAPPED_IDS_TAG) <= -1 && files[i].indexOf(INTERESTING_IDS_TAG) <= -1) continue;
            System.err.println("deleting file " + files[i]);
            File f = new File(files[i]);
            f.delete();
        }
    }
}

