/*
 * Decompiled with CFR 0.152.
 */
package Ace2;

import Ace2.ChromosomeDisambiguator;
import Ace2.FASTADirectory;
import Ace2.FASTAIndexedFAI;
import Ace2.NIB;
import Ace2.SAMCache;
import Ace2.SAMCanonicalReference;
import Ace2.SEUConfig;
import Ace2.SEUInteresting;
import Ace2.SEUMateQuery;
import Ace2.SEUWriter;
import Ace2.SEUWriterBAM;
import Ace2.SEUWriterFASTQ;
import Ace2.TwoBitFile;
import Ace2.WorkingDirectory;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordIterator;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.ValidationStringency;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SAMExtractUnmapped2 {
    SEUConfig config;
    Integer reference_index;
    SEUMateQuery smq;
    SamReader reader_mate;
    SAMCache sam_cache;
    long time_mate_query_same_ref = 0L;
    long time_mate_query_other_ref = 0L;
    SEUWriter seuw = null;
    WorkingDirectory wd = null;
    int cache_hits;
    int cache_misses;
    SAMCanonicalReference scr;
    HashMap<Integer, SEUInteresting> seui_cache;
    HashMap<Integer, SEUMateQuery> seumq_cache;

    public SAMExtractUnmapped2(SEUConfig config) {
        this.config = config;
        this.seui_cache = new HashMap();
        this.seumq_cache = new HashMap();
        this.wd = null;
    }

    public void extract() throws IOException {
        int cache_total;
        this.cache_misses = 0;
        this.cache_hits = 0;
        SamReader reader = SamReaderFactory.makeDefault().validationStringency(ValidationStringency.SILENT).open(this.config.bam_file);
        this.reader_mate = SamReaderFactory.makeDefault().validationStringency(ValidationStringency.SILENT).open(this.config.bam_file);
        if (this.config.report_basename == null) {
            this.config.report_basename = this.config.bam_file.getName();
        }
        ChromosomeDisambiguator cd = new ChromosomeDisambiguator(reader);
        this.scr = new SAMCanonicalReference(reader);
        SAMRecordIterator query = null;
        SEUInteresting interesting = null;
        if (this.config.QUERY_UNMAPPED) {
            query = reader.queryUnmapped();
            this.reference_index = -1;
        } else {
            String ref_name_bam = cd.find(this.config.reference_name);
            if (ref_name_bam == null) {
                throw new IOException("ERROR: can't find reference sequence " + this.config.reference_name + " in " + this.config.bam_file);
            }
            SAMSequenceDictionary dict = reader.getFileHeader().getSequenceDictionary();
            SAMSequenceRecord ssr = dict.getSequence(ref_name_bam);
            this.reference_index = ssr.getSequenceIndex();
            interesting = this.get_interesting(this.reference_index);
            System.err.println("reference: user=" + this.config.reference_name + " BAM=" + ref_name_bam);
            int qstart = this.config.ref_start;
            int qend = this.config.ref_end;
            if (qstart == 0) {
                qstart = 1;
                qend = ssr.getSequenceLength();
            }
            query = reader.queryOverlapping(ref_name_bam, qstart, qend);
            System.err.println("query=" + qstart + "-" + qend);
        }
        System.err.println("chunk size=" + this.config.READ_CHUNK_COUNT);
        long read_count = 0L;
        if (!this.config.ITERATE_REFERENCES || this.seuw == null) {
            String base_fn = null;
            if (this.config.temp_dir != null) {
                File f = new File(this.config.report_basename).getCanonicalFile();
                File parent = f.getParentFile();
                File target_dir = parent == null ? new File(".") : parent;
                this.wd = new WorkingDirectory(this.config.temp_dir, target_dir);
                base_fn = this.wd.get_file(f.getName()).getCanonicalPath();
            } else {
                base_fn = this.config.report_basename;
                if (this.config.output_directory != null) {
                    File f = new File(new File(this.config.output_directory), base_fn);
                    base_fn = f.getCanonicalPath();
                }
            }
            if (this.config.WRITE_BAM) {
                this.seuw = new SEUWriterBAM(this.config, reader, base_fn);
            } else if (this.config.WRITE_FASTQ) {
                this.seuw = new SEUWriterFASTQ(this.config, reader, base_fn);
            } else {
                throw new IOException("ERROR setting up SEUWriter");
            }
        }
        if (this.config.MATE_QUERY_GROUP) {
            this.smq = new SEUMateQuery(this.config, interesting, this.seuw);
        }
        ArrayList<SAMRecord> chunk = new ArrayList<SAMRecord>();
        this.sam_cache = new SAMCache();
        while (query.hasNext()) {
            SAMRecord sr = (SAMRecord)query.next();
            this.sam_cache.add(sr);
            chunk.add(sr);
            if (this.config.ENABLE_READ_LIMIT && read_count > (long)this.config.READ_LIMIT) {
                System.err.println("read limit enabled: stopping at read #" + read_count);
                break;
            }
            if (++read_count % (long)this.config.READ_CHUNK_COUNT != 0L) continue;
            this.process_chunk(chunk, interesting);
            chunk.clear();
            this.sam_cache.clear();
        }
        this.process_chunk(chunk, interesting);
        if (this.config.MATE_QUERY_GROUP) {
            ArrayList<SEUMateQuery> list = new ArrayList<SEUMateQuery>();
            list.add(this.smq);
            list.addAll(this.seumq_cache.values());
            for (SEUMateQuery q : list) {
                System.err.println("flushing queue for " + q.get_reference_name());
                q.flush();
            }
        }
        System.err.println("mate query time: same_ref=" + this.time_mate_query_same_ref + " other_ref=" + this.time_mate_query_other_ref + " total=" + (this.time_mate_query_same_ref + this.time_mate_query_other_ref));
        if (!this.config.ITERATE_REFERENCES) {
            this.close_all();
        }
        if ((cache_total = this.cache_hits + this.cache_misses) > 0) {
            System.err.println("SAM cache hits:" + this.cache_hits + "/" + cache_total + " (" + this.cache_hits * 100 / cache_total + "%)");
        }
    }

    public void close_all() throws IOException {
        this.seuw.close();
        if (this.wd != null) {
            this.wd.finish();
        }
    }

    public static void main(String[] argv) {
        SEUConfig config = new SEUConfig();
        Object temp_dir = null;
        try {
            for (int i = 0; i < argv.length; ++i) {
                if (argv[i].equals("-bam")) {
                    config.bam_file = new File(argv[++i]);
                    continue;
                }
                if (argv[i].equals("-basename")) {
                    config.report_basename = new String(argv[++i]);
                    continue;
                }
                if (argv[i].equals("-nib")) {
                    NIB.DEFAULT_NIB_DIR = new String(argv[++i]);
                    config.reference_sequence = new NIB();
                    continue;
                }
                if (argv[i].equals("-2bit")) {
                    config.reference_sequence = new TwoBitFile(argv[++i]);
                    continue;
                }
                if (argv[i].equals("-fasta")) {
                    String thing;
                    File f;
                    if ((f = new File(thing = argv[++i])).isFile()) {
                        config.reference_sequence = new FASTAIndexedFAI(thing);
                        continue;
                    }
                    if (f.isDirectory()) {
                        config.reference_sequence = new FASTADirectory(thing);
                        continue;
                    }
                    System.err.println("ERROR: not a file/directory: " + thing);
                    continue;
                }
                if (argv[i].equals("-ref")) {
                    config.reference_name = new String(argv[++i]);
                    continue;
                }
                if (argv[i].equals("-start")) {
                    config.ref_start = Integer.parseInt(argv[++i]);
                    continue;
                }
                if (argv[i].equals("-end")) {
                    config.ref_end = Integer.parseInt(argv[++i]);
                    continue;
                }
                if (argv[i].equals("-chunk")) {
                    config.READ_CHUNK_COUNT = Integer.parseInt(argv[++i]);
                    continue;
                }
                if (argv[i].equals("-unmapped")) {
                    config.QUERY_UNMAPPED = true;
                    continue;
                }
                if (argv[i].equals("-unmapped-only")) {
                    config.EXTRACT_UNMAPPED_READS_ONLY = true;
                    continue;
                }
                if (argv[i].equals("-limit")) {
                    config.ENABLE_READ_LIMIT = true;
                    config.READ_LIMIT = Integer.parseInt(argv[++i]);
                    continue;
                }
                if (argv[i].equals("-no-indels")) {
                    config.EXTRACT_INDELS = false;
                    continue;
                }
                if (argv[i].equals("-no-interesting-mates")) {
                    config.EXTRACT_INTERESTING_MATES = false;
                    config.MATE_QUERY_GROUP_QUEUE_LIMIT = 500;
                    config.READ_CHUNK_COUNT = 5000;
                    continue;
                }
                if (argv[i].equals("-no-duplicates")) {
                    config.EXTRACT_DUPLICATES = false;
                    continue;
                }
                if (argv[i].equals("-mate-query-direct")) {
                    config.MATE_QUERY_DIRECT = true;
                    config.MATE_QUERY_GROUP = false;
                    continue;
                }
                if (argv[i].equals("-mate-query-group")) {
                    config.MATE_QUERY_GROUP = true;
                    config.MATE_QUERY_DIRECT = false;
                    continue;
                }
                if (argv[i].equals("-mate-query-group-distance")) {
                    config.MATE_QUERY_GROUP_MAX_ALIGN_DISTANCE = Integer.parseInt(argv[++i]);
                    continue;
                }
                if (argv[i].equals("-mate-query-group-queue")) {
                    config.MATE_QUERY_GROUP_QUEUE_LIMIT = Integer.parseInt(argv[++i]);
                    continue;
                }
                if (argv[i].equals("-verbose-mate-query")) {
                    SEUMateQuery.VERBOSE = true;
                    continue;
                }
                if (argv[i].equals("-require-canonical-mates")) {
                    config.EXTRACT_MATES_ON_STANDARD_REFERENCES_ONLY = true;
                    continue;
                }
                if (argv[i].equals("-no-require-canonical-mates")) {
                    config.EXTRACT_MATES_ON_STANDARD_REFERENCES_ONLY = false;
                    continue;
                }
                if (argv[i].equals("-write-fastq")) {
                    config.WRITE_FASTQ = true;
                    config.WRITE_BAM = false;
                    continue;
                }
                if (argv[i].equals("-temp-dir")) {
                    config.temp_dir = new File(argv[++i]);
                    continue;
                }
                if (argv[i].equals("-tmpdir")) {
                    String dir = System.getenv("TMPDIR");
                    if (dir == null) {
                        System.err.println("ERROR: no TMPDIR environment variable; use -temp-dir X to specify manually");
                        System.exit(1);
                        continue;
                    }
                    config.temp_dir = new File(dir);
                    continue;
                }
                if (argv[i].equals("-all-ref")) {
                    config.ITERATE_REFERENCES = true;
                    continue;
                }
                System.err.println("ERROR: unknown argument " + argv[i]);
                SAMExtractUnmapped2.usage();
                System.exit(1);
            }
        }
        catch (Exception e) {
            System.err.println("ERROR: " + e);
            System.exit(1);
        }
        if (config.bam_file == null || config.reference_sequence == null && !config.EXTRACT_UNMAPPED_READS_ONLY || config.reference_name == null && !config.QUERY_UNMAPPED && !config.ITERATE_REFERENCES) {
            SAMExtractUnmapped2.usage();
        } else {
            try {
                System.err.println("extract mapped mates of interesting mapped reads?: " + config.EXTRACT_INTERESTING_MATES);
                System.err.println("only extract mates mapped to canonical references?: " + config.EXTRACT_MATES_ON_STANDARD_REFERENCES_ONLY);
                System.err.println("extract unmapped reads only?: " + config.EXTRACT_UNMAPPED_READS_ONLY);
                SAMExtractUnmapped2 seu = new SAMExtractUnmapped2(config);
                if (config.ITERATE_REFERENCES) {
                    if (config.reference_sequence == null) {
                        throw new Exception("reference sequence not specified");
                    }
                    SamReader reader = SamReaderFactory.makeDefault().validationStringency(ValidationStringency.SILENT).open(config.bam_file);
                    SAMFileHeader h = reader.getFileHeader();
                    SAMSequenceDictionary dict = h.getSequenceDictionary();
                    config.QUERY_UNMAPPED = false;
                    ArrayList<String> references = new ArrayList<String>();
                    for (SAMSequenceRecord ssr : dict.getSequences()) {
                        String rname = ssr.getSequenceName();
                        int rs_len = config.reference_sequence.get_length(rname);
                        if (rs_len == -1) {
                            System.err.println("skipping ID " + rname + ", not in reference file");
                            continue;
                        }
                        references.add(rname);
                    }
                    Iterator i$ = references.iterator();
                    while (i$.hasNext()) {
                        String rname;
                        config.reference_name = rname = (String)i$.next();
                        System.err.println("extracting reads for " + config.reference_name);
                        seu.extract();
                    }
                    config.QUERY_UNMAPPED = true;
                    config.reference_name = null;
                    System.err.println("extracting unmapped reads");
                    seu.extract();
                    seu.close_all();
                } else {
                    seu.extract();
                }
            }
            catch (Exception e) {
                System.err.println("ERROR: " + e);
                e.printStackTrace();
                System.exit(1);
            }
        }
    }

    private static void usage() {
        System.err.println("-bam [file]");
        System.err.println("-nib [dir]");
        System.err.println("-ref [reference to query]");
    }

    private void mate_check(SAMRecord sr, SEUInteresting interesting) throws IOException {
        if (sr.getReadPairedFlag() && !sr.getMateUnmappedFlag() && !this.config.EXTRACT_UNMAPPED_READS_ONLY) {
            if (sr.getMateReferenceIndex().equals(this.reference_index)) {
                SAMRecord mate = this.sam_cache.find_mate(sr);
                if (mate == null) {
                    ++this.cache_misses;
                    if (this.config.MATE_QUERY_DIRECT) {
                        mate = this.direct_mate_query(sr, true);
                    } else if (this.config.MATE_QUERY_GROUP) {
                        this.smq.add_mate(sr);
                    }
                } else {
                    ++this.cache_hits;
                }
                if (mate != null) {
                    interesting.interesting_check(mate);
                    this.seuw.addAlignment(mate, interesting);
                }
            } else if (!this.config.EXTRACT_MATES_ON_STANDARD_REFERENCES_ONLY || this.scr.is_canonical(sr.getMateReferenceIndex())) {
                if (this.config.MATE_QUERY_DIRECT) {
                    SAMRecord mate = this.direct_mate_query(sr, false);
                    if (mate != null) {
                        System.err.println("FIX ME: mate in different reference: " + sr.getReadName() + " @ " + sr.getMateReferenceName() + "." + sr.getMateAlignmentStart());
                        SEUInteresting si = this.get_interesting(mate.getReferenceIndex());
                        si.interesting_check(mate);
                        this.seuw.addAlignment(mate, si);
                    }
                } else if (this.config.MATE_QUERY_GROUP) {
                    this.get_seumq(sr.getMateReferenceIndex()).add_mate(sr);
                }
            }
        }
    }

    private void process_chunk(ArrayList<SAMRecord> chunk, SEUInteresting interesting) throws IOException {
        int aligned = 0;
        for (SAMRecord sr : chunk) {
            if (sr.getDuplicateReadFlag() && !this.config.EXTRACT_DUPLICATES) continue;
            String name = sr.getReadName();
            if (sr.getReadUnmappedFlag()) {
                this.seuw.addAlignment(sr, null);
                this.mate_check(sr, interesting);
                continue;
            }
            if (this.config.EXTRACT_UNMAPPED_READS_ONLY) continue;
            int seu_flags = interesting.interesting_check(sr);
            aligned = sr.getAlignmentStart();
            if (seu_flags <= 0) continue;
            this.seuw.addAlignment(sr, interesting);
            if (!this.config.EXTRACT_INTERESTING_MATES) continue;
            this.mate_check(sr, interesting);
        }
        this.log_msg("processed chunk of " + chunk.size(), false);
        if (aligned > 0) {
            System.err.print(", last_pos=" + aligned);
        }
        System.err.println("");
        if (this.config.MATE_QUERY_GROUP) {
            System.err.println("mate query cache status:");
            System.err.println("SMQ: " + this.smq.get_reference_name() + ": " + this.smq.get_job_count());
            for (SEUMateQuery q : this.seumq_cache.values()) {
                System.err.println("  " + q.get_reference_name() + ": " + q.get_job_count());
            }
        }
    }

    private SEUMateQuery get_seumq(int ri) {
        SEUMateQuery result = this.seumq_cache.get(ri);
        if (result == null) {
            result = new SEUMateQuery(this.config, this.seuw);
            this.seumq_cache.put(ri, result);
        }
        return result;
    }

    private SEUInteresting get_interesting(int ri) {
        SEUInteresting result = this.seui_cache.get(ri);
        if (result == null) {
            result = new SEUInteresting(this.config, ri);
            this.seui_cache.put(ri, result);
        }
        return result;
    }

    private SAMRecord direct_mate_query(SAMRecord sr, boolean on_same_reference) {
        long start_time = System.currentTimeMillis();
        SAMRecord mate = this.reader_mate.queryMate(sr);
        int elapsed = (int)(System.currentTimeMillis() - start_time);
        if (on_same_reference) {
            this.time_mate_query_same_ref += (long)elapsed;
        } else {
            this.time_mate_query_other_ref += (long)elapsed;
        }
        if (mate == null) {
            System.err.println("ERROR: couldn't fetch mate for " + sr.getReadName());
        }
        if (mate != null) {
            System.err.println("direct mate query: " + sr.getReadName() + " on_same_ref:" + on_same_reference + " main=" + sr.getAlignmentStart() + " mate=" + mate.getAlignmentStart() + " took=" + elapsed + " cache=" + this.sam_cache.get_cache_range());
        }
        return mate;
    }

    private void add_to_mate_queue(SAMRecord sr) {
    }

    private void log_msg(String msg, boolean newline) {
        Calendar now = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("E MMM d HH:mm:ss zzz yyyy");
        System.err.print(sdf.format(now.getTime()) + ": " + msg);
        if (newline) {
            System.err.println("");
        }
    }
}

