/*
 * Decompiled with CFR 0.152.
 */
package Ace2;

import Ace2.MultiplexedWriter;
import Ace2.NIB;
import Ace2.SAMMismatchFilter;
import Ace2.SAMUtils;
import Ace2.UniqueReadName;
import Funk.Str;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.ValidationStringency;
import java.io.File;

public class SAMHQMismatchReport {
    private File sam_file;
    private SamReader reader;
    private boolean write_fastq;
    private static int HQ_MISMATCH_EXTRACT_THRESHOLD = 4;

    public SAMHQMismatchReport(File f) {
        this.sam_file = f;
        this.reader = SamReaderFactory.makeDefault().validationStringency(ValidationStringency.SILENT).open(f);
        this.write_fastq = false;
    }

    public void set_write_fastq(boolean fq) {
        this.write_fastq = fq;
    }

    public void report() {
        SAMMismatchFilter mmf = null;
        String current_reference_name = null;
        byte[] reference_sequence = null;
        int ge_3 = 0;
        int ge_4 = 0;
        int ge_5 = 0;
        int read_count = 0;
        MultiplexedWriter mw_mm = null;
        if (this.write_fastq) {
            mw_mm = new MultiplexedWriter(Str.basename(this.sam_file.getPath()) + ".hqmm.", true);
        }
        UniqueReadName urn = new UniqueReadName();
        urn.set_inthash_mode(true, 19);
        try {
            for (SAMRecord sr : this.reader) {
                if (++read_count % 250000 == 0) {
                    System.err.println(read_count + "...( >=4: " + ge_4 + ")");
                }
                if (sr.getReadUnmappedFlag()) continue;
                String rn = sr.getReferenceName();
                if (current_reference_name == null || !current_reference_name.equals(rn)) {
                    System.err.println("reference sequence: " + rn);
                    if (rn.indexOf("_") != -1) {
                        System.err.println("reached nonstandard ref sequence, stopping");
                        break;
                    }
                    NIB nib = new NIB(rn);
                    reference_sequence = nib.read_all();
                    mmf = new SAMMismatchFilter(reference_sequence);
                    current_reference_name = rn;
                }
                mmf.filter(sr);
                int hq = mmf.get_hq_mismatches();
                if (hq < 3) continue;
                ++ge_3;
                if (hq >= 4) {
                    ++ge_4;
                }
                if (hq >= 5) {
                    ++ge_5;
                }
                if (!this.write_fastq || hq < HQ_MISMATCH_EXTRACT_THRESHOLD) continue;
                String bucket = SAMUtils.bucket_reference_name(rn, true);
                String info = sr.getReadName() + "." + urn.get_suffix(sr) + " mapped," + SAMUtils.bucket_reference_name(sr.getReferenceName(), false) + "," + sr.getAlignmentStart() + "," + (sr.getReadNegativeStrandFlag() ? "-" : "+");
                SAMUtils.write_fastq(mw_mm.getPrintStream(bucket), sr, info);
            }
            mw_mm.finish();
            System.err.println("DONE:");
            System.err.println("reads: " + read_count);
            System.err.println("HQ >= 3: " + ge_3);
            System.err.println("HQ >= 4: " + ge_4);
            System.err.println("HQ >= 5: " + ge_5);
        }
        catch (Exception e) {
            System.err.println("ERROR: " + e);
            e.printStackTrace();
        }
    }

    public static void main(String[] argv) {
        File f = null;
        boolean write_fastq = false;
        for (int i = 0; i < argv.length; ++i) {
            if (argv[i].equals("-bam")) {
                f = new File(argv[++i]);
                continue;
            }
            if (argv[i].equals("-fastq")) {
                write_fastq = true;
                continue;
            }
            System.err.println("error: unknown switch " + argv[i]);
            System.exit(1);
        }
        if (f == null) {
            System.err.println("error: specify -bam [file]");
        } else {
            SAMHQMismatchReport mmr = new SAMHQMismatchReport(f);
            System.err.println("extracting FASTQ?: " + write_fastq);
            mmr.set_write_fastq(write_fastq);
            mmr.report();
        }
    }
}

