/*
 * Decompiled with CFR 0.152.
 */
package Ace2;

import Ace2.Base;
import Ace2.SAMUtils;
import Ace2.SNPConfig;
import htsjdk.samtools.AlignmentBlock;
import htsjdk.samtools.Cigar;
import htsjdk.samtools.CigarElement;
import htsjdk.samtools.CigarOperator;
import htsjdk.samtools.SAMRecord;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SAMMismatchFilter {
    private int mismatches;
    private int hq_mismatches;
    private byte[] reference_sequence;
    private int start_offset;
    public static byte MASK_CHAR = (byte)33;
    private ArrayList<Integer> hq_mismatch_sites;
    private static final boolean VERBOSE = false;
    private HashMap<Integer, EnumMap<Base, Integer>> hq_mismatch_bases;
    private SNPConfig config = null;

    public SAMMismatchFilter() {
        this.setup();
    }

    public SAMMismatchFilter(byte[] reference_sequence) {
        this.reference_sequence = reference_sequence;
        this.start_offset = 0;
        this.setup();
    }

    public SAMMismatchFilter(SNPConfig config, byte[] reference_sequence, int start_offset) {
        this.config = config;
        this.reference_sequence = reference_sequence;
        this.start_offset = start_offset;
        this.setup();
    }

    public SNPConfig get_config() {
        return this.config;
    }

    private void setup() {
        if (this.config == null) {
            this.config = new SNPConfig();
        }
        if (this.config.ENABLE_MISMAP_FILTER) {
            this.hq_mismatch_bases = new HashMap();
        }
    }

    public EnumMap<Base, Integer> get_hq_mismatches(int ref_base_num) {
        return this.hq_mismatch_bases.get(ref_base_num - this.start_offset - 1);
    }

    public void set_reference_sequence(byte[] reference_sequence) {
        this.reference_sequence = reference_sequence;
    }

    public boolean filter(SAMRecord sr) {
        boolean passed;
        byte[] read = sr.getReadBases();
        byte[] read_masked = this.config.ENABLE_POLY_X_RUN_MASK_SNP ? SAMMismatchFilter.generate_masked_sequence(read, this.config) : null;
        byte[] quals = sr.getBaseQualities();
        this.mismatches = 0;
        this.hq_mismatches = 0;
        this.hq_mismatch_sites = new ArrayList();
        HashMap hqmm_temp = null;
        if (this.config.ENABLE_MISMAP_FILTER) {
            hqmm_temp = new HashMap();
        }
        int lq_idx_start = 0;
        int lq_idx_end = 0;
        boolean lq_window_mode = false;
        float lq_window_fraction = this.config.MISMATCH_FILTER_LQ_WINDOW;
        if (lq_window_fraction > 0.0f) {
            int lq_window_len = (int)((float)sr.getReadLength() * lq_window_fraction);
            lq_window_mode = true;
            if (sr.getReadNegativeStrandFlag()) {
                lq_idx_end = read.length - 1;
                lq_idx_start = lq_idx_end - (lq_window_len - 1);
            } else {
                lq_idx_start = 0;
                lq_idx_end = lq_window_len - 1;
            }
        }
        block0: for (AlignmentBlock ab : sr.getAlignmentBlocks()) {
            int len = ab.getLength();
            int read_i = ab.getReadStart() - 1;
            int ref_i = ab.getReferenceStart() - this.start_offset - 1;
            if (read_i < 0) {
                System.err.println("ERROR: can't filter " + sr.getReadName() + ", read_i < 0");
                continue;
            }
            if (ref_i < 0) {
                System.err.println("ERROR: can't filter " + sr.getReadName() + ", ref_i < 0");
                continue;
            }
            int end = read_i + len;
            if (end >= this.reference_sequence.length) {
                System.err.println("trimming end to refseq length");
                end = this.reference_sequence.length;
            }
            if (ref_i >= this.reference_sequence.length) {
                System.err.println("WTF? refseq bounds error for " + sr.getReadName() + " " + ref_i + " " + this.reference_sequence.length);
                continue;
            }
            while (read_i < end) {
                if (read_i >= read.length) {
                    System.err.println("WTF, read index out of bounds");
                    continue block0;
                }
                if (ref_i >= this.reference_sequence.length) {
                    System.err.println("WTF, refseq index out of bounds");
                    continue block0;
                }
                int ref_char = Character.toUpperCase(this.reference_sequence[ref_i]);
                if (!(ref_char == read[read_i] || ref_char == 78 || this.config.MISMATCH_FILTER_FORGIVE_DBSNP_MATCHES && this.config.snp_query != null && this.config.snp_query.snp_matches(ref_i + 1, Base.valueOf((char)read[read_i]), Base.valueOf((char)this.reference_sequence[ref_i])) || read_i >= quals.length)) {
                    if (quals[read_i] >= this.config.MISMATCH_FILTER_MIN_LOW_QUALITY) {
                        if (lq_window_mode) {
                            if (read_i >= lq_idx_start && read_i <= lq_idx_end) {
                                ++this.mismatches;
                            }
                        } else {
                            ++this.mismatches;
                        }
                    }
                    if (quals[read_i] >= this.config.MISMATCH_FILTER_MIN_HIGH_QUALITY) {
                        if (this.config.ENABLE_MISMAP_FILTER) {
                            Base b;
                            Integer count;
                            EnumMap<Base, Integer> bases = (EnumMap<Base, Integer>)hqmm_temp.get(ref_i);
                            if (bases == null) {
                                bases = new EnumMap<Base, Integer>(Base.class);
                                hqmm_temp.put(ref_i, bases);
                            }
                            if ((count = (Integer)bases.get((Object)(b = Base.valueOf((char)read[read_i])))) == null) {
                                count = 0;
                            }
                            bases.put(b, count + 1);
                        }
                        if (!this.config.ENABLE_POLY_X_RUN_MASK_SNP || read_masked[read_i] != MASK_CHAR) {
                            ++this.hq_mismatches;
                            this.hq_mismatch_sites.add(read_i);
                        }
                    }
                }
                ++read_i;
                ++ref_i;
            }
        }
        int hq_max = this.config.get_mismatch_filter_max_hq_mismatch_count(sr);
        int lq_max = this.config.get_mismatch_filter_max_lq_mismatch_count(sr);
        if (!this.config.ENABLE_MISMATCH_FILTER || this.mismatches <= lq_max && this.hq_mismatches <= hq_max) {
            passed = true;
        } else {
            passed = false;
            if (this.config.ENABLE_MISMAP_FILTER) {
                for (Integer position : hqmm_temp.keySet()) {
                    EnumMap bucket = (EnumMap)hqmm_temp.get(position);
                    EnumMap<Base, Integer> tracker_bucket = this.hq_mismatch_bases.get(position);
                    if (tracker_bucket == null) {
                        tracker_bucket = new EnumMap(Base.class);
                        this.hq_mismatch_bases.put(position, tracker_bucket);
                    }
                    for (Base b : bucket.keySet()) {
                        Integer count = (Integer)bucket.get((Object)b);
                        Integer tracker_count = tracker_bucket.get((Object)b);
                        if (tracker_count == null) {
                            tracker_count = 0;
                        }
                        tracker_bucket.put(b, tracker_count + count);
                    }
                }
            }
        }
        return passed;
    }

    public int get_hq_mismatches() {
        return this.hq_mismatches;
    }

    public int get_hq_mismatches_window(int window_size) {
        ArrayList<Integer> window = new ArrayList<Integer>();
        int best_size = 0;
        for (Integer v : this.hq_mismatch_sites) {
            int size;
            int span;
            window.add(v);
            while ((span = (Integer)window.get((size = window.size()) - 1) - (Integer)window.get(0)) > window_size) {
                window.remove(0);
            }
            if (size <= best_size) continue;
            best_size = size;
        }
        return best_size;
    }

    private static void mask_sequence(byte[] array, int start_pos, int len) {
        int end = start_pos + len;
        for (int i = start_pos; i < end; ++i) {
            array[i] = MASK_CHAR;
        }
    }

    public static byte[] generate_masked_sequence(byte[] read, SNPConfig config) {
        int i;
        byte[] read_masked = new byte[read.length];
        System.arraycopy(read, 0, read_masked, 0, read.length);
        int run_length = 1;
        for (i = 1; i < read.length; ++i) {
            if (Character.toLowerCase(read[i]) == Character.toLowerCase(read[i - 1])) {
                ++run_length;
                continue;
            }
            if (run_length >= config.POLY_X_MIN_RUN_LENGTH) {
                SAMMismatchFilter.mask_sequence(read_masked, i - run_length, run_length);
            }
            run_length = 1;
        }
        if (run_length >= config.POLY_X_MIN_RUN_LENGTH) {
            SAMMismatchFilter.mask_sequence(read_masked, i - run_length, run_length);
        }
        return read_masked;
    }

    public static void main(String[] argv) {
        ArrayList<Integer> al_sites = new ArrayList<Integer>();
        al_sites.add(5);
        al_sites.add(11);
        al_sites.add(25);
        al_sites.add(28);
        al_sites.add(29);
        al_sites.add(31);
        int[] sites = new int[al_sites.size()];
        boolean i = false;
        int WINDOW_SIZE = 10;
        ArrayList<Integer> window = new ArrayList<Integer>();
        int best_size = 0;
        for (Integer v : al_sites) {
            int size;
            window.add(v);
            while (true) {
                size = window.size();
                int span = (Integer)window.get(size - 1) - (Integer)window.get(0);
                System.err.println("window = " + window + " size=" + size + " span=" + span);
                if (span <= WINDOW_SIZE) break;
                System.err.println("pop");
                window.remove(0);
            }
            if (size <= best_size) continue;
            best_size = size;
            System.err.println("new best size: " + best_size);
        }
    }

    public void clean_hq_mismatch_tracker_through(int ref_base_num) {
        int max_i = ref_base_num - this.start_offset - 1;
        ArrayList<Integer> flush = new ArrayList<Integer>();
        for (Integer pos : this.hq_mismatch_bases.keySet()) {
            if (pos >= max_i) continue;
            flush.add(pos);
        }
        for (Integer pos : flush) {
            this.hq_mismatch_bases.remove(pos);
        }
    }

    public int get_start_clipped_hq_mismatches(SAMRecord sr) {
        if (sr.getReadNegativeStrandFlag()) {
            return this.get_alignment_end_clipped_hq_mismatches(sr);
        }
        return this.get_alignment_start_clipped_hq_mismatches(sr);
    }

    public int get_end_clipped_hq_mismatches(SAMRecord sr) {
        if (sr.getReadNegativeStrandFlag()) {
            return this.get_alignment_start_clipped_hq_mismatches(sr);
        }
        return this.get_alignment_end_clipped_hq_mismatches(sr);
    }

    private int get_alignment_end_clipped_hq_mismatches(SAMRecord sr) {
        boolean verbose = false;
        if (verbose) {
            System.err.println("get_alignment_end_clipped_hq_mismatches():");
        }
        int ae = sr.getAlignmentEnd();
        int aeu = sr.getUnclippedEnd();
        int results = 0;
        if (ae != aeu) {
            Cigar c = sr.getCigar();
            boolean ok = false;
            int len = -1;
            for (CigarElement ce : c.getCigarElements()) {
                CigarOperator co = ce.getOperator();
                ok = co.equals((Object)CigarOperator.SOFT_CLIP);
                len = ce.getLength();
            }
            if (ok) {
                if (verbose) {
                    System.err.println("trailing soft clipping for " + SAMUtils.get_printable_read_name(sr));
                    System.err.println("len=" + len);
                }
                byte[] read = sr.getReadBases();
                byte[] quals = sr.getBaseQualities();
                int read_i = read.length - len;
                int ref_i = ae - this.start_offset;
                if (verbose) {
                    System.err.println("full read: " + new String(read));
                }
                int i = 0;
                while (i < len) {
                    if (ref_i >= 0) {
                        if (ref_i >= this.reference_sequence.length) break;
                        if (verbose) {
                            System.err.println("ref:" + (ref_i + 1) + "=" + (char)this.reference_sequence[ref_i] + " read:" + (char)read[read_i] + " qual:" + quals[read_i]);
                        }
                        if (Character.toUpperCase((char)this.reference_sequence[ref_i]) != read[read_i] && quals[read_i] >= this.config.MISMATCH_FILTER_MIN_HIGH_QUALITY) {
                            if (verbose) {
                                System.err.println("  HQ mismatch");
                            }
                            ++results;
                        }
                    }
                    ++i;
                    ++read_i;
                    ++ref_i;
                }
            } else {
                System.err.println("ERROR getting clip mismatches for " + SAMUtils.get_printable_read_name(sr));
            }
        }
        if (verbose) {
            System.err.println("total=" + results);
        }
        return results;
    }

    private int get_alignment_start_clipped_hq_mismatches(SAMRecord sr) {
        boolean verbose = false;
        if (verbose) {
            System.err.println("get_alignment_start_clipped_hq_mismatches():");
        }
        int as = sr.getAlignmentStart();
        int asu = sr.getUnclippedStart();
        int results = 0;
        if (as != asu) {
            Cigar c = sr.getCigar();
            boolean ok = false;
            int len = -1;
            Iterator i$ = c.getCigarElements().iterator();
            if (i$.hasNext()) {
                CigarElement ce = (CigarElement)i$.next();
                CigarOperator co = ce.getOperator();
                ok = co.equals((Object)CigarOperator.SOFT_CLIP);
                len = ce.getLength();
            }
            if (ok) {
                if (verbose) {
                    System.err.println("lead soft clipping for " + SAMUtils.get_printable_read_name(sr));
                    System.err.println("len=" + len);
                }
                int read_i = 0;
                int ref_i = asu - this.start_offset - 1;
                byte[] read = sr.getReadBases();
                byte[] quals = sr.getBaseQualities();
                int i = 0;
                while (i < len) {
                    if (ref_i >= 0) {
                        if (ref_i >= this.reference_sequence.length) break;
                        if (verbose) {
                            System.err.println("ref:" + (ref_i + 1) + "=" + (char)this.reference_sequence[ref_i] + " read:" + (char)read[read_i] + " qual:" + quals[read_i]);
                        }
                        if (Character.toUpperCase((char)this.reference_sequence[ref_i]) != read[read_i] && quals[read_i] >= this.config.MISMATCH_FILTER_MIN_HIGH_QUALITY) {
                            if (verbose) {
                                System.err.println("  HQ mismatch");
                            }
                            ++results;
                        }
                    }
                    ++i;
                    ++read_i;
                    ++ref_i;
                }
            } else {
                System.err.println("ERROR getting clip mismatches for " + SAMUtils.get_printable_read_name(sr));
            }
        }
        if (verbose) {
            System.err.println("total=" + results);
        }
        return results;
    }
}

