/*
 * Decompiled with CFR 0.152.
 */
package Ace2;

import Ace2.Chromosome;
import Ace2.Range;
import Ace2.SAMUtils;
import Ace2.SNPConfig;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordIterator;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.util.CloseableIterator;
import htsjdk.samtools.util.PeekIterator;
import java.util.ArrayList;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SAMPooledIterator
implements Iterator,
Iterable<SAMRecord> {
    private ArrayList<SamReader> sfrs_list = new ArrayList();
    private SamReader[] sfrs;
    private SAMRecord[] read_buf;
    private PeekIterator[] iterators;
    private ArrayList<String> dictionary_ids;
    private String current_target_id;
    private boolean check_genome_version = true;
    private ArrayList<Iterable<SAMRecord>> custom_iterables = null;
    private String restrict_reference_name = null;
    private Range restrict_range = null;
    private ArrayList<CloseableIterator> cis = null;
    private boolean STANDARDIZE_REFERENCE_NAMES = true;
    int current_buf_index;
    private static final int UNDEF_INDEX = -1;

    @Override
    public Iterator<SAMRecord> iterator() {
        return this;
    }

    public void set_custom_iterables(ArrayList<Iterable<SAMRecord>> custom_iterables) {
        this.custom_iterables = custom_iterables;
    }

    @Override
    public boolean hasNext() {
        boolean result = false;
        for (int i = 0; i < this.iterators.length; ++i) {
            if (this.iterators[i] == null || !this.iterators[i].hasNext()) continue;
            result = true;
            break;
        }
        return result;
    }

    public SAMRecord next() {
        SAMRecord result = null;
        if (this.current_target_id == null) {
            if (this.dictionary_ids.size() == 0) {
                System.err.println("dictionary EOF");
                return null;
            }
            this.current_target_id = this.dictionary_ids.remove(0);
            System.err.println("cid=" + this.current_target_id);
        }
        this.current_buf_index = -1;
        int want_align_start = -1;
        boolean some_records_left = false;
        for (int i = 0; i < this.iterators.length; ++i) {
            if (this.read_buf[i] == null && this.iterators[i] != null && this.iterators[i].hasNext()) {
                this.read_buf[i] = (SAMRecord)this.iterators[i].peek();
            }
            if (this.read_buf[i] == null) continue;
            some_records_left = true;
            String ref_name = this.read_buf[i].getReferenceName();
            if (this.STANDARDIZE_REFERENCE_NAMES) {
                ref_name = SAMUtils.get_standardized_refname(ref_name);
            }
            if (!ref_name.equals(this.current_target_id)) continue;
            int as = this.read_buf[i].getAlignmentStart();
            if (this.current_buf_index != -1 && as >= want_align_start) continue;
            this.current_buf_index = i;
            want_align_start = as;
        }
        if (this.current_buf_index == -1) {
            if (some_records_left) {
                this.current_target_id = null;
                result = this.next();
            }
        } else {
            result = (SAMRecord)this.iterators[this.current_buf_index].next();
            this.read_buf[this.current_buf_index] = null;
        }
        return result;
    }

    public SamReader getSamReader() {
        return this.current_buf_index == -1 ? null : this.sfrs[this.current_buf_index];
    }

    @Override
    public void remove() {
    }

    public void add(SamReader sfr) {
        this.sfrs_list.add(sfr);
    }

    public void addAll(ArrayList<SamReader> sfrs) {
        for (SamReader sfr : sfrs) {
            this.add(sfr);
        }
    }

    public void set_genome_version_check(boolean v) {
        this.check_genome_version = v;
    }

    public void set_restrict_reference(String ref_name) {
        this.restrict_reference_name = ref_name;
    }

    public void set_restrict_range(Range restrict_range) {
        this.restrict_range = restrict_range;
    }

    public boolean prepare() {
        ArrayList sets = new ArrayList();
        for (SamReader reader : this.sfrs_list) {
            String ref_name;
            SAMFileHeader h = reader.getFileHeader();
            SAMSequenceDictionary dict = h.getSequenceDictionary();
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(h.getSortOrder());
            for (SAMSequenceRecord sr : dict.getSequences()) {
                ref_name = new String(sr.getSequenceName());
                if (this.STANDARDIZE_REFERENCE_NAMES) {
                    ref_name = SAMUtils.get_standardized_refname(ref_name);
                }
                list.add(ref_name);
                if (!this.check_genome_version) continue;
                list.add(sr.getSequenceLength());
            }
            sets.add(list);
            if (this.dictionary_ids != null) continue;
            this.dictionary_ids = new ArrayList();
            for (SAMSequenceRecord sr : dict.getSequences()) {
                ref_name = new String(sr.getSequenceName());
                if (this.STANDARDIZE_REFERENCE_NAMES) {
                    ref_name = SAMUtils.get_standardized_refname(ref_name);
                }
                this.dictionary_ids.add(ref_name);
            }
            this.current_target_id = null;
        }
        boolean ok = true;
        int size = this.sfrs_list.size();
        if (this.restrict_reference_name == null) {
            for (int i = size - 2; i >= 0; --i) {
                ArrayList s2;
                ArrayList s1 = (ArrayList)sets.get(i);
                if (s1.equals(s2 = (ArrayList)sets.get(i + 1))) continue;
                System.err.println("ERROR: can't pool iterators:");
                System.err.println("file1: " + s1);
                System.err.println("file2: " + s2);
                ok = false;
            }
        }
        this.read_buf = new SAMRecord[size];
        this.sfrs = new SamReader[size];
        this.iterators = new PeekIterator[size];
        this.cis = new ArrayList();
        for (int i = 0; i < size; ++i) {
            this.sfrs[i] = this.sfrs_list.get(i);
            if (this.restrict_reference_name != null) {
                SAMFileHeader h = this.sfrs[i].getFileHeader();
                SAMSequenceDictionary dict = h.getSequenceDictionary();
                String query_ref_name = null;
                int len = 0;
                for (SAMSequenceRecord dsr : dict.getSequences()) {
                    String bam_ref_name = new String(dsr.getSequenceName());
                    if (!Chromosome.standardize_name(bam_ref_name).equals(this.restrict_reference_name)) continue;
                    query_ref_name = bam_ref_name;
                    len = dsr.getSequenceLength();
                    break;
                }
                if (query_ref_name == null) {
                    System.err.println("NOTE: can't find bam header entry for " + this.restrict_reference_name);
                    this.iterators[i] = null;
                } else {
                    SAMRecordIterator ci;
                    this.current_target_id = query_ref_name;
                    int qstart = SNPConfig.QUERY_START_BASE;
                    int qend = len;
                    if (this.restrict_range != null) {
                        qstart = this.restrict_range.start;
                        qend = this.restrict_range.end;
                    }
                    try {
                        ci = this.sfrs[i].queryOverlapping(query_ref_name, qstart, qend);
                    }
                    catch (Exception e) {
                        System.err.println("ERROR:");
                        e.printStackTrace();
                        System.exit(1);
                        ci = null;
                    }
                    this.cis.add((CloseableIterator)ci);
                    this.iterators[i] = new PeekIterator((Iterator)ci);
                }
            } else {
                this.iterators[i] = this.custom_iterables != null ? new PeekIterator(this.custom_iterables.get(i).iterator()) : new PeekIterator((Iterator)this.sfrs[i].iterator());
            }
            this.read_buf[i] = null;
        }
        return ok;
    }

    public void close() {
        if (this.cis != null) {
            for (CloseableIterator old : this.cis) {
                old.close();
            }
        }
    }
}

