/*
 * Decompiled with CFR 0.152.
 */
package Ace2;

import Funk.Str;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.ValidationStringency;
import java.io.File;
import java.util.ArrayList;

public class SAMReadCounter {
    public static void main(String[] argv) {
        try {
            boolean tab_mode = false;
            String bam_file = null;
            for (int i = 0; i < argv.length; ++i) {
                if (argv[i].equals("-bam")) {
                    bam_file = new String(argv[++i]);
                    continue;
                }
                if (argv[i].equals("-tab")) {
                    tab_mode = true;
                    continue;
                }
                System.err.println("ERROR: unknown arg " + argv[i]);
                System.exit(1);
            }
            if (bam_file == null) {
                System.err.println("specify -bam [file]");
            } else {
                SamReader reader = SamReaderFactory.makeDefault().validationStringency(ValidationStringency.SILENT).open(new File(bam_file));
                long mapped_reads = 0L;
                long unmapped_reads = 0L;
                long duplicate_reads = 0L;
                long total_reads = 0L;
                int REPORT_INTERVAL = 1000000;
                for (SAMRecord sr : reader) {
                    if (++total_reads % (long)REPORT_INTERVAL == 0L) {
                        System.err.println("total:" + total_reads + " ref=" + sr.getReferenceName());
                    }
                    if (sr.getDuplicateReadFlag()) {
                        ++duplicate_reads;
                    }
                    if (sr.getReadUnmappedFlag()) {
                        ++unmapped_reads;
                        continue;
                    }
                    ++mapped_reads;
                }
                if (tab_mode) {
                    ArrayList<String> list = new ArrayList<String>();
                    list.add(bam_file);
                    list.add(Long.toString(total_reads));
                    list.add(Long.toString(mapped_reads));
                    list.add(Long.toString(duplicate_reads));
                    list.add(Long.toString(unmapped_reads));
                    System.out.println(Str.join("\t", list));
                } else {
                    System.err.println("total reads: " + total_reads);
                    System.err.println("     mapped: " + mapped_reads);
                    System.err.println("  duplicate: " + duplicate_reads);
                    System.err.println("   unmapped: " + unmapped_reads);
                }
            }
        }
        catch (Exception e) {
            System.err.println("ERROR: " + e);
            e.printStackTrace();
        }
    }
}

