/*
 * Decompiled with CFR 0.152.
 */
package Ace2;

import Ace2.SAMResource;
import Ace2.SAMResourceTags;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.util.CloseableIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

public class SAMReadLength {
    public static void main(String[] argv) {
        SAMResource sres = null;
        int max = 0;
        try {
            boolean TRACK_POSITIONS = false;
            int MAX_TRACK_SIZE = 10;
            for (int i = 0; i < argv.length; ++i) {
                if (argv[i].equals("-bam")) {
                    sres = new SAMResource();
                    sres.import_data(SAMResourceTags.SAM_URL, argv[++i]);
                    sres.detect_sample_id();
                    continue;
                }
                if (argv[i].equals("-max")) {
                    max = Integer.parseInt(argv[++i]);
                    continue;
                }
                if (!argv[i].equals("-positions")) continue;
                TRACK_POSITIONS = true;
            }
            if (sres == null) {
                System.err.println("specify -bam [file]");
            } else {
                ArrayList<SAMRecord> sams;
                CloseableIterator<SAMRecord> iterator = sres.get_iterator();
                long read_count = 0L;
                long[] lengths = new long[5000];
                Arrays.fill(lengths, 0L);
                HashMap<Integer, ArrayList<SAMRecord>> length2sam = new HashMap<Integer, ArrayList<SAMRecord>>();
                while (iterator.hasNext()) {
                    SAMRecord sr = (SAMRecord)iterator.next();
                    int len = sr.getReadLength();
                    if (len >= lengths.length) {
                        System.err.println("ERROR: read len too long: " + len);
                        continue;
                    }
                    int n = len;
                    lengths[n] = lengths[n] + 1L;
                    if (TRACK_POSITIONS) {
                        sams = (ArrayList<SAMRecord>)length2sam.get(len);
                        if (sams == null) {
                            sams = new ArrayList<SAMRecord>();
                            length2sam.put(len, sams);
                        }
                        if (sams.size() < MAX_TRACK_SIZE) {
                            sams.add(sr);
                        }
                    }
                    if (++read_count < (long)max || max <= 0) continue;
                    break;
                }
                for (int i = 0; i < lengths.length; ++i) {
                    if (lengths[i] <= 0L) continue;
                    System.out.print(i + "," + lengths[i]);
                    if (TRACK_POSITIONS) {
                        sams = (ArrayList)length2sam.get(i);
                        int size = sams.size();
                        for (int j = 0; j < size; ++j) {
                            SAMRecord sr = (SAMRecord)sams.get(j);
                            System.out.print("," + sr.getReferenceName() + ":" + sr.getAlignmentStart());
                        }
                    }
                    System.out.println();
                }
                System.err.println("read: " + read_count);
            }
        }
        catch (Exception e) {
            System.err.println("ERROR: " + e);
            e.printStackTrace();
        }
    }
}

