/*
 * Decompiled with CFR 0.152.
 */
package Ace2;

import htsjdk.samtools.SAMRecord;

public class SAMReadQuery {
    String readName;
    int alignmentStart;
    boolean negativeStrandFlag;
    SAMRecord hit;

    public SAMReadQuery(String readName, int alignmentStart, boolean negativeStrandFlag) {
        this.readName = readName;
        this.alignmentStart = alignmentStart;
        this.negativeStrandFlag = negativeStrandFlag;
        this.hit = null;
    }

    public SAMReadQuery(SAMRecord sr, boolean use_mate) {
        this.readName = sr.getReadName();
        if (use_mate) {
            this.alignmentStart = sr.getMateAlignmentStart();
            this.negativeStrandFlag = sr.getMateNegativeStrandFlag();
        } else {
            this.alignmentStart = sr.getAlignmentStart();
            this.negativeStrandFlag = sr.getReadNegativeStrandFlag();
        }
    }

    public boolean matches(SAMRecord sr) {
        return this.negativeStrandFlag == sr.getReadNegativeStrandFlag() && this.alignmentStart == sr.getAlignmentStart() && this.readName.equals(sr.getReadName());
    }
}

