/*
 * Decompiled with CFR 0.152.
 */
package Ace2;

import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.ValidationStringency;
import java.io.File;
import java.util.HashSet;

public class SAMReportPositions {
    public void report(SamReader reader, String tname) {
        HashSet<String> skipped = new HashSet<String>();
        for (SAMRecord sr : reader) {
            if (sr.getReadUnmappedFlag()) continue;
            String rn = sr.getReferenceName();
            if (rn.equals(tname)) {
                System.err.println((sr.getReadNegativeStrandFlag() ? "R" : "F") + " " + sr.getReadName() + " " + rn + " " + sr.getAlignmentStart() + " " + sr.getAlignmentEnd() + " " + new String(sr.getReadBases()));
                continue;
            }
            if (skipped.contains(rn)) continue;
            System.err.println("skipping " + rn);
            skipped.add(rn);
        }
    }

    public static void main(String[] argv) {
        try {
            SAMReportPositions rpt = new SAMReportPositions();
            SamReader reader = SamReaderFactory.makeDefault().validationStringency(ValidationStringency.SILENT).open(new File(argv[0]));
            rpt.report(reader, argv[1]);
        }
        catch (Exception e) {
            System.err.println("ERROR: " + e);
        }
    }
}

