/*
 * Decompiled with CFR 0.152.
 */
package Ace2;

import Ace2.SAMConsensusMapping;
import htsjdk.samtools.SAMRecord;

public class SAMTracePeakPositions {
    static final String TAG_TRACE_PEAK_POSITIONS = "YP";
    static final String TAG_TRACE_PEAK_POSITIONS_NORMALIZATION_FACTOR = "YF";
    private int[] peak_positions;

    public SAMTracePeakPositions(SAMRecord sr) {
        this.setup(sr);
    }

    private void setup(SAMRecord sr) {
        Object p;
        int normalization_factor = 0;
        Object nf = sr.getAttribute(TAG_TRACE_PEAK_POSITIONS_NORMALIZATION_FACTOR);
        if (nf != null) {
            System.err.println("HEY NOW: normalization factor found...");
            if (nf instanceof Integer) {
                normalization_factor = (Integer)nf;
                System.err.println("using normalization factor of " + nf);
            } else {
                System.err.println("ERROR parsing normalization factor, obj=" + nf);
            }
        }
        if ((p = sr.getAttribute(TAG_TRACE_PEAK_POSITIONS)) == null) {
            System.err.println("ERROR: no trace peak positions tag YP");
        } else {
            int i;
            byte[] ba = ((String)p).getBytes();
            int len = ba.length;
            this.peak_positions = new int[len];
            int last_value = 0;
            for (i = 0; i < len; ++i) {
                last_value = this.peak_positions[i] = last_value + (ba[i] - 33 - normalization_factor);
            }
            if (sr.getReadNegativeStrandFlag()) {
                int[] rev = new int[len];
                int j = len - 1;
                i = 0;
                while (i < len) {
                    rev[j] = this.peak_positions[i];
                    ++i;
                    --j;
                }
                this.peak_positions = rev;
            }
        }
    }

    public int get_peak_position_for_consensus(SAMConsensusMapping scm, int cpos) {
        boolean result = false;
        int pi = scm.get_padded_index(cpos);
        byte[] padded = scm.get_sequence_buffer();
        int unpadded_i = 0;
        for (int i = 0; i < pi; ++i) {
            if (padded[i] == 42 || padded[i] == 45 || padded[i] == 62 || padded[i] == 60) continue;
            ++unpadded_i;
        }
        return this.peak_positions[unpadded_i];
    }
}

