/*
 * Decompiled with CFR 0.152.
 */
package Ace2;

import Ace2.IndelInfo;
import Ace2.SAMIndelFilter;
import Ace2.SAMMismatchFilter;
import Ace2.SEUConfig;
import htsjdk.samtools.CigarOperator;
import htsjdk.samtools.SAMRecord;
import java.io.IOException;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SEUInteresting {
    SEUConfig config;
    SAMIndelFilter sif;
    SAMMismatchFilter mmf;
    Integer reference_index = null;
    ArrayList<String> stuff = null;

    public SEUInteresting(SEUConfig config, Integer reference_index) {
        this.config = config;
        this.mmf = null;
        this.sif = new SAMIndelFilter();
        this.reference_index = reference_index;
    }

    public int interesting_check(SAMRecord sr) throws IOException {
        int result_flag = 0;
        this.stuff = new ArrayList();
        if (this.mmf == null) {
            this.mmf = new SAMMismatchFilter(this.config.reference_sequence.get_all(sr.getReferenceName()));
            this.mmf.get_config().ENABLE_MISMAP_FILTER = false;
        }
        if (!sr.getReferenceIndex().equals(this.reference_index)) {
            throw new IOException("ERROR: called on a different ref seq mapping");
        }
        this.mmf.filter(sr);
        int hq = this.mmf.get_hq_mismatches_window(this.config.HQ_MISMATCH_WINDOW_SIZE);
        int hq_start_clip = this.mmf.get_start_clipped_hq_mismatches(sr);
        int hq_end_clip = this.mmf.get_end_clipped_hq_mismatches(sr);
        int hq_usable = hq + hq_start_clip + hq_end_clip;
        if (hq_usable >= this.config.HQ_MISMATCH_EXTRACT_THRESHOLD) {
            this.stuff.add("hqmm");
            this.stuff.add(Integer.toString(hq));
            if (hq > 0) {
                result_flag |= 1;
            }
            if (hq_start_clip > 0) {
                result_flag |= 2;
                this.stuff.add("hqmm_sc");
                this.stuff.add(Integer.toString(hq_start_clip));
            }
            if (hq_end_clip > 0) {
                result_flag |= 4;
                this.stuff.add("hqmm_ec");
                this.stuff.add(Integer.toString(hq_end_clip));
            }
        }
        if (this.config.EXTRACT_INDELS && this.sif.filter(sr)) {
            for (IndelInfo ii : this.sif.get_indels()) {
                if (ii.indel_type.equals((Object)CigarOperator.INSERTION)) {
                    result_flag |= 8;
                    this.stuff.add("insertion");
                    continue;
                }
                if (ii.indel_type.equals((Object)CigarOperator.DELETION)) {
                    result_flag |= 0x10;
                    this.stuff.add("deletion");
                    continue;
                }
                System.err.println("ERROR PROCESSING INDEL");
            }
        }
        sr.setAttribute(SEUConfig.SAM_INTERESTING_TAG, (Object)result_flag);
        return result_flag;
    }

    public ArrayList<String> get_fastq_tags() {
        return this.stuff;
    }
}

