/*
 * Decompiled with CFR 0.152.
 */
package Ace2;

import Ace2.MultiplexedWriter;
import Ace2.SAMUtils;
import Ace2.SEUConfig;
import Ace2.SEUInteresting;
import Ace2.SEUWriter;
import Ace2.UniqueReadName;
import Ace2.WorkingFile;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SamReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;

public class SEUWriterFASTQ
extends SEUWriter {
    MultiplexedWriter mw_paired_reads;
    UniqueReadName urn;
    WorkingFile wf_mate_unmapped;
    PrintStream ps_mate_unmapped;

    public SEUWriterFASTQ(SEUConfig config, SamReader reader, String base_fn) throws FileNotFoundException, IOException {
        super(config);
        this.mw_paired_reads = new MultiplexedWriter(base_fn + ".mate_mapped.fastq.", false);
        this.urn = new UniqueReadName();
        this.urn.set_inthash_mode(true, 19);
        this.wf_mate_unmapped = new WorkingFile(base_fn + ".mate_unmapped.fastq");
        this.ps_mate_unmapped = this.wf_mate_unmapped.getPrintStream();
    }

    public void writeAlignment(SAMRecord sr, SEUInteresting interesting) {
        String name = sr.getReadName();
        String id = name + "." + this.urn.get_suffix(name, sr.getReadNegativeStrandFlag());
        ArrayList<String> stuff = new ArrayList<String>();
        if (sr.getReadUnmappedFlag()) {
            stuff.add("unmapped");
        } else {
            stuff.add("mapped");
            stuff.add(SAMUtils.bucket_reference_name(sr.getReferenceName(), false));
            stuff.add(Integer.toString(sr.getAlignmentStart()));
            stuff.add(sr.getReadNegativeStrandFlag() ? "-" : "+");
            if (sr.getReadPairedFlag() && !sr.getMateUnmappedFlag()) {
                stuff.add("mate");
                stuff.add(SAMUtils.bucket_reference_name(sr.getMateReferenceName(), false));
                stuff.add(Integer.toString(sr.getMateAlignmentStart()));
            }
            if (interesting != null) {
                stuff.addAll(interesting.get_fastq_tags());
            }
            stuff.add("alignEnd");
            stuff.add(Integer.toString(sr.getAlignmentEnd()));
        }
        if (!sr.getReadPairedFlag()) {
            stuff.add("unpaired");
        } else if (sr.getMateUnmappedFlag()) {
            stuff.add("mate_unmapped");
            if (!sr.getReadUnmappedFlag()) {
                stuff.add("has_unmapped_mate");
            }
        } else {
            stuff.add("has_mapped_mate");
            stuff.add(SAMUtils.bucket_reference_name(sr.getMateReferenceName(), false));
            stuff.add(Integer.toString(sr.getMateAlignmentStart()));
            stuff.add(sr.getMateNegativeStrandFlag() ? "-" : "+");
        }
        stuff.add("flags");
        stuff.add(Integer.toString(sr.getFlags()));
        if (sr.getDuplicateReadFlag()) {
            stuff.add("duplicate");
        }
        if (sr.getReadUnmappedFlag()) {
            if (!sr.getReadPairedFlag() || sr.getMateUnmappedFlag()) {
                SAMUtils.write_fastq(this.ps_mate_unmapped, sr, id, stuff);
            } else {
                String mate_refname = SAMUtils.bucket_reference_name(sr.getMateReferenceName(), true);
                SAMUtils.write_fastq(this.mw_paired_reads.getPrintStream(mate_refname), sr, id, stuff);
            }
        } else {
            String refname = SAMUtils.bucket_reference_name(sr.getReferenceName(), true);
            SAMUtils.write_fastq(this.mw_paired_reads.getPrintStream(refname), sr, id, stuff);
        }
    }

    public void close() {
        this.mw_paired_reads.finish();
        this.wf_mate_unmapped.finish();
    }
}

