/*
 * Decompiled with CFR 0.152.
 */
package Ace2;

import Ace2.AceViewerConfig;
import Ace2.SNPConfig;
import Ace2.SpinnerNumber;
import Funk.LookAndFeeler;
import TCGA.ControlFrameListener;
import TCGA.URLLauncher;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.SpringLayout;
import layout.SpringUtilities;

public class SNPControl
extends Observable
implements ControlFrameListener {
    private JDialog jf;
    private SNPConfig config;
    private AceViewerConfig avc;
    private JFrame parent_frame = null;
    SpinnerNumber min_quality;
    SpinnerNumber min_minor_allele_frequency;
    SpinnerNumber min_alt_allele_count;
    SpinnerNumber min_coverage;
    SpinnerNumber min_alt_reads_with_flanking_sequence;
    SpinnerNumber min_alt_reads_with_flanking_sequence_window;
    SpinnerNumber min_flanking_quality;
    SpinnerNumber min_flanking_quality_window;
    SpinnerNumber mmf_max_lq_mismatch;
    SpinnerNumber mmf_max_hq_mismatch;
    SpinnerNumber mmf_min_high_quality;
    SpinnerNumber mmf_min_low_quality;
    SpinnerNumber mismap_ratio;
    SpinnerNumber min_alt_allele_count_for_filter_enable;
    SpinnerNumber min_mapq;
    SpinnerNumber min_unique_alt_read_names;
    SpinnerNumber min_unique_alt_read_start_pos;

    public SNPControl() {
        this.config = new SNPConfig();
        this.avc = new AceViewerConfig();
        this.setup();
    }

    public SNPControl(JFrame parent_frame, Observer o, SNPConfig config, AceViewerConfig avc) {
        this.addObserver(o);
        this.parent_frame = parent_frame;
        this.config = config;
        this.avc = avc;
        this.setup();
    }

    public SNPControl(SNPConfig config, AceViewerConfig avc) {
        this.config = config;
        this.avc = avc;
        this.setup();
    }

    private void setup() {
        this.jf = this.parent_frame == null ? new JDialog() : new JDialog((Frame)this.parent_frame, true);
        JPanel jp_main = new JPanel();
        jp_main.setLayout(new BoxLayout(jp_main, 3));
        JPanel jp_controls = this.get_buffer_titled_panel(jp_main, "SNP/indel detection options");
        jp_controls.setLayout(new SpringLayout());
        this.min_quality = new SpinnerNumber(this.config.MIN_QUALITY);
        this.min_mapq = new SpinnerNumber(this.config.MIN_MAPPING_QUALITY);
        this.min_minor_allele_frequency = new SpinnerNumber(this.config.MIN_MINOR_ALLELE_FREQUENCY);
        this.min_alt_allele_count = new SpinnerNumber(this.config.MIN_ALT_ALLELE_COUNT);
        this.min_unique_alt_read_names = new SpinnerNumber(this.config.MIN_UNIQUE_READ_NAMES_FOR_ALT_ALLELE);
        this.min_unique_alt_read_start_pos = new SpinnerNumber(this.config.MIN_UNIQUE_START_POSITIONS_FOR_ALT_ALLELE);
        this.min_alt_allele_count_for_filter_enable = new SpinnerNumber(this.config.MIN_ALT_ALLELE_COUNT_FOR_FILTER_ENABLE);
        this.min_coverage = new SpinnerNumber(this.config.MIN_COVERAGE);
        this.min_alt_reads_with_flanking_sequence = new SpinnerNumber(this.config.MIN_ALT_READS_WITH_FLANKING_SEQUENCE);
        this.min_alt_reads_with_flanking_sequence_window = new SpinnerNumber(this.config.MIN_ALT_READS_WITH_FLANKING_SEQUENCE_WINDOW);
        this.min_flanking_quality = new SpinnerNumber(this.config.MIN_FLANKING_QUALITY);
        this.min_flanking_quality_window = new SpinnerNumber(this.config.MIN_FLANKING_QUALITY_WINDOW);
        this.mmf_max_lq_mismatch = new SpinnerNumber(this.config.MISMATCH_FILTER_MAX_LQ_MISMATCH_COUNT);
        this.mmf_max_hq_mismatch = new SpinnerNumber(this.config.MISMATCH_FILTER_MAX_HQ_MISMATCH_COUNT);
        this.mmf_min_high_quality = new SpinnerNumber(this.config.MISMATCH_FILTER_MIN_HIGH_QUALITY);
        this.mmf_min_low_quality = new SpinnerNumber(this.config.MISMATCH_FILTER_MIN_LOW_QUALITY);
        this.mismap_ratio = new SpinnerNumber(Float.valueOf(this.config.MISMAP_BASE_FREQUENCY_THRESHOLD));
        int rows = 0;
        int columns = 4;
        this.generate_spinner(jp_controls, this.min_quality, 0.0, 60.0, 1.0, "Minimum nucleotide quality", true);
        ++rows;
        this.generate_spinner(jp_controls, this.min_mapq, 0.0, 255.0, 1.0, "Minimum mapping quality", true);
        ++rows;
        this.generate_spinner(jp_controls, this.min_coverage, 1.0, 50.0, 1.0, "Minimum coverage", true);
        ++rows;
        this.generate_spinner(jp_controls, this.min_minor_allele_frequency, 0.0, 1.0, 0.01f, "Minimum frequency of alternative allele", true);
        ++rows;
        this.generate_spinner(jp_controls, this.min_alt_allele_count, 1.0, 50.0, 1.0, "Minimum observations of alternative allele", true);
        ++rows;
        this.generate_spinner(jp_controls, this.min_unique_alt_read_names, 1.0, 50.0, 1.0, "Minimum unique read names supporting alternative allele", true);
        ++rows;
        this.generate_spinner(jp_controls, this.min_unique_alt_read_start_pos, 1.0, 50.0, 1.0, "Minimum unique read mapping start positions supporting alternative allele", true);
        ++rows;
        this.generate_spinner(jp_controls, this.min_alt_allele_count_for_filter_enable, 1.0, 50.0, 1.0, "Minimum observations of alternative allele to enable uniqueness filters", true);
        ++rows;
        this.generate_spinner(jp_controls, this.min_alt_reads_with_flanking_sequence, 0.0, 50.0, 1.0, "Minimum alternative allele reads with flanking sequence", false);
        this.generate_spinner(jp_controls, this.min_alt_reads_with_flanking_sequence_window, 1.0, 25.0, 1.0, "   window size", false);
        ++rows;
        this.generate_spinner(jp_controls, this.min_flanking_quality, 0.0, 50.0, 1.0, "Minimum quality of flanking sequence", false);
        this.generate_spinner(jp_controls, this.min_flanking_quality_window, 1.0, 20.0, 1.0, "   window size", false);
        ++rows;
        jp_controls.add(new JLabel("Reference mismatch filter: ", 4));
        JCheckBox jcb = new JCheckBox("enable", this.config.ENABLE_MISMATCH_FILTER);
        jp_controls.add(jcb);
        jp_controls.add(new JLabel(""));
        jp_controls.add(new JLabel(""));
        ++rows;
        jcb.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ((SNPControl)SNPControl.this).config.ENABLE_MISMATCH_FILTER = ((JCheckBox)e.getSource()).isSelected();
            }
        });
        this.generate_spinner(jp_controls, this.mmf_max_hq_mismatch, 0.0, 50.0, 1.0, "Maximum allowable mismatches to reference sequence", false);
        this.generate_spinner(jp_controls, this.mmf_min_high_quality, 0.0, 50.0, 1.0, "  min. quality", false);
        ++rows;
        this.generate_spinner(jp_controls, this.mmf_max_lq_mismatch, 0.0, 50.0, 1.0, "", false);
        this.generate_spinner(jp_controls, this.mmf_min_low_quality, 0.0, 50.0, 1.0, "  min. quality", false);
        ++rows;
        this.generate_spinner(jp_controls, this.mismap_ratio, 0.0, 10.0, 0.01f, "Mismap filter: max ratio of suspicious mismatches to usable ones", false);
        jcb = new JCheckBox("enable", this.config.ENABLE_MISMAP_FILTER);
        jp_controls.add(jcb);
        jcb.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ((SNPControl)SNPControl.this).config.ENABLE_MISMAP_FILTER = ((JCheckBox)e.getSource()).isSelected();
            }
        });
        jp_controls.add(new JLabel(""));
        ++rows;
        jp_controls.add(new JLabel("Ignore reads with non-primary alignments: ", 4));
        jcb = new JCheckBox("", this.config.SKIP_NONPRIMARY_ALIGNMENTS);
        jp_controls.add(jcb);
        jp_controls.add(new JLabel(""));
        jp_controls.add(new JLabel(""));
        ++rows;
        jcb.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ((SNPControl)SNPControl.this).config.SKIP_NONPRIMARY_ALIGNMENTS = ((JCheckBox)e.getSource()).isSelected();
            }
        });
        jp_controls.add(new JLabel("Read end mismatch filter: ", 4));
        jcb = new JCheckBox("", this.config.ENABLE_END_MISMATCH_FILTER);
        jp_controls.add(jcb);
        jp_controls.add(new JLabel(""));
        jp_controls.add(new JLabel(""));
        ++rows;
        jcb.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ((SNPControl)SNPControl.this).config.ENABLE_END_MISMATCH_FILTER = ((JCheckBox)e.getSource()).isSelected();
            }
        });
        jp_controls.add(new JLabel("Mismapped deletion filter: ", 4));
        jcb = new JCheckBox("", this.config.ENABLE_MISMAPPED_DELETION_FILTER);
        jp_controls.add(jcb);
        jp_controls.add(new JLabel(""));
        jp_controls.add(new JLabel(""));
        ++rows;
        jcb.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ((SNPControl)SNPControl.this).config.ENABLE_MISMAPPED_DELETION_FILTER = ((JCheckBox)e.getSource()).isSelected();
            }
        });
        jp_controls.add(new JLabel("Mate pair disagreement filter: ", 4));
        jcb = new JCheckBox("", this.config.ENABLE_MATE_PAIR_DISAGREEMENT_FILTER);
        jp_controls.add(jcb);
        jp_controls.add(new JLabel(""));
        jp_controls.add(new JLabel(""));
        ++rows;
        jcb.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ((SNPControl)SNPControl.this).config.ENABLE_MATE_PAIR_DISAGREEMENT_FILTER = ((JCheckBox)e.getSource()).isSelected();
            }
        });
        jp_controls.add(new JLabel("When browsing results using SNP/indel list, only display reads: ", 4));
        jcb = new JCheckBox("at site", this.avc.CLAMP_SNP_VIEW);
        jcb.setToolTipText("restrict display to only show reads which overlap the site.");
        jp_controls.add(jcb);
        jcb.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ((SNPControl)SNPControl.this).avc.CLAMP_SNP_VIEW = ((JCheckBox)e.getSource()).isSelected();
            }
        });
        jcb = new JCheckBox("alternative", this.avc.CLAMP_SNP_VIEW_NONREFERENCE);
        jcb.setToolTipText("restrict display to only show reads which overlap the site and contain the non-reference allele.");
        jp_controls.add(jcb);
        jcb.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ((SNPControl)SNPControl.this).avc.CLAMP_SNP_VIEW_NONREFERENCE = ((JCheckBox)e.getSource()).isSelected();
            }
        });
        jp_controls.add(new JLabel(""));
        int border_pad = 2;
        SpringUtilities.makeCompactGrid((Container)jp_controls, (int)(++rows), (int)columns, (int)border_pad, (int)border_pad, (int)border_pad, (int)border_pad);
        JPanel jp_buttons = new JPanel();
        JButton jb = new JButton();
        jb.setText("Find SNPs / indels");
        jb.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SNPControl.this.apply_changes();
                SNPControl.this.jf.setVisible(false);
            }
        });
        jp_buttons.add(jb);
        jp_buttons.add(new JLabel("  "));
        jb = new JButton("Help");
        jp_buttons.add(jb);
        jb.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                URLLauncher.launch_modified_url("/goldenPath/bamview/documentation/index.html#snps", "bamview_docs");
            }
        });
        jp_buttons.add(new JLabel("  "));
        jb = new JButton("Cancel");
        jb.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SNPControl.this.jf.setVisible(false);
            }
        });
        jp_buttons.add(jb);
        jp_main.add(jp_controls);
        jp_main.add(jp_buttons);
        this.jf.getContentPane().add(new JScrollPane(jp_main));
        this.jf.pack();
        this.jf.setTitle("SNP/indel detector");
        this.jf.setVisible(true);
    }

    public void apply_changes() {
        this.config.MIN_QUALITY = this.min_quality.intValue();
        this.config.MIN_MAPPING_QUALITY = this.min_mapq.intValue();
        this.config.MIN_MINOR_ALLELE_FREQUENCY = this.min_minor_allele_frequency.floatValue();
        this.config.MIN_ALT_ALLELE_COUNT = this.min_alt_allele_count.intValue();
        this.config.MIN_UNIQUE_READ_NAMES_FOR_ALT_ALLELE = this.min_unique_alt_read_names.intValue();
        this.config.MIN_UNIQUE_START_POSITIONS_FOR_ALT_ALLELE = this.min_unique_alt_read_start_pos.intValue();
        System.err.println("value=" + this.config.MIN_UNIQUE_START_POSITIONS_FOR_ALT_ALLELE);
        this.config.MIN_ALT_ALLELE_COUNT_FOR_FILTER_ENABLE = this.min_alt_allele_count_for_filter_enable.intValue();
        this.config.MIN_COVERAGE = this.min_coverage.intValue();
        this.config.MIN_ALT_READS_WITH_FLANKING_SEQUENCE = this.min_alt_reads_with_flanking_sequence.intValue();
        System.err.println("min alt reads w/flank " + this.config.MIN_ALT_READS_WITH_FLANKING_SEQUENCE);
        this.config.MIN_ALT_READS_WITH_FLANKING_SEQUENCE_WINDOW = this.min_alt_reads_with_flanking_sequence_window.intValue();
        this.config.MIN_FLANKING_QUALITY = this.min_flanking_quality.intValue();
        this.config.MIN_FLANKING_QUALITY_WINDOW = this.min_flanking_quality_window.intValue();
        this.config.MISMATCH_FILTER_MAX_HQ_MISMATCH_COUNT = this.mmf_max_hq_mismatch.intValue();
        this.config.MISMATCH_FILTER_MIN_HIGH_QUALITY = this.mmf_min_high_quality.intValue();
        this.config.MISMATCH_FILTER_MAX_LQ_MISMATCH_COUNT = this.mmf_max_lq_mismatch.intValue();
        this.config.MISMATCH_FILTER_MIN_LOW_QUALITY = this.mmf_min_low_quality.intValue();
        System.err.println("setting changed, obs count=" + this.countObservers());
        this.setChanged();
        this.notifyObservers();
    }

    public static void main(String[] argv) {
        LookAndFeeler.set_native_lookandfeel();
        SNPControl sc = new SNPControl();
    }

    private JPanel get_buffer_titled_panel(JPanel panel, String title) {
        JPanel jp_buffer = new JPanel();
        jp_buffer.setLayout(new BorderLayout());
        JPanel jp_titled = new JPanel();
        jp_titled.setLayout(new BoxLayout(jp_titled, 3));
        jp_titled.setBorder(BorderFactory.createTitledBorder(title));
        jp_buffer.add("Center", jp_titled);
        panel.add(jp_buffer);
        return jp_titled;
    }

    private void generate_spinner(JPanel jp, SpinnerNumber sn, double min, double max, double step, String label, boolean pad) {
        Number num = sn.get_number();
        SpinnerNumberModel snm = null;
        if (num instanceof Integer) {
            snm = new SpinnerNumberModel(sn.intValue(), (int)min, (int)max, (int)step);
        } else if (num instanceof Float) {
            snm = new SpinnerNumberModel(sn.floatValue(), min, max, step);
        } else if (num instanceof Double) {
            snm = new SpinnerNumberModel(sn.doubleValue(), min, max, step);
        }
        JSpinner js = new JSpinner(snm);
        jp.add(new JLabel(label + (label.length() > 0 ? ": " : ""), 4));
        jp.add(js);
        js.addChangeListener(sn);
        Dimension pref = js.getPreferredSize();
        pref.width = (int)((double)pref.width * 1.25);
        js.setPreferredSize(pref);
        if (pad) {
            jp.add(new JLabel(""));
            jp.add(new JLabel(""));
        }
    }
}

