/*
 * Decompiled with CFR 0.152.
 */
package Ace2;

import Funk.LookAndFeeler;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import layout.SpringUtilities;

public class SearchWidget2 {
    private JDialog jd;
    private JFrame parent_frame;
    private JComboBox jcb_searchtype;
    private JTextField jtf_search;
    private static final String AUTO = "Automatic";
    private static final String ID = "Sequence ID";
    private static final String NUKE = "Nucleotide";
    private boolean wants_find = false;

    public SearchWidget2() {
        this.parent_frame = null;
        this.setup();
    }

    public SearchWidget2(JFrame parent_frame) {
        this.parent_frame = parent_frame;
        this.setup();
    }

    private void setup() {
        this.jd = this.parent_frame == null ? new JDialog() : new JDialog((Frame)this.parent_frame, true);
        JPanel jp_main = new JPanel();
        jp_main.setLayout(new BoxLayout(jp_main, 3));
        JPanel jp_controls = new JPanel();
        jp_controls.setLayout(new SpringLayout());
        jp_main.add(jp_controls);
        int rows = 0;
        int columns = 2;
        jp_controls.add(new JLabel("Search for: ", 4));
        this.jtf_search = new JTextField(20);
        jp_controls.add(this.jtf_search);
        this.jtf_search.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent ke) {
                int code = ke.getKeyCode();
                if (code == 27) {
                    SearchWidget2.this.decide(false);
                } else if (ke.getKeyCode() == 10) {
                    SearchWidget2.this.decide(true);
                }
            }

            public void keyReleased(KeyEvent ke) {
            }

            public void keyTyped(KeyEvent ke) {
            }
        });
        ++rows;
        Vector<String> items = new Vector<String>();
        items.add(AUTO);
        items.add(ID);
        items.add(NUKE);
        jp_controls.add(new JLabel("Search type: ", 4));
        this.jcb_searchtype = new JComboBox(items);
        jp_controls.add(this.jcb_searchtype);
        int border_pad = 2;
        SpringUtilities.makeCompactGrid((Container)jp_controls, (int)(++rows), (int)columns, (int)border_pad, (int)border_pad, (int)border_pad, (int)border_pad);
        JButton jb_find = new JButton("Find");
        jb_find.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SearchWidget2.this.decide(true);
            }
        });
        JButton jb_close = new JButton("Cancel");
        jb_close.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SearchWidget2.this.decide(false);
            }
        });
        JPanel jp_buttons = new JPanel();
        jp_buttons.add(jb_find);
        jp_buttons.add(jb_close);
        jp_main.add(jp_buttons);
        this.jd.getContentPane().add(new JScrollPane(jp_main));
        this.jd.pack();
        this.jd.setTitle("Find");
        this.jd.setVisible(true);
    }

    private void decide(boolean wants_find) {
        this.wants_find = wants_find;
        this.jd.setVisible(false);
        this.jd.dispose();
    }

    public static void main(String[] argv) {
        LookAndFeeler.set_native_lookandfeel();
        new SearchWidget2();
    }

    public boolean is_id_search() {
        String thing = (String)this.jcb_searchtype.getSelectedItem();
        boolean result = true;
        if (thing.equals(ID)) {
            result = true;
        } else if (thing.equals(NUKE)) {
            result = false;
        } else {
            String value = this.get_value();
            boolean all_acgt = true;
            for (int i = 0; i < value.length(); ++i) {
                char c = value.charAt(i);
                if (c == 'a' || c == 'A' || c == 'c' || c == 'C' || c == 'g' || c == 'G' || c == 't' || c == 'T') continue;
                all_acgt = false;
                break;
            }
            result = !all_acgt;
        }
        return result;
    }

    public boolean wants_find() {
        String text = this.get_value();
        return this.wants_find && text.length() > 0;
    }

    public String get_value() {
        return this.jtf_search.getText();
    }
}

