/*
 * Decompiled with CFR 0.152.
 */
package Ace2;

import Ace2.AssemblySequence;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.util.ArrayList;
import java.util.HashSet;
import javax.swing.JScrollBar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SequenceViewLock {
    private JScrollBar jsb_v;
    private HashSet<String> ids;
    private boolean adj_needed = false;

    public SequenceViewLock(JScrollBar jsb_h, JScrollBar jsb_v) {
        this.jsb_v = jsb_v;
        this.ids = new HashSet();
        jsb_h.addAdjustmentListener(new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent e) {
                SequenceViewLock.this.adj_needed = true;
            }
        });
    }

    public void toggle_id(String id) {
        if (this.ids.contains(id)) {
            this.ids.remove(id);
        } else {
            this.ids.clear();
            this.ids.add(id);
        }
    }

    public boolean contains(String id) {
        return this.ids.contains(id);
    }

    public boolean auto_lock(ArrayList<AssemblySequence> aligned_seqs) {
        boolean adjusted = false;
        if (this.adj_needed) {
            int i_position = 0;
            for (AssemblySequence as : aligned_seqs) {
                if (this.ids.contains(as.get_name())) {
                    int extent = this.jsb_v.getVisibleAmount();
                    int pos = i_position - extent / 2 + 1;
                    if (pos < 0) {
                        pos = 0;
                    }
                    this.adj_needed = false;
                    this.jsb_v.setValue(pos);
                    adjusted = true;
                    break;
                }
                ++i_position;
            }
        }
        return adjusted;
    }
}

