/*
 * Decompiled with CFR 0.152.
 */
package Ace2;

import Ace2.BAMReferenceCompatibility;
import Ace2.Chromosome;
import Ace2.HashCounter;
import Ace2.IntronCache;
import Ace2.ReferenceSequence;
import Ace2.Reporter;
import Ace2.SAMQuery;
import Ace2.SAMRegion;
import Ace2.SplicedReadFlankingInfo;
import Ace2.SplicedReadInfo;
import Ace2.TwoBitFile;
import Ace2.WorkingFile;
import Funk.Str;
import IsoView.UCSCRefGene;
import IsoView.UCSCRefGeneReader;
import htsjdk.samtools.Cigar;
import htsjdk.samtools.CigarElement;
import htsjdk.samtools.CigarOperator;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordIterator;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.ValidationStringency;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SplicedReadReporter {
    File bam;
    HashMap<String, SplicedReadInfo> events_by_name;
    IntronCache ic = null;
    int minimum_observations_to_report = 1;
    int flush_check_interval = 100000;
    boolean wrote_header;
    HashCounter junction_counter;
    boolean READ_NAME_RESTRICT_MODE = false;
    boolean PRIMARY_READ_MODE = false;
    String READ_NAME_RESTRICT_STRING = null;
    int RESTRICT_JUNCTION_START = 0;
    int RESTRICT_JUNCTION_END = 0;
    boolean novel_only = true;
    boolean write_header = true;
    WorkingFile wf = null;
    PrintStream ps = null;
    Reporter rpt_reads = null;
    boolean VERBOSE = false;
    boolean SORT = false;
    boolean WRITE_BED = false;
    boolean WRITE_DELIMITED = false;
    boolean ANNOTATE_MODE = false;
    String RGB_NOVEL = "192,0,0";
    String RGB_KNOWN = "0,128,0";
    int QC_MIN_FLANKING_NT_READ_EDGE = 18;
    int QC_MIN_FLANKING_NT_INTERNAL = 10;
    int MIN_QUALITY_FOR_MISMATCH_CHECK = 15;
    double MAX_JUNK_RATIO_FOR_CLEAN_CALL = 0.05;
    ReferenceSequence reference_sequence = null;
    boolean JUNK_REPORT = true;
    double JUNK_REPORT_MIN_RATIO_TO_COMPLAIN = 0.1;
    double JUNK_REPORT_MIN_LENGTH_TO_COMPLAIN = 15.0;
    SAMRegion query_region = new SAMRegion();

    public SAMRegion get_query_region() {
        return this.query_region;
    }

    public void set_known_rgb(String rgb) {
        this.RGB_KNOWN = rgb;
    }

    public void set_novel_rgb(String rgb) {
        this.RGB_NOVEL = rgb;
    }

    public void set_reference_sequence(ReferenceSequence rs) {
        this.reference_sequence = rs;
    }

    public void set_primary_read_mode(boolean v) {
        this.PRIMARY_READ_MODE = v;
    }

    public void set_restrict_read_name(String name) {
        this.READ_NAME_RESTRICT_MODE = true;
        this.READ_NAME_RESTRICT_STRING = name;
    }

    public void set_restrict_junction_start(int start) {
        this.RESTRICT_JUNCTION_START = start;
    }

    public void set_restrict_junction_end(int end) {
        this.RESTRICT_JUNCTION_END = end;
    }

    public void set_bam(File bam) {
        this.bam = bam;
    }

    public void set_intron_cache(IntronCache ic) {
        this.ic = ic;
    }

    public void set_write_header(boolean v) {
        this.write_header = v;
    }

    public void set_novel_only(boolean v) {
        this.novel_only = v;
    }

    public void set_annotate_mode(boolean v) {
        this.novel_only = false;
        this.ANNOTATE_MODE = true;
        this.WRITE_DELIMITED = true;
    }

    public void set_outfile(String outfile) throws FileNotFoundException, IOException {
        this.wf = new WorkingFile(outfile);
        this.ps = this.wf.getPrintStream();
    }

    public void set_read_report(String rr_fn) throws FileNotFoundException, IOException {
        this.rpt_reads = new Reporter();
        this.rpt_reads.set_output_filename(rr_fn);
        this.rpt_reads.add_header("read_name");
        this.rpt_reads.add_header("strand");
        this.rpt_reads.add_header("reference");
        this.rpt_reads.add_header("junction_start");
        this.rpt_reads.add_header("junction_end");
        this.rpt_reads.add_header("flanking_nt_left");
        this.rpt_reads.add_header("flanking_nt_right");
        this.rpt_reads.add_header("mapping_perfect");
        this.rpt_reads.add_header("mapping_clean");
    }

    public void set_minimum_observations_to_report(int count) {
        this.minimum_observations_to_report = count;
    }

    public void report() throws IOException {
        if (this.bam == null) {
            throw new IOException("no bam specified (-bam)");
        }
        if (this.wf == null) {
            throw new IOException("no outfile specified (-of)");
        }
        if (this.reference_sequence == null) {
            throw new IOException("no reference sequence specified (-2bit)");
        }
        this.wrote_header = !this.write_header;
        this.junction_counter = new HashCounter();
        this.events_by_name = new HashMap();
        SamReader reader = SamReaderFactory.makeDefault().validationStringency(ValidationStringency.SILENT).open(this.bam);
        System.err.print("checking BAM/reference compatibility...");
        BAMReferenceCompatibility brc = new BAMReferenceCompatibility(reader.getFileHeader(), this.reference_sequence);
        System.err.println("done");
        if (brc.has_any_incompatibility()) {
            brc.report_errors();
            throw new IOException("BAM header not fully compatible with specified reference sequence");
        }
        int current_reference_i = -1;
        String current_reference_name = null;
        int checkpoint = 0;
        byte[] refseq = null;
        if (this.READ_NAME_RESTRICT_MODE) {
            System.err.println("DEBUG: restricting to read " + this.READ_NAME_RESTRICT_STRING);
        }
        SAMQuery sq = new SAMQuery(reader);
        SAMRecordIterator query = sq.query(this.query_region);
        int broken_edge_reads = 0;
        while (query.hasNext()) {
            SAMRecord sr = (SAMRecord)query.next();
            if (sr.getReadUnmappedFlag() || this.PRIMARY_READ_MODE && sr.getNotPrimaryAlignmentFlag() || this.READ_NAME_RESTRICT_MODE && !sr.getReadName().equals(this.READ_NAME_RESTRICT_STRING)) continue;
            if (sr.getReferenceIndex() != current_reference_i) {
                this.flush_check(true, null);
                current_reference_i = sr.getReferenceIndex();
                current_reference_name = Chromosome.standardize_name(sr.getReferenceName());
                System.err.println("processing reference: " + current_reference_name);
                if (this.reference_sequence != null) {
                    System.err.print("load reference for " + current_reference_name + "...");
                    refseq = this.reference_sequence.get_all(current_reference_name);
                    for (int i = 0; i < refseq.length; ++i) {
                        refseq[i] = (byte)Character.toUpperCase(refseq[i]);
                    }
                    System.err.println("done");
                }
            } else if (++checkpoint % this.flush_check_interval == 0) {
                this.flush_check(false, sr);
            }
            int ref_base = sr.getUnclippedStart();
            Cigar c = sr.getCigar();
            HashMap<SplicedReadInfo, SplicedReadFlankingInfo> sri2left = new HashMap<SplicedReadInfo, SplicedReadFlankingInfo>();
            HashMap<SplicedReadInfo, SplicedReadFlankingInfo> sri2right = new HashMap<SplicedReadInfo, SplicedReadFlankingInfo>();
            SplicedReadFlankingInfo fi = new SplicedReadFlankingInfo();
            byte[] read_bases = sr.getReadBases();
            byte[] read_qualities = sr.getBaseQualities();
            int read_i = 0;
            ArrayList<SplicedReadInfo> sri_ordered = new ArrayList<SplicedReadInfo>();
            for (CigarElement ce : c.getCigarElements()) {
                CigarOperator co = ce.getOperator();
                int len = ce.getLength();
                if (co.equals((Object)CigarOperator.MATCH_OR_MISMATCH)) {
                    int i = 0;
                    while (i < len) {
                        fi.last_read_i = read_i;
                        if (ref_base > refseq.length) {
                            System.err.println("WARNING: read mapped beyond end of reference: " + sr.getReadName() + " at " + sr.getReferenceName() + "." + sr.getAlignmentStart());
                            ++broken_edge_reads;
                            break;
                        }
                        byte base_ref = refseq[ref_base - 1];
                        if (!(base_ref == read_bases[read_i] || read_qualities[read_i] < this.MIN_QUALITY_FOR_MISMATCH_CHECK || read_bases[read_i] != 65 && read_bases[read_i] != 67 && read_bases[read_i] != 71 && read_bases[read_i] != 84 || base_ref != 65 && base_ref != 67 && base_ref != 71 && base_ref != 84)) {
                            ++fi.count_aligned_mismatched_bases;
                        }
                        ++i;
                        ++ref_base;
                        ++read_i;
                    }
                    fi.count_aligned_bases += len;
                    continue;
                }
                if (co.equals((Object)CigarOperator.SOFT_CLIP)) {
                    ref_base += len;
                    read_i += len;
                    fi.count_soft_clip_bases += len;
                    continue;
                }
                if (co.equals((Object)CigarOperator.SKIPPED_REGION)) {
                    int seq1_end = ref_base - 1;
                    int seq2_start = ref_base + len;
                    SplicedReadInfo sri = this.track_site(current_reference_name, seq1_end, seq2_start, sr);
                    sri_ordered.add(sri);
                    sri2left.put(sri, fi);
                    fi = new SplicedReadFlankingInfo();
                    sri2right.put(sri, fi);
                    ref_base += len;
                    continue;
                }
                if (co.equals((Object)CigarOperator.INSERTION)) {
                    fi.count_inserted_bases += len;
                    read_i += len;
                    continue;
                }
                if (co.equals((Object)CigarOperator.DELETION)) {
                    fi.count_deleted_bases += len;
                    ref_base += len;
                    continue;
                }
                System.err.println("unhandled CIGAR operator " + co);
                System.exit(1);
            }
            SplicedReadInfo sri_first = null;
            SplicedReadInfo sri_last = null;
            if (sri_ordered.size() > 0) {
                sri_first = (SplicedReadInfo)sri_ordered.get(0);
                sri_last = (SplicedReadInfo)sri_ordered.get(sri_ordered.size() - 1);
            }
            for (SplicedReadInfo sri : sri2left.keySet()) {
                boolean flank_qc;
                boolean complain_r;
                SplicedReadFlankingInfo fi_left = (SplicedReadFlankingInfo)sri2left.get(sri);
                SplicedReadFlankingInfo fi_right = (SplicedReadFlankingInfo)sri2right.get(sri);
                double junk_ratio_l = fi_left.get_junk_ratio();
                double junk_ratio_r = fi_right.get_junk_ratio();
                boolean complain_l = this.JUNK_REPORT && junk_ratio_l >= this.JUNK_REPORT_MIN_RATIO_TO_COMPLAIN && (double)fi_left.count_aligned_bases >= this.JUNK_REPORT_MIN_LENGTH_TO_COMPLAIN;
                boolean bl = complain_r = this.JUNK_REPORT && junk_ratio_r >= this.JUNK_REPORT_MIN_RATIO_TO_COMPLAIN && (double)fi_right.count_aligned_bases >= this.JUNK_REPORT_MIN_LENGTH_TO_COMPLAIN;
                if (complain_l || complain_r) {
                    System.err.print(sri.get_name() + " read=" + sr.getReadName() + " CIGAR=" + sr.getCigar());
                    System.err.print(" l_mm_count=" + fi_left.count_aligned_mismatched_bases);
                    if (complain_l) {
                        System.err.print(" LEFT: aligned=" + fi_left.count_aligned_bases + " junk=" + fi_left.get_junk_ratio() + " mm=" + fi_left.get_junk_ratio_mismatches() + " sc=" + fi_left.get_junk_ratio_soft_clip() + " indel=" + fi_left.get_junk_ratio_indel());
                    }
                    if (complain_r) {
                        System.err.print(" RIGHT: aligned=" + fi_right.count_aligned_bases + " junk=" + fi_right.get_junk_ratio() + " mm=" + fi_right.get_junk_ratio_mismatches() + " sc=" + fi_right.get_junk_ratio_soft_clip() + " indel=" + fi_right.get_junk_ratio_indel());
                    }
                    System.err.println("");
                }
                boolean mapping_perfect = false;
                boolean mapping_clean = false;
                if (junk_ratio_l == 0.0 && junk_ratio_r == 0.0) {
                    mapping_perfect = true;
                    ++sri.counter_perfect;
                } else if (junk_ratio_l <= this.MAX_JUNK_RATIO_FOR_CLEAN_CALL && junk_ratio_r <= this.MAX_JUNK_RATIO_FOR_CLEAN_CALL) {
                    mapping_clean = true;
                    ++sri.counter_clean;
                }
                boolean bl2 = flank_qc = this.get_flank_qc(fi_left, sri.equals(sri_first)) && this.get_flank_qc(fi_right, sri.equals(sri_last));
                if (flank_qc) {
                    sri.increment_flanking_qc();
                }
                if (this.rpt_reads == null) continue;
                this.rpt_reads.set_value("read_name", sr.getReadName());
                this.rpt_reads.set_value("strand", sr.getReadNegativeStrandFlag() ? "-" : "+");
                this.rpt_reads.set_value("reference", Chromosome.standardize_name(sri.reference_name));
                this.rpt_reads.set_value("junction_start", Integer.toString(sri.segment_1_end));
                this.rpt_reads.set_value("junction_end", Integer.toString(sri.segment_2_start));
                this.rpt_reads.set_value("flanking_nt_left", Integer.toString(fi_left.count_aligned_bases));
                this.rpt_reads.set_value("flanking_nt_right", Integer.toString(fi_right.count_aligned_bases));
                this.rpt_reads.set_value("mapping_perfect", mapping_perfect ? "1" : "0");
                this.rpt_reads.set_value("mapping_clean", mapping_clean ? "1" : "0");
                boolean usable = true;
                if (this.RESTRICT_JUNCTION_START > 0 && sri.segment_1_end != this.RESTRICT_JUNCTION_START) {
                    usable = false;
                }
                if (this.RESTRICT_JUNCTION_END > 0 && sri.segment_2_start != this.RESTRICT_JUNCTION_END) {
                    usable = false;
                }
                if (!usable) continue;
                this.rpt_reads.end_row();
            }
        }
        this.flush_check(true, null);
        this.wf.finish();
        if (this.rpt_reads != null) {
            this.rpt_reads.close();
        }
        if (broken_edge_reads > 0) {
            System.err.println("reads mapped beyond end of reference: " + broken_edge_reads);
        }
    }

    private void flush_check(boolean force, SAMRecord sr) {
        if (this.VERBOSE) {
            System.err.println("flush check, size=" + this.events_by_name.size());
        }
        ArrayList<SplicedReadInfo> to_report = new ArrayList<SplicedReadInfo>();
        if (force) {
            to_report.addAll(this.events_by_name.values());
        } else {
            int current_start = sr.getAlignmentStart();
            if (this.VERBOSE) {
                System.err.println("current start=" + current_start);
            }
            ArrayList<SplicedReadInfo> all = new ArrayList<SplicedReadInfo>();
            ArrayList<SplicedReadInfo> candidates = new ArrayList<SplicedReadInfo>();
            for (SplicedReadInfo sri : this.events_by_name.values()) {
                all.add(sri);
                if (current_start <= sri.segment_2_start) continue;
                candidates.add(sri);
            }
            if (this.SORT) {
                for (SplicedReadInfo candidate : candidates) {
                    int overlaps = 0;
                    for (SplicedReadInfo sri : all) {
                        if (!candidate.overlaps(sri)) continue;
                        ++overlaps;
                    }
                    if (overlaps > 1) continue;
                    to_report.add(candidate);
                }
            } else {
                to_report.addAll(candidates);
            }
        }
        Collections.sort(to_report);
        for (SplicedReadInfo sri : to_report) {
            int count = sri.get_count();
            boolean usable = count >= this.minimum_observations_to_report;
            HashSet<UCSCRefGene> rgs = null;
            if (usable && this.ic != null) {
                boolean known;
                rgs = this.ic.find_exon_junction(sri);
                boolean bl = known = rgs != null && rgs.size() > 0;
                if (this.ANNOTATE_MODE) {
                    usable = true;
                } else {
                    boolean bl2 = this.novel_only ? !known : (usable = known);
                }
            }
            if (usable) {
                if (this.WRITE_BED) {
                    this.write_bed(sri, rgs);
                } else if (this.WRITE_DELIMITED) {
                    this.write_delimited(sri, rgs);
                } else {
                    this.write_counts(sri);
                }
            }
            this.events_by_name.remove(sri.get_name());
        }
    }

    public static void main(String[] argv) {
        SplicedReadReporter srr = new SplicedReadReporter();
        try {
            UCSCRefGeneReader rg = null;
            for (int i = 0; i < argv.length; ++i) {
                if (argv[i].equals("-bam")) {
                    srr.set_bam(new File(argv[++i]));
                    continue;
                }
                if (argv[i].equals("-refflat")) {
                    rg = new UCSCRefGeneReader(argv[++i]);
                    continue;
                }
                if (argv[i].equals("-t2g")) {
                    if (rg == null) {
                        System.err.println("ERROR: specify -refflat before -t2g");
                        System.exit(1);
                        continue;
                    }
                    rg.set_transcript2gene(argv[++i]);
                    continue;
                }
                if (argv[i].equals("-min-reads")) {
                    srr.set_minimum_observations_to_report(Integer.parseInt(argv[++i]));
                    continue;
                }
                if (argv[i].equals("-v")) {
                    srr.VERBOSE = true;
                    continue;
                }
                if (argv[i].equals("-bed")) {
                    srr.WRITE_BED = true;
                    continue;
                }
                if (argv[i].equals("-no-header")) {
                    srr.set_write_header(false);
                    continue;
                }
                if (argv[i].equals("-annotate")) {
                    srr.set_annotate_mode(true);
                    continue;
                }
                if (argv[i].equals("-of")) {
                    srr.set_outfile(argv[++i]);
                    continue;
                }
                if (argv[i].equals("-no-sort")) {
                    srr.SORT = false;
                    continue;
                }
                if (argv[i].equals("-reference-only")) {
                    srr.set_novel_only(false);
                    srr.WRITE_DELIMITED = true;
                    continue;
                }
                if (argv[i].equals("-rgb-known")) {
                    srr.set_known_rgb(argv[++i]);
                    continue;
                }
                if (argv[i].equals("-rgb-novel")) {
                    srr.set_novel_rgb(argv[++i]);
                    continue;
                }
                if (argv[i].equals("-2bit")) {
                    srr.set_reference_sequence(new TwoBitFile(argv[++i]));
                    continue;
                }
                if (argv[i].equals("-restrict-read-name")) {
                    srr.set_restrict_read_name(argv[++i]);
                    continue;
                }
                if (argv[i].equals("-restrict-start")) {
                    srr.set_restrict_junction_start(Integer.parseInt(argv[++i]));
                    continue;
                }
                if (argv[i].equals("-restrict-end")) {
                    srr.set_restrict_junction_end(Integer.parseInt(argv[++i]));
                    continue;
                }
                if (argv[i].equals("-name")) {
                    srr.get_query_region().tname = new String(argv[++i]);
                    continue;
                }
                if (argv[i].equals("-start")) {
                    srr.get_query_region().set_start(Integer.parseInt(argv[++i]));
                    continue;
                }
                if (argv[i].equals("-end")) {
                    srr.get_query_region().set_end(Integer.parseInt(argv[++i]));
                    continue;
                }
                if (argv[i].equals("-read-report")) {
                    srr.set_read_report(argv[++i]);
                    continue;
                }
                if (argv[i].equals("-primary-only")) {
                    srr.set_primary_read_mode(true);
                    continue;
                }
                System.err.println("ERROR: unknown parameter " + argv[i]);
                System.exit(1);
            }
            if (rg != null) {
                srr.set_intron_cache(new IntronCache(rg));
            }
            srr.report();
        }
        catch (Exception e) {
            System.err.println("ERROR: " + e);
            e.printStackTrace();
        }
    }

    private SplicedReadInfo track_site(String ref_name, int seq1_end, int seq2_start, SAMRecord sr) {
        SplicedReadInfo sri;
        String name;
        if (this.VERBOSE) {
            System.err.println("tracking " + ref_name + " " + seq1_end + " " + seq2_start + " read=" + sr.getReadName());
        }
        if (this.events_by_name.containsKey(name = (sri = new SplicedReadInfo(ref_name, seq1_end, seq2_start)).get_name())) {
            sri = this.events_by_name.get(name);
        } else {
            this.events_by_name.put(name, sri);
        }
        sri.increment_counter();
        if (sr.getReadNegativeStrandFlag()) {
            sri.increment_minus();
        } else {
            sri.increment_plus();
        }
        return sri;
    }

    private void write_delimited(SplicedReadInfo sri, HashSet<UCSCRefGene> rgs) {
        ArrayList<String> fields;
        if (!this.wrote_header) {
            fields = new ArrayList<String>();
            fields.add("junction");
            fields.add("count");
            if (this.ANNOTATE_MODE) {
                fields.add("type");
            }
            if (!this.novel_only) {
                fields.add("genes");
                fields.add("transcripts");
            }
            if (this.ANNOTATE_MODE) {
                fields.add("qc_flanking");
                fields.add("qc_plus");
                fields.add("qc_minus");
                fields.add("qc_perfect_reads");
                fields.add("qc_clean_reads");
            }
            this.ps.println(Str.join("\t", fields));
            this.wrote_header = true;
        }
        fields = new ArrayList();
        fields.add(this.format_junction(sri));
        fields.add(Integer.toString(sri.counter));
        if (!this.novel_only) {
            if (rgs == null || rgs.size() == 0) {
                if (this.ANNOTATE_MODE) {
                    fields.add("novel");
                }
                fields.add("");
                fields.add("");
            } else {
                ArrayList<String> genes = new ArrayList<String>();
                ArrayList<String> transcripts = new ArrayList<String>();
                for (UCSCRefGene rg : rgs) {
                    if (rg.name2 == null || rg.name2.length() == 0) {
                        genes.add("");
                    } else {
                        genes.add(rg.name2);
                    }
                    transcripts.add(rg.name);
                }
                if (this.ANNOTATE_MODE) {
                    fields.add("known");
                }
                fields.add(Str.join(",", genes));
                fields.add(Str.join(",", transcripts));
            }
            if (this.ANNOTATE_MODE) {
                fields.add(Integer.toString(sri.counter_flanking_qc));
                fields.add(Integer.toString(sri.counter_plus));
                fields.add(Integer.toString(sri.counter_minus));
                fields.add(Integer.toString(sri.counter_perfect));
                fields.add(Integer.toString(sri.counter_clean));
            }
        }
        this.ps.println(Str.join("\t", fields));
    }

    private String format_junction(SplicedReadInfo sri) {
        return sri.reference_name + ":" + sri.segment_1_end + ":+," + sri.reference_name + ":" + sri.segment_2_start + ":+";
    }

    private void write_counts(SplicedReadInfo sri) {
        this.ps.println(this.format_junction(sri) + "\t" + sri.counter);
    }

    private void write_bed(SplicedReadInfo sri, HashSet<UCSCRefGene> rgs) {
        if (!this.wrote_header) {
            this.ps.println("track name=junctions description=\"BAM junctions\" visibility=3 itemRgb=\"On\"");
            this.wrote_header = true;
        }
        ArrayList<String> fields = new ArrayList<String>();
        fields.add(sri.reference_name);
        fields.add(Integer.toString(sri.segment_1_end - 1));
        fields.add(Integer.toString(sri.segment_2_start));
        String gene_name = null;
        if (rgs != null) {
            for (UCSCRefGene rg : rgs) {
                gene_name = rg.name2;
                if (gene_name == null) continue;
                break;
            }
        }
        if (gene_name == null) {
            gene_name = "junction";
        }
        String name = Integer.toString(sri.counter);
        fields.add(name);
        fields.add(Integer.toString(sri.counter));
        fields.add("+");
        fields.add((String)fields.get(1));
        fields.add((String)fields.get(2));
        String color = rgs == null || rgs.size() == 0 ? this.RGB_NOVEL : this.RGB_KNOWN;
        fields.add(color);
        this.ps.println(Str.join("\t", fields));
    }

    private boolean get_flank_qc(SplicedReadFlankingInfo fi, boolean is_read_edge) {
        return fi.count_aligned_bases >= (is_read_edge ? this.QC_MIN_FLANKING_NT_READ_EDGE : this.QC_MIN_FLANKING_NT_INTERNAL);
    }
}

