/*
 * Decompiled with CFR 0.152.
 */
package Ace2;

import Ace2.Base;
import Ace2.ReadTrackInfo;
import Ace2.Reporter;
import Ace2.Strand;
import htsjdk.samtools.SAMRecord;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StrandCounter {
    HashMap<String, ArrayList<ReadTrackInfo>> tracker = new HashMap();
    HashMap<Base, Integer> counts_single = new HashMap();
    HashMap<Base, Integer> counts_double = new HashMap();
    HashMap<Base, Integer> counts_all = new HashMap();
    static final Base[] ALL_BASES = new Base[]{Base.BASE_A, Base.BASE_C, Base.BASE_G, Base.BASE_T};

    public void add_read(SAMRecord sr, Base base) {
        String read_name = sr.getReadName();
        Strand strand = Strand.valueOfSAMRecord(sr);
        ArrayList<ReadTrackInfo> queue = this.tracker.get(read_name);
        if (queue == null) {
            queue = new ArrayList();
            this.tracker.put(read_name, queue);
        }
        queue.add(new ReadTrackInfo(base, strand));
    }

    public void build_counts() {
        HashSet<Strand> saw_strand;
        ArrayList<String> bad_ids = new ArrayList<String>();
        for (String read_name : this.tracker.keySet()) {
            saw_strand = new HashSet<Strand>();
            HashSet<Base> saw_base = new HashSet<Base>();
            for (ReadTrackInfo rti : this.tracker.get(read_name)) {
                saw_strand.add(rti.strand);
                saw_base.add(rti.base);
            }
            if (saw_strand.size() <= 1 || saw_base.size() <= 1) continue;
            bad_ids.add(read_name);
        }
        for (String bad_id : bad_ids) {
            this.tracker.remove(bad_id);
            System.err.println("discarding inconsistent strand sequence for pair " + bad_id);
        }
        for (String read_name : this.tracker.keySet()) {
            String saw_type;
            HashMap<Base, Integer> where;
            saw_strand = new HashSet();
            HashMap<Base, Integer> counts = new HashMap<Base, Integer>();
            for (ReadTrackInfo rti : this.tracker.get(read_name)) {
                saw_strand.add(rti.strand);
                Integer count = (Integer)counts.get((Object)rti.base);
                if (count == null) {
                    count = 0;
                }
                counts.put(rti.base, count + 1);
            }
            if (saw_strand.size() <= 0) continue;
            if (saw_strand.size() == 1) {
                where = this.counts_single;
                saw_type = "single";
            } else {
                where = this.counts_double;
                saw_type = "double";
            }
            for (Base base : counts.keySet()) {
                Integer count = where.get((Object)base);
                if (count == null) {
                    count = 0;
                }
                int this_count = (Integer)counts.get((Object)base);
                where.put(base, count + this_count);
                count = this.counts_all.get((Object)base);
                if (count == null) {
                    count = 0;
                }
                this.counts_all.put(base, count + this_count);
            }
        }
    }

    public void populate_report(Reporter rpt) {
        for (int i = 0; i < ALL_BASES.length; ++i) {
            Base base = ALL_BASES[i];
            Integer count = this.counts_single.get((Object)base);
            if (count == null) {
                count = 0;
            }
            rpt.set_value("single_read_support_" + (Object)((Object)base), count.toString());
            count = this.counts_double.get((Object)base);
            if (count == null) {
                count = 0;
            }
            rpt.set_value("double_read_support_" + (Object)((Object)base), count.toString());
        }
    }

    public HashMap<String, Integer> get_all_counts_string() {
        HashMap<String, Integer> counts = new HashMap<String, Integer>();
        for (Base base : this.counts_all.keySet()) {
            String key = base.toString();
            counts.put(key, this.counts_all.get((Object)base));
        }
        return counts;
    }
}

