/*
 * Decompiled with CFR 0.152.
 */
package Ace2;

import Ace2.ReferenceOrVariant;
import Ace2.SNPConfig;
import Ace2.Strand;
import Ace2.TumorNormal;
import Ace2.TumorNormalReferenceTracker;

public class StrandSkewFilter {
    SNPConfig config;
    private int v_plus;
    private int v_minus;
    private int cov_plus;
    private int cov_minus;
    public static boolean VERBOSE = false;
    boolean EVALUATABLE;
    boolean FILTER_FAIL;
    double VARIANT_PLUS_STRAND_FREQUENCY;
    private int UNEVALUATABLE_REASON;
    public static final int REASON_LOW_VARIANT_COUNT = 1;
    public static final int REASON_LOW_PLUS_COVERAGE = 2;
    public static final int REASON_LOW_MINUS_COVERAGE = 3;

    public StrandSkewFilter(SNPConfig config, TumorNormalReferenceTracker tnrt) {
        this.config = config;
        this.v_plus = tnrt.get_variant_fwd_count();
        this.v_minus = tnrt.get_variant_rev_count();
        this.cov_plus = tnrt.get_coverage_fwd();
        this.cov_minus = tnrt.get_coverage_rev();
    }

    public static void main(String[] argv) {
        StrandSkewFilter.test_skew();
    }

    public static void test_skew() {
        SNPConfig snp_config = new SNPConfig();
        TumorNormalReferenceTracker t = new TumorNormalReferenceTracker();
        t.add_set(ReferenceOrVariant.REFERENCE, Strand.STRAND_POSITIVE, TumorNormal.NORMAL, 9);
        t.add_set(ReferenceOrVariant.REFERENCE, Strand.STRAND_NEGATIVE, TumorNormal.NORMAL, 14);
        t.add_set(ReferenceOrVariant.REFERENCE, Strand.STRAND_POSITIVE, TumorNormal.TUMOR, 5);
        t.add_set(ReferenceOrVariant.REFERENCE, Strand.STRAND_NEGATIVE, TumorNormal.TUMOR, 24);
        t.add_set(ReferenceOrVariant.VARIANT, Strand.STRAND_POSITIVE, TumorNormal.NORMAL, 5);
        t.add_set(ReferenceOrVariant.VARIANT, Strand.STRAND_NEGATIVE, TumorNormal.NORMAL, 0);
        t.add_set(ReferenceOrVariant.VARIANT, Strand.STRAND_POSITIVE, TumorNormal.TUMOR, 7);
        t.add_set(ReferenceOrVariant.VARIANT, Strand.STRAND_NEGATIVE, TumorNormal.TUMOR, 0);
        t.analyze();
        StrandSkewFilter ssk = new StrandSkewFilter(snp_config, t);
        boolean ok = ssk.skew_test();
        System.err.println("skew passed?: " + ok);
    }

    public boolean skew_test() {
        this.FILTER_FAIL = false;
        this.VARIANT_PLUS_STRAND_FREQUENCY = -1.0;
        int v_total = this.v_plus + this.v_minus;
        this.EVALUATABLE = false;
        this.UNEVALUATABLE_REASON = 0;
        if (v_total < this.config.STRAND_SKEW_CALL_MIN_VARIANT_COUNT) {
            this.UNEVALUATABLE_REASON = 1;
        } else if (this.cov_plus < this.config.STRAND_SKEW_CALL_MIN_STRAND_COVERAGE) {
            this.UNEVALUATABLE_REASON = 2;
        } else if (this.cov_minus < this.config.STRAND_SKEW_CALL_MIN_STRAND_COVERAGE) {
            this.UNEVALUATABLE_REASON = 3;
        } else {
            double v_minus_normalized;
            double v_plus_normalized;
            this.EVALUATABLE = true;
            if (this.cov_plus > this.cov_minus) {
                v_plus_normalized = this.v_plus;
                v_minus_normalized = (double)this.v_minus * ((double)this.cov_plus / (double)this.cov_minus);
            } else {
                v_plus_normalized = (double)this.v_plus * ((double)this.cov_minus / (double)this.cov_plus);
                v_minus_normalized = this.v_minus;
            }
            double v_total_normalized = v_plus_normalized + v_minus_normalized;
            this.VARIANT_PLUS_STRAND_FREQUENCY = v_plus_normalized / v_total_normalized;
            if (VERBOSE) {
                System.err.print("c+=" + this.cov_plus + " c-=" + this.cov_minus + " v+=" + this.v_plus + " v-=" + this.v_minus + " v+n=" + v_plus_normalized + " v-n=" + v_minus_normalized + " freq=" + this.VARIANT_PLUS_STRAND_FREQUENCY + " evaluatable=" + this.EVALUATABLE + " " + " uneval_reason=" + this.explain_unevaluatable());
            }
        }
        double min_skew_minus = 1.0 - this.config.STRAND_SKEW_FILTER_MIN_STRAND_PERCENT_TO_CONSIDER_SKEWED;
        if (this.config.STRAND_SKEW_FILTER_ENABLE && this.EVALUATABLE && v_total >= this.config.STRAND_SKEW_FILTER_MIN_VARIANT_COUNT && this.cov_plus >= this.config.STRAND_SKEW_FILTER_MIN_STRAND_COVERAGE && this.cov_minus >= this.config.STRAND_SKEW_FILTER_MIN_STRAND_COVERAGE && (this.VARIANT_PLUS_STRAND_FREQUENCY >= this.config.STRAND_SKEW_FILTER_MIN_STRAND_PERCENT_TO_CONSIDER_SKEWED || this.VARIANT_PLUS_STRAND_FREQUENCY <= min_skew_minus)) {
            this.FILTER_FAIL = true;
        }
        if (this.EVALUATABLE && VERBOSE) {
            System.err.println(" passed=" + !this.FILTER_FAIL);
        }
        return !this.FILTER_FAIL;
    }

    public double get_normalized_variant_plus_strand_frequency() {
        return this.VARIANT_PLUS_STRAND_FREQUENCY;
    }

    public boolean is_evaluatable() {
        return this.EVALUATABLE;
    }

    public String explain_unevaluatable() {
        String reason = "unknown";
        reason = this.UNEVALUATABLE_REASON == 0 ? "none" : (this.UNEVALUATABLE_REASON == 1 ? "low_variant_count" : (this.UNEVALUATABLE_REASON == 2 ? "low_plus_strand_coverage" : (this.UNEVALUATABLE_REASON == 3 ? "low_minus_strand_coverage" : "unhandled code " + this.UNEVALUATABLE_REASON)));
        return reason;
    }
}

