/*
 * Decompiled with CFR 0.152.
 */
package Ace2;

import Funk.Str;
import java.io.File;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.filechooser.FileFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SuffixFileFilter
extends FileFilter {
    private ArrayList<String> suffixes;

    public SuffixFileFilter() {
        this.suffixes = new ArrayList();
    }

    public SuffixFileFilter(String s) {
        this.suffixes = new ArrayList();
        this.add_suffix(s);
    }

    public SuffixFileFilter(ArrayList<String> suffixes) {
        this.suffixes = suffixes;
    }

    public void add_suffix(String s) {
        this.suffixes.add(s);
    }

    @Override
    public boolean accept(File f) {
        boolean ok = false;
        if (f.isDirectory()) {
            ok = true;
        } else {
            for (String suffix : this.suffixes) {
                String p = "\\." + suffix + "$";
                Pattern pattern = Pattern.compile(p, 2);
                Matcher matcher = pattern.matcher(f.toString());
                boolean result = matcher.find();
                if (!result) continue;
                ok = true;
            }
        }
        return ok;
    }

    @Override
    public String getDescription() {
        ArrayList<String> descs = new ArrayList<String>();
        for (String suffix : this.suffixes) {
            descs.add("." + suffix);
        }
        return Str.join("/", descs);
    }
}

