/*
 * Decompiled with CFR 0.152.
 */
package Ace2;

import Ace2.ReferenceSequence;
import Ace2.TwoBitHeader;
import Ace2.TwoBitSequence;
import htsjdk.samtools.cram.ref.ReferenceSource;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TwoBitFileLite
implements ReferenceSequence {
    private TwoBitHeader tbh;

    public TwoBitFileLite(String filename) throws FileNotFoundException, IOException {
        this.tbh = new TwoBitHeader(filename);
        this.tbh.set_caching(false);
    }

    @Override
    public byte[] get_region(String sequence_name, int start_base, int length) throws IOException {
        TwoBitSequence tbs = this.tbh.get_sequence(sequence_name);
        byte[] result = null;
        if (tbs != null) {
            result = tbs.get_region(start_base, length);
        }
        return result;
    }

    @Override
    public byte[] get_all(String sequence_name) throws IOException {
        TwoBitSequence tbs = this.tbh.get_sequence(sequence_name);
        byte[] result = null;
        if (tbs != null) {
            result = tbs.get_full_sequence();
        }
        return result;
    }

    @Override
    public int get_length(String sequence_name) throws IOException {
        TwoBitSequence tbs = this.tbh.get_sequence(sequence_name, false);
        int length = -1;
        if (tbs != null) {
            length = tbs.get_length();
        }
        return length;
    }

    public static void main(String[] argv) {
        block6: {
            String fn = "c:/generatable/hg18/hg18.2bit";
            try {
                TwoBitFileLite tbf = new TwoBitFileLite(fn);
                if (argv.length == 3) {
                    String chr_name = argv[0];
                    int start = Integer.parseInt(argv[1]);
                    int len = Integer.parseInt(argv[2]);
                    byte[] seq = tbf.get_region(chr_name, start, len);
                    System.err.println("sequence: " + new String(seq));
                    break block6;
                }
                byte[] chr = tbf.get_all("chr2");
                System.err.println("chr length = " + chr.length);
                while (true) {
                    System.gc();
                    try {
                        System.err.println("sleeping...");
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException e) {}
                }
            }
            catch (Exception e) {
                System.err.println("ERROR: " + e);
                e.printStackTrace();
            }
        }
    }

    @Override
    public boolean supports_sequence_list() {
        return true;
    }

    @Override
    public ArrayList<String> get_sequence_names() {
        return this.tbh.get_sequence_names();
    }

    @Override
    public ReferenceSource getReferenceSource() {
        System.err.println("ERROR: getReferenceSource() not implemented");
        return null;
    }
}

