/*
 * Decompiled with CFR 0.152.
 */
package Ace2;

import Ace2.BigEndianReader;
import Ace2.ChromosomeDisambiguator;
import Ace2.EndianReader;
import Ace2.LittleEndianReader;
import Ace2.SAMUtils;
import Ace2.TwoBitSequence;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TwoBitHeader {
    private static final int TWOBIT_SIGNATURE = 440477507;
    private File file;
    private boolean error = false;
    private int sequence_count;
    private int reserved;
    private boolean enable_caching;
    private ArrayList<String> sequences;
    private HashMap<String, Integer> sequence_offsets;
    private EndianReader er;
    private HashMap<String, TwoBitSequence> seqmap;

    public TwoBitHeader(File file) throws FileNotFoundException, IOException {
        this.file = file;
        this.setup();
    }

    public TwoBitHeader(String filename) throws FileNotFoundException, IOException {
        this.file = new File(filename);
        this.setup();
    }

    private RandomAccessFile open_randomaccessfile() throws IOException, FileNotFoundException {
        return new RandomAccessFile(this.file, "r");
    }

    private void setup() throws FileNotFoundException, IOException {
        this.enable_caching = true;
        this.sequences = new ArrayList();
        this.sequence_offsets = new HashMap();
        this.seqmap = new HashMap();
        RandomAccessFile raf = this.open_randomaccessfile();
        try {
            raf.seek(0L);
            this.er = new BigEndianReader(raf);
            int sig = this.er.readInt();
            if (sig == 440477507) {
                System.err.println("big-endian .2bit file, UNTESTED");
            } else {
                raf.seek(0L);
                this.er = new LittleEndianReader(raf);
                int sig2 = this.er.readInt();
                if (sig2 != 440477507) {
                    System.err.println("error: can't find .2bit signature");
                    System.err.println("sig1=" + sig + " sig2=" + sig2);
                    this.error = true;
                }
            }
            if (!this.error) {
                int version = this.er.readInt();
                if (version == 0) {
                    long first_header_record_offset;
                    this.sequence_count = this.er.readInt();
                    int reserved = this.er.readInt();
                    for (int i = 0; i < this.sequence_count; ++i) {
                        byte len = raf.readByte();
                        byte[] buf = new byte[len];
                        if (raf.read(buf) == len) {
                            String s = new String(buf);
                            int offset = this.er.readInt();
                            this.sequences.add(s);
                            this.sequence_offsets.put(s, offset);
                            continue;
                        }
                        System.err.println("ERROR reading sequence ID!");
                        this.error = true;
                    }
                    long first_record_offset = this.er.getFilePointer();
                    if (first_record_offset != (first_header_record_offset = (long)this.sequence_offsets.get(this.sequences.get(0)).intValue())) {
                        System.err.println("WARNING: first record position (i.e. after index) at " + first_record_offset + ", header says at " + first_header_record_offset + "; header corrupt??");
                    }
                } else {
                    System.err.println("ERROR: nonzero version " + version);
                    this.error = true;
                }
            }
        }
        catch (Exception e) {
            System.err.println("ERROR: " + e);
            e.printStackTrace();
            this.error = true;
        }
    }

    public void set_caching(boolean v) {
        this.enable_caching = v;
    }

    public TwoBitSequence get_sequence(String id) throws IOException {
        return this.get_sequence(id, true);
    }

    public TwoBitSequence get_sequence(String id, boolean read_fully) throws IOException {
        TwoBitSequence result = this.seqmap.get(id);
        RandomAccessFile raf = this.open_randomaccessfile();
        if (result == null) {
            ChromosomeDisambiguator cd;
            String key;
            Integer offset = null;
            Iterator<String> i$ = SAMUtils.get_refname_alternates(id).iterator();
            while (i$.hasNext() && (offset = this.sequence_offsets.get(key = i$.next())) == null) {
            }
            if (offset == null && (key = (cd = new ChromosomeDisambiguator(this.sequence_offsets.keySet())).find(id)) != null) {
                offset = this.sequence_offsets.get(key);
            }
            if (offset != null) {
                this.er.set_randomaccessfile(raf);
                result = new TwoBitSequence(this.er, offset, read_fully);
                if (this.enable_caching) {
                    this.seqmap.put(id, result);
                }
            }
        } else {
            result.set_randomaccessfile(raf);
        }
        return result;
    }

    public static void main(String[] argv) {
        String fn = "c:/generatable/hg18/hg18.2bit";
        try {
            if (argv.length == 3) {
                String chr_name = argv[0];
                int start = Integer.parseInt(argv[1]);
                int len = Integer.parseInt(argv[2]);
                TwoBitHeader tbh = new TwoBitHeader(new File(fn));
                TwoBitSequence tbs = tbh.get_sequence(chr_name);
                byte[] seq = tbs.get_region(start, len);
                System.err.println("sequence: " + new String(seq));
            } else {
                System.err.println("specify chr start len");
                System.exit(1);
            }
        }
        catch (Exception e) {
            System.err.println("ERROR: " + e);
            e.printStackTrace();
        }
    }

    public ArrayList<String> get_sequence_names() {
        return this.sequences;
    }
}

