/*
 * Decompiled with CFR 0.152.
 */
package Ace2;

import htsjdk.samtools.SAMRecord;
import java.security.MessageDigest;
import java.util.HashMap;

public class UniqueReadName {
    HashMap<String, Integer> read_count;
    private boolean md5_mode = false;
    private int md5_len = 0;
    private MessageDigest md5;
    private boolean inthash_mode = false;
    private int inthash_bucket_mod;
    private Integer[] inthash = null;

    public UniqueReadName() {
        this.setup();
    }

    private void setup() {
        this.read_count = new HashMap();
        try {
            this.md5 = MessageDigest.getInstance("MD5");
        }
        catch (Exception e) {
            System.err.println("ERROR: can't get MD5");
        }
    }

    public void reset() {
        this.setup();
    }

    public void set_md5_mode(boolean mode, int len) {
        this.md5_mode = mode;
        this.md5_len = len;
    }

    public void set_inthash_mode(boolean mode, int bits) {
        this.inthash_mode = mode;
        this.inthash_bucket_mod = 0;
        for (int i = 0; i < bits; ++i) {
            this.inthash_bucket_mod = this.inthash_bucket_mod << 1 | 1;
        }
        System.err.println("bucket mask: " + this.inthash_bucket_mod);
        this.inthash = new Integer[this.inthash_bucket_mod + 1];
    }

    public String get_suffix(SAMRecord sr) {
        return this.get_suffix(sr.getReadName(), sr.getReadNegativeStrandFlag());
    }

    public String get_suffix(String read_name, boolean rc) {
        int counter;
        String suffix = rc ? "R" : "F";
        String key = read_name + suffix;
        if (this.inthash_mode) {
            int h = 0;
            char[] ary = key.toCharArray();
            for (int i = 0; i < ary.length; ++i) {
                h = (h << 2) + ary[i];
            }
            int ikey = Math.abs(h) % this.inthash_bucket_mod;
            Integer cnt = this.inthash[ikey];
            counter = (cnt == null ? 0 : cnt) + 1;
            this.inthash[ikey] = counter;
        } else {
            Integer cnt;
            if (this.md5_mode) {
                this.md5.reset();
                char[] ary = key.toCharArray();
                byte[] b = new byte[ary.length];
                for (int i = 0; i < ary.length; ++i) {
                    b[i] = (byte)ary[i];
                }
                key = new String(this.md5.digest(b), 0, this.md5_len);
            }
            counter = ((cnt = this.read_count.get(key)) == null ? 0 : cnt) + 1;
            this.read_count.put(key, counter);
        }
        suffix = suffix.concat(Integer.toString(counter));
        return suffix;
    }

    public static void main(String[] argv) {
        UniqueReadName urn = new UniqueReadName();
        urn.set_inthash_mode(true, 19);
        System.err.println(urn.get_suffix("someread", false));
        System.err.println(urn.get_suffix("someread", true));
        System.err.println(urn.get_suffix("otherread", false));
        System.err.println(urn.get_suffix("someread", false));
    }
}

