/*
 * Decompiled with CFR 0.152.
 */
package Ace2;

import Ace2.IndelInfo;
import Ace2.SNPConfig;
import Ace2.SNPTrackInfo;
import htsjdk.samtools.SAMRecord;
import java.util.ArrayList;
import java.util.HashSet;

public class UniqueStartTracker {
    HashSet<Integer> starts;
    HashSet<Integer> starts_f;
    HashSet<Integer> starts_r;
    SNPConfig config;

    public UniqueStartTracker(SNPConfig config, ArrayList list) {
        this.config = config;
        this.starts = new HashSet();
        this.starts_f = new HashSet();
        this.starts_r = new HashSet();
        SAMRecord sr = null;
        for (Object o : list) {
            if (o instanceof SNPTrackInfo) {
                sr = ((SNPTrackInfo)o).sr;
            } else if (o instanceof IndelInfo) {
                sr = ((IndelInfo)o).sr;
            } else {
                System.err.println("ERROR: unhandled object " + o);
                System.exit(1);
            }
            int start = sr.getUnclippedStart();
            this.starts.add(start);
            if (sr.getReadNegativeStrandFlag()) {
                this.starts_r.add(start);
                continue;
            }
            this.starts_f.add(start);
        }
    }

    public int get_unique_read_start_positions() {
        return this.starts.size();
    }

    public int get_unique_read_start_positions_fwd() {
        return this.starts_f.size();
    }

    public int get_unique_read_start_positions_rev() {
        return this.starts_r.size();
    }

    public boolean are_counts_ok() {
        boolean ok = true;
        if (this.starts.size() < this.config.MIN_UNIQUE_START_POSITIONS_FOR_ALT_ALLELE) {
            ok = false;
        }
        return ok;
    }
}

