/*
 * Decompiled with CFR 0.152.
 */
package Ace2;

import Ace2.Base;
import Ace2.RefGene;
import java.util.HashMap;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class dbSNP {
    String name;
    String chrom;
    String strand;
    String observed_bases;
    int start;
    int end;

    public dbSNP(HashMap<String, String> row) {
        this.name = row.get("name");
        this.chrom = row.get("chrom");
        this.start = Integer.parseInt(row.get("chromStart"));
        this.end = Integer.parseInt(row.get("chromEnd"));
        this.strand = row.get("strand");
        this.observed_bases = row.get("observed");
    }

    public dbSNP(String[] fields) {
        if (fields.length == 7 && fields[0].equals("dbsnp")) {
            int fi = 1;
            this.name = new String(fields[fi++]);
            this.chrom = new String(fields[fi++]);
            this.start = Integer.parseInt(fields[fi++]);
            this.end = Integer.parseInt(fields[fi++]);
            this.strand = new String(fields[fi++]);
            this.observed_bases = new String(fields[fi++]);
        } else {
            System.err.println("dbSNP init error, wrong field length");
        }
    }

    public String get_normalized_observed_bases() {
        String result;
        if (this.strand.equals("+")) {
            result = this.observed_bases;
        } else {
            char[] res = this.observed_bases.toCharArray();
            for (int i = 0; i < res.length; ++i) {
                if (res[i] == '/') continue;
                res[i] = RefGene.complement(res[i]);
            }
            result = new String(res);
        }
        return result;
    }

    public boolean matches(Base b1, Base b2) {
        HashSet<Base> dbsnp_bases = new HashSet<Base>();
        char[] norm = this.get_normalized_observed_bases().toCharArray();
        for (int i = 0; i < norm.length; ++i) {
            if (norm[i] == '/') continue;
            dbsnp_bases.add(Base.valueOf(norm[i]));
        }
        HashSet<Base> query = new HashSet<Base>();
        query.add(b1);
        query.add(b2);
        return dbsnp_bases.equals(query);
    }

    public void consensus_adjust(int i) {
        this.start -= i - 1;
        this.end -= i - 1;
    }
}

