/*
 * Decompiled with CFR 0.152.
 */
package Ace2;

import Ace2.Base;
import Ace2.Chromosome;
import Ace2.IntBucketIndex;
import Ace2.SNPConfig;
import Ace2.dbSNPEntry;
import Ace2.dbSNPHeader;
import Ace2.dbSNPQuery;
import Funk.Timer;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.HashMap;

public class dbSNPDB
implements dbSNPQuery {
    static final int BUCKET_SIZE = 5000;
    private String blob_filename;
    private HashMap<Chromosome, IntBucketIndex> index;
    private HashMap<String, dbSNPHeader> headers;
    private Chromosome current_chr = null;
    private IntBucketIndex current_bucket = null;
    private static final int SUPPORTED_VERSION = 2;
    private static final String MAGIC = "CdDF";
    private boolean CACHE = true;

    public dbSNPDB(String blob_filename) {
        this.blob_filename = blob_filename;
        this.index = new HashMap();
        this.headers = new HashMap();
        this.parse_header();
    }

    private void parse_header() {
        try {
            FileInputStream is = new FileInputStream(new File(this.blob_filename));
            DataInputStream dis = new DataInputStream(new BufferedInputStream(is));
            byte[] buf = new byte[4];
            dis.read(buf);
            int version = dis.readInt();
            if (new String(buf).equals(MAGIC) && version == 2) {
                int total_snp_count = dis.readInt();
                int total_chrs = dis.readInt();
                for (int ci = 0; ci < total_chrs; ++ci) {
                    int len = dis.readInt();
                    buf = new byte[len];
                    dis.read(buf);
                    dbSNPHeader header = new dbSNPHeader();
                    header.name = Chromosome.standardize_name(new String(buf));
                    header.count = dis.readInt();
                    header.position = dis.readInt();
                    this.headers.put(header.name, header);
                }
            } else {
                System.err.println("ERROR: incorrect magic/version for " + this.blob_filename);
            }
        }
        catch (Exception e) {
            System.err.println("ERROR parsing " + this.blob_filename + ": " + e);
            e.printStackTrace();
            System.exit(1);
        }
    }

    public void set_caching(boolean v) {
        this.CACHE = v;
    }

    public void set_current_chromosome(Chromosome chr) {
        if (!this.CACHE) {
            this.index.clear();
        }
        this.current_chr = chr;
        if (chr == null) {
            this.current_bucket = null;
        } else {
            this.current_bucket = this.index.get((Object)chr);
            if (this.current_bucket == null) {
                try {
                    this.current_bucket = this.parse_chr(chr.toString());
                    if (this.CACHE) {
                        this.index.put(chr, this.current_bucket);
                    }
                }
                catch (Exception e) {
                    System.err.println("parse error: " + e.toString());
                    e.printStackTrace();
                }
            }
        }
    }

    public IntBucketIndex parse_chr(String key) throws IOException, FileNotFoundException {
        Timer t = new Timer("dbsnp parse of " + key);
        RandomAccessFile raf = new RandomAccessFile(new File(this.blob_filename), "r");
        dbSNPHeader header = this.headers.get(key);
        if (header == null) {
            System.err.println("ERROR, no dbSNP header for  + key");
            return null;
        }
        raf.seek(header.position);
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(raf.getFD()));
        DataInputStream dis = new DataInputStream(bis);
        IntBucketIndex bucket = new IntBucketIndex(5000);
        for (int i = 0; i < header.count; ++i) {
            dbSNPEntry entry = new dbSNPEntry(dis.readInt(), dis.readInt() + 1, dis.readByte());
            bucket.add(entry.chrom_start, entry);
        }
        t.finish();
        return bucket;
    }

    public dbSNPEntry find(int ref_base_num, Base b1, Base b2) {
        dbSNPEntry result = null;
        if (this.current_chr != null && this.current_bucket != null) {
            for (Object o : this.current_bucket.find(ref_base_num)) {
                dbSNPEntry e = (dbSNPEntry)o;
                if (!e.matches(ref_base_num, b1, b2)) continue;
                result = e;
                break;
            }
        }
        return result;
    }

    public static void main(String[] argv) {
        try {
            SNPConfig config = new SNPConfig();
            config.DBSNP_BLOB_FILE = "c:/generatable/dbsnp/dbsnp_binary_v2.blob";
            dbSNPDB dbsnp = new dbSNPDB(config.DBSNP_BLOB_FILE);
            dbsnp.set_caching(true);
            for (int i = 1; i < 10; ++i) {
                String key = "chr" + i;
                System.err.println("loading " + key);
                dbsnp.set_current_chromosome(Chromosome.valueOfString(key));
                try {
                    System.out.println("sleeping...");
                    Thread.sleep(5000L);
                    continue;
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
        }
        catch (Exception e) {
            System.err.println("ERROR: " + e);
            e.printStackTrace();
        }
    }

    public boolean snp_matches(int base_number, Base b1, Base b2) {
        boolean result = false;
        dbSNPEntry hit = this.find(base_number, b1, b2);
        return hit != null;
    }
}

