/*
 * Decompiled with CFR 0.152.
 */
package Ace2;

import Ace2.Base;
import Funk.Str;
import java.util.ArrayList;

public class dbSNPEntry {
    byte observed;
    int rs_num;
    int chrom_start;
    static final byte MASK_A = 1;
    static final byte MASK_C = 2;
    static final byte MASK_G = 4;
    static final byte MASK_T = 8;

    public dbSNPEntry(int rs_num, int chrom_start, byte observed) {
        this.rs_num = rs_num;
        this.chrom_start = chrom_start;
        this.observed = observed;
    }

    public boolean matches(int position, Base b1, Base b2) {
        return position == this.chrom_start && this.matches_base(b1) && this.matches_base(b2);
    }

    private boolean matches_base(Base b) {
        boolean match = false;
        switch (b) {
            case BASE_A: {
                match = (this.observed & 1) > 0;
                break;
            }
            case BASE_C: {
                match = (this.observed & 2) > 0;
                break;
            }
            case BASE_G: {
                match = (this.observed & 4) > 0;
                break;
            }
            case BASE_T: {
                match = (this.observed & 8) > 0;
            }
        }
        return match;
    }

    public String get_name() {
        return "rs" + this.rs_num;
    }

    public String describe() {
        String id = this.get_name();
        ArrayList<String> bases = new ArrayList<String>();
        if ((this.observed & 1) > 0) {
            bases.add("A");
        }
        if ((this.observed & 2) > 0) {
            bases.add("C");
        }
        if ((this.observed & 4) > 0) {
            bases.add("G");
        }
        if ((this.observed & 8) > 0) {
            bases.add("T");
        }
        return id + " " + this.chrom_start + " " + Str.join(",", bases);
    }
}

