/*
 * Decompiled with CFR 0.152.
 */
package Funk;

import Funk.Str;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DelimitedFile {
    private Vector labels;
    private Vector rows;
    private boolean uppercase_labels = false;
    private boolean trim_whitespace = false;
    private boolean standardize_dates = false;
    private boolean standardize_labels = false;
    private boolean filter_unix_comments = false;
    private boolean delimiter_mandatory = true;
    private ArrayList<String> comments;
    private String delimiter = null;

    public DelimitedFile() {
    }

    public DelimitedFile(InputStream is) throws IOException {
        this.parse(is);
    }

    public DelimitedFile(String filename) throws FileNotFoundException, IOException {
        this.parse(filename);
    }

    public DelimitedFile(File fn) throws FileNotFoundException, IOException {
        this.parse(fn);
    }

    public void set_trim_whitespace(boolean t) {
        this.trim_whitespace = t;
    }

    public void set_delimiter(String d) {
        this.delimiter = d;
    }

    public void set_delimiter_mandatory(boolean v) {
        this.delimiter_mandatory = v;
    }

    public void parse(InputStream is) throws IOException {
        this.process_file(new BufferedReader(new InputStreamReader(is)));
    }

    public void parse(String filename) throws FileNotFoundException, IOException {
        this.process_file(new BufferedReader(new FileReader(filename)));
    }

    public void parse(File f) throws FileNotFoundException, IOException {
        this.process_file(new BufferedReader(new FileReader(f)));
    }

    public Vector get_labels() {
        return this.labels;
    }

    public Vector get_rows() {
        return this.rows;
    }

    public Enumeration get_rows_enumeration() {
        return this.rows.elements();
    }

    public void uppercase_labels(boolean option) {
        this.uppercase_labels = option;
    }

    public void set_standardize_labels(boolean option) {
        this.standardize_labels = option;
    }

    public void set_standardize_dates(boolean option) {
        this.standardize_dates = option;
    }

    public void set_filter_unix_comments(boolean option) {
        this.filter_unix_comments = option;
    }

    private void process_file(BufferedReader br) throws IOException {
        boolean first = true;
        this.labels = new Vector();
        this.rows = new Vector();
        this.comments = new ArrayList();
        String line = br.readLine();
        if (line != null) {
            int i;
            String[] l;
            if (this.delimiter == null) {
                this.delimiter = this.detect_delimiter(line);
            }
            if (this.delimiter.equals("")) {
                if (this.delimiter_mandatory) {
                    throw new IOException("parse error: no delimiter detected in file header line!: " + line);
                }
                l = new String[]{line};
            } else {
                l = line.split(this.delimiter);
            }
            for (i = 0; i < l.length; ++i) {
                String label = l[i];
                if (this.uppercase_labels) {
                    label = label.toUpperCase();
                }
                if (this.standardize_labels && label.length() >= 2) {
                    String upper = label.toUpperCase();
                    String lower = label.toLowerCase();
                    label = upper.substring(0, 1) + lower.substring(1);
                }
                this.labels.addElement(label);
            }
            while ((line = br.readLine()) != null) {
                if (this.filter_unix_comments && line.length() > 0 && line.charAt(0) == '#') {
                    this.comments.add(line);
                    continue;
                }
                l = this.delimiter.equals("") ? new String[]{line} : line.split(this.delimiter);
                Hashtable row = new Hashtable();
                for (i = 0; i < l.length; ++i) {
                    if (this.trim_whitespace && l[i] != null) {
                        l[i] = Str.trim_whitespace(l[i]);
                    }
                    if (this.standardize_dates && l[i] != null) {
                        try {
                            DateFormat df = DateFormat.getDateInstance(3);
                            Date d = df.parse(l[i]);
                            StringBuffer sb = new StringBuffer();
                            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                            sb = sdf.format(d, sb, new FieldPosition(1));
                            l[i] = sb.toString();
                        }
                        catch (ParseException e) {
                            // empty catch block
                        }
                    }
                    row.put(this.labels.elementAt(i), l[i]);
                }
                this.rows.addElement(row);
            }
        }
    }

    private String detect_delimiter(String line) {
        String[] delims = new String[]{",", "\t"};
        int best_count = -1;
        String best_delim = delims[0];
        for (int i = 0; i < delims.length; ++i) {
            StringTokenizer st = new StringTokenizer(line, delims[i]);
            int this_count = st.countTokens();
            if (this_count <= best_count) continue;
            best_count = this_count;
            best_delim = delims[i];
        }
        return best_count > 1 ? best_delim : "";
    }

    public static void main(String[] argv) {
        try {
            DelimitedFile df = new DelimitedFile();
            df.set_standardize_dates(true);
            df.parse("../TCGA/updated_clinical_data.tab");
            Vector rows = df.get_rows();
            System.out.println(((Hashtable)rows.elementAt(0)).get("BCRPATIENTBARCODE"));
        }
        catch (Exception e) {
            System.out.println("exception: " + e);
        }
    }

    public ArrayList<String> get_unix_comments() {
        return this.comments;
    }
}

