/*
 * Decompiled with CFR 0.152.
 */
package Funk;

import Funk.Str;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class DelimitedWriter {
    private PrintWriter pw;
    private String delimiter;
    private boolean print_headers;
    private boolean header_printed;
    private boolean strict_mode;
    private Vector labels;

    public DelimitedWriter(PrintWriter pw) {
        this.pw = pw;
        this.setup();
    }

    public DelimitedWriter(PrintStream ps) {
        this.pw = new PrintWriter(ps);
        this.setup();
    }

    private void setup() {
        this.delimiter = "\t";
        this.header_printed = false;
        this.strict_mode = true;
        this.print_headers = true;
    }

    private void header_print_check() {
        if (!this.header_printed && this.labels != null) {
            if (this.print_headers) {
                this.pw.println(Str.join(this.delimiter, this.labels.elements()));
            }
            this.header_printed = true;
        }
    }

    public void set_delimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public void print_headers(boolean status) {
        this.print_headers = status;
    }

    public void set_labels(Vector v) {
        this.labels = v;
    }

    public void add_label(String label) {
        if (this.labels == null) {
            this.labels = new Vector();
        }
        this.labels.addElement(label);
    }

    public void write_row(Hashtable ht) {
        this.header_print_check();
        if (this.labels == null) {
            this.die("DelimitedWriter: can't write hash row without labels");
        } else {
            Vector<String> r = new Vector<String>();
            Enumeration e = this.labels.elements();
            while (e.hasMoreElements()) {
                String label = (String)e.nextElement();
                if (ht.containsKey(label)) {
                    String value = (String)ht.get(label);
                    if (value == null) {
                        value = "";
                    }
                    r.addElement(value);
                    continue;
                }
                this.die("DelimitedWriter: no value for column " + label);
            }
            this.pw.println(Str.join(this.delimiter, r.elements()));
        }
    }

    public void write_row(Vector v) {
        this.header_print_check();
        this.pw.println(Str.join(this.delimiter, v.elements()));
    }

    public static void main(String[] argv) {
        DelimitedWriter dw = new DelimitedWriter(System.out);
        dw.add_label("col1");
        dw.add_label("col2");
        dw.add_label("col3");
        Vector<String> row = new Vector<String>();
        row.addElement("one");
        row.addElement("two");
        row.addElement("three");
        dw.write_row(row);
        Hashtable<String, String> ht = new Hashtable<String, String>();
        ht.put("col1", "val1");
        ht.put("col2", "val2");
        ht.put("col3", "val3");
        dw.write_row(ht);
        dw.finish();
    }

    public void finish() {
        this.pw.flush();
    }

    private void die(String msg) {
        System.err.println(msg);
        System.exit(1);
    }
}

