/*
 * Decompiled with CFR 0.152.
 */
package Funk;

import Funk.Borders;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import javax.swing.JFrame;

public class Gr {
    public static void centerText(Component c, String message) {
        Graphics g = c.getGraphics();
        Dimension size = c.getSize();
        FontMetrics fm = g.getFontMetrics();
        g.setColor(Color.black);
        g.fillRect(0, 0, size.width, size.height);
        g.setColor(Color.white);
        g.drawString(message, size.width / 2 - fm.stringWidth(message) / 2, size.height / 2);
    }

    public static void centerText(Component c, Graphics g, String message) {
        Dimension size = c.getSize();
        FontMetrics fm = g.getFontMetrics();
        g.setColor(Color.black);
        g.fillRect(0, 0, size.width, size.height);
        g.setColor(Color.white);
        g.drawString(message, size.width / 2 - fm.stringWidth(message) / 2, size.height / 2);
    }

    public static Frame getFrame(Component c) {
        while (!(c instanceof Frame) && c != null) {
            c = c.getParent();
        }
        return (Frame)c;
    }

    public static JFrame getJFrame(Component c) {
        while (!(c instanceof JFrame) && c != null) {
            c = c.getParent();
        }
        return (JFrame)c;
    }

    public static void anchor(Frame f, String orientation) {
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension d = f.getSize();
        Insets insets = f.getInsets();
        Borders b = new Borders();
        b.center_x = screen.width / 2 - d.width / 2;
        b.center_y = screen.height / 2 - d.height / 2;
        b.left = insets.left;
        b.right = screen.width - d.width - insets.right;
        b.top = insets.top;
        b.bottom = screen.height - d.height - insets.bottom;
        if (orientation.equals("n")) {
            f.setLocation(b.center_x, b.top);
        } else if (orientation.equals("ne")) {
            f.setLocation(b.right, b.top);
        } else if (orientation.equals("e")) {
            f.setLocation(b.right, b.center_y);
        } else if (orientation.equals("se")) {
            f.setLocation(b.right, b.bottom);
        } else if (orientation.equals("s")) {
            f.setLocation(b.center_x, b.bottom);
        } else if (orientation.equals("sw")) {
            f.setLocation(b.left, b.bottom);
        } else if (orientation.equals("w")) {
            f.setLocation(b.left, b.center_y);
        } else if (orientation.equals("nw")) {
            f.setLocation(b.left, b.top);
        } else {
            System.out.println("unimplemented orientation:" + orientation);
        }
    }

    public static Point get_root_xy(Component c, int x, int y) {
        Point p;
        while (true) {
            p = c.getLocation();
            x += p.x;
            y += p.y;
            if (c instanceof Frame) break;
            c = c.getParent();
        }
        p = new Point(x, y);
        return p;
    }

    public static Point get_frame_border(Component c, String dir) {
        Frame f = c instanceof Frame ? (Frame)c : Gr.getFrame(c);
        Borders b = Gr.get_frame_borders(f);
        Point result = null;
        if (dir.equals("n")) {
            result = new Point(b.center_x, b.top);
        } else if (dir.equals("ne")) {
            result = new Point(b.right, b.top);
        } else if (dir.equals("e")) {
            result = new Point(b.right, b.center_y);
        } else if (dir.equals("se")) {
            result = new Point(b.right, b.bottom);
        } else if (dir.equals("s")) {
            result = new Point(b.center_x, b.bottom);
        } else if (dir.equals("sw")) {
            result = new Point(b.left, b.bottom);
        } else if (dir.equals("w")) {
            result = new Point(b.left, b.center_y);
        } else if (dir.equals("nw")) {
            result = new Point(b.left, b.top);
        } else {
            System.out.println("bogus anchor " + dir + "!");
        }
        return result;
    }

    public static Borders get_frame_borders(Frame f) {
        Dimension d = f.getSize();
        Point loc = f.getLocation();
        Insets insets = f.getInsets();
        Borders b = new Borders();
        b.left = loc.x - insets.left;
        b.right = loc.x + d.width + insets.right;
        b.top = loc.y - insets.top;
        b.bottom = loc.y + d.height + insets.bottom;
        b.center_x = loc.x + d.width / 2;
        b.center_y = loc.y + d.height / 2;
        return b;
    }

    public static void respectful_resize(Component c, double width, double height) {
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        int min_width = (int)((double)d.width * width);
        if (min_width < c.getMinimumSize().width) {
            min_width = c.getMinimumSize().width;
        }
        c.setSize(min_width, (int)((double)d.height * height));
    }
}

