/*
 * Decompiled with CFR 0.152.
 */
package Funk;

import Funk.MenuBuilder;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class LookAndFeeler
implements ActionListener {
    private MenuBuilder mb;
    private JFrame jf;
    private UIManager.LookAndFeelInfo[] lif;
    private ButtonGroup bg;
    HashMap<String, JRadioButtonMenuItem> class2button = new HashMap();

    public LookAndFeeler(JFrame jf, MenuBuilder mb) {
        this.jf = jf;
        this.mb = mb;
        this.setup();
    }

    private void setup() {
        this.lif = UIManager.getInstalledLookAndFeels();
        this.bg = new ButtonGroup();
        LookAndFeel current_laf = UIManager.getLookAndFeel();
        String current_class = current_laf == null ? "" : current_laf.getClass().getName();
        this.mb.start_submenu("Look and feel", 76);
        this.mb.push_listener(this);
        for (int i = 0; i < this.lif.length; ++i) {
            String classname = this.lif[i].getClassName();
            JRadioButtonMenuItem jrb = new JRadioButtonMenuItem(this.lif[i].getName(), classname.equals(current_class));
            this.class2button.put(classname, jrb);
            this.bg.add(jrb);
            this.mb.add(jrb);
        }
        this.mb.add(new JSeparator());
        this.mb.add("Native", 78);
        this.mb.add("Cross-platform", 67);
        this.mb.pop_listener();
        this.mb.end_submenu();
    }

    public static void main(String[] argv) {
        JFrame jf = new JFrame();
        MenuBuilder mb = new MenuBuilder(jf, null);
        mb.start_menu("File");
        new LookAndFeeler(jf, mb);
        jf.pack();
        jf.setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
        JRadioButtonMenuItem which;
        String cmd = e.getActionCommand();
        String target = null;
        if (cmd.equals("Native")) {
            target = UIManager.getSystemLookAndFeelClassName();
        } else if (cmd.equals("Cross-platform")) {
            target = UIManager.getCrossPlatformLookAndFeelClassName();
        } else {
            for (int i = 0; i < this.lif.length; ++i) {
                if (!cmd.equals(this.lif[i].getName())) continue;
                try {
                    UIManager.setLookAndFeel(this.lif[i].getClassName());
                    SwingUtilities.updateComponentTreeUI(this.jf);
                    this.jf.pack();
                }
                catch (Exception ex) {
                    System.err.println(ex);
                }
                break;
            }
        }
        if (target != null && (which = this.class2button.get(target)) != null) {
            which.doClick();
        }
    }

    public static void set_native_lookandfeel() {
        try {
            String name = UIManager.getSystemLookAndFeelClassName();
            if (name != null) {
                UIManager.setLookAndFeel(name);
            }
        }
        catch (Exception e) {
            System.err.println("error setting native look and feel: " + e);
        }
    }
}

