/*
 * Decompiled with CFR 0.152.
 */
package Funk;

import java.awt.Component;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;

public class MenuBuilder {
    private JMenuBar jmb;
    private ArrayList<JMenu> jmenu_stack;
    private ArrayList<ActionListener> listener_stack;

    public MenuBuilder(JFrame jf, ActionListener al) {
        this.jmb = new JMenuBar();
        jf.setJMenuBar(this.jmb);
        this.setup(al);
    }

    public MenuBuilder(JMenuBar jmb, ActionListener al) {
        this.jmb = jmb;
        this.setup(al);
    }

    private void setup(ActionListener al) {
        this.listener_stack = new ArrayList();
        this.push_listener(al);
    }

    public void push_listener(ActionListener al) {
        this.listener_stack.add(al);
    }

    public void pop_listener() {
        int size = this.listener_stack.size();
        if (size > 0) {
            this.listener_stack.remove(size - 1);
        }
    }

    public ActionListener get_current_listener() {
        int size = this.listener_stack.size();
        return size == 0 ? null : this.listener_stack.get(size - 1);
    }

    public void start_menu(JMenu jm) {
        this.jmenu_stack = new ArrayList();
        this.jmenu_stack.add(jm);
        this.jmb.add(jm);
    }

    public void start_menu(String label) {
        this.start_menu(new JMenu(label));
    }

    public void start_menu(String label, int mnemonic) {
        JMenu jm = new JMenu(label);
        jm.setMnemonic(mnemonic);
        this.start_menu(jm);
    }

    public void start_submenu(String label) {
        JMenu jm = new JMenu(label);
        this.get_current_jmenu().add(jm);
        this.jmenu_stack.add(jm);
    }

    public void start_submenu(String label, int mnemonic) {
        JMenu jm = new JMenu(label);
        jm.setMnemonic(mnemonic);
        this.get_current_jmenu().add(jm);
        this.jmenu_stack.add(jm);
    }

    public void end_submenu() {
        this.jmenu_stack.remove(this.jmenu_stack.size() - 1);
    }

    public void add(Component c) {
        this.get_current_jmenu().add(c);
        ActionListener al = this.get_current_listener();
        if (c instanceof JMenuItem && al != null) {
            ((JMenuItem)c).addActionListener(al);
        }
    }

    public void add(AbstractButton ab, int mnemonic) {
        ab.setMnemonic(mnemonic);
        this.add(ab);
    }

    public void add(String label) {
        this.add(new JMenuItem(label));
    }

    public void add(String label, int mnemonic) {
        this.add(new JMenuItem(label, mnemonic));
    }

    private JMenu get_current_jmenu() {
        return this.jmenu_stack.get(this.jmenu_stack.size() - 1);
    }
}

