/*
 * Decompiled with CFR 0.152.
 */
package Funk;

import Funk.LogicalComparator;
import Funk.NumberComparatorEQ;
import Funk.NumberComparatorGE;
import Funk.NumberComparatorGT;
import Funk.NumberComparatorLE;
import Funk.NumberComparatorLT;
import Funk.NumberComparatorNE;

public abstract class NumberComparator
implements LogicalComparator {
    protected double comparator_value;
    public static final String LABEL_NE = "!=";
    public static final String LABEL_GT = ">";
    public static final String LABEL_GE = ">=";
    public static final String LABEL_LT = "<";
    public static final String LABEL_LE = "<=";
    public static final String LABEL_EQ = "=";

    public NumberComparator(Number value) {
        this.comparator_value = value.doubleValue();
    }

    protected double get_value(Object raw) throws NumberFormatException {
        double result = 0.0;
        if (raw instanceof Number) {
            result = ((Number)raw).doubleValue();
        } else if (raw instanceof String) {
            Double d = Double.parseDouble((String)raw);
            result = d;
        } else {
            throw new NumberFormatException();
        }
        return result;
    }

    public static NumberComparator get_comparator(String logic, Number value) {
        NumberComparator result = null;
        if (logic.equals(LABEL_NE)) {
            result = new NumberComparatorNE(value);
        } else if (logic.equals(LABEL_GT)) {
            result = new NumberComparatorGT(value);
        } else if (logic.equals(LABEL_GE)) {
            result = new NumberComparatorGE(value);
        } else if (logic.equals(LABEL_LT)) {
            result = new NumberComparatorLT(value);
        } else if (logic.equals(LABEL_LE)) {
            result = new NumberComparatorLE(value);
        } else if (logic.equals(LABEL_EQ)) {
            result = new NumberComparatorEQ(value);
        } else {
            System.err.println("ERROR: can't init for " + logic);
        }
        return result;
    }

    public static void main(String[] argv) {
        String s_0 = "0";
        String s_1 = "1";
        String s_2 = "2";
        Integer i_0 = 0;
        Integer i_1 = 1;
        Integer i_2 = 2;
        NumberComparator nc = NumberComparator.get_comparator(LABEL_GT, 1);
        System.err.println(nc + " > 1");
        System.err.println("  " + nc.compare(i_0));
        System.err.println("  " + nc.compare(i_1));
        System.err.println("  " + nc.compare(i_2));
        System.err.println("");
        System.err.println("< 1");
        nc = NumberComparator.get_comparator(LABEL_LT, 1);
        System.err.println(nc + " " + nc.compare("0"));
        System.err.println(nc + " " + nc.compare("1"));
        System.err.println(nc + " " + nc.compare("2"));
        System.err.println("");
        System.err.println("= 1");
        nc = NumberComparator.get_comparator(LABEL_EQ, 1);
        System.err.println(nc + " " + nc.compare("0"));
        System.err.println(nc + " " + nc.compare("1"));
        System.err.println(nc + " " + nc.compare("2"));
        System.err.println("");
        System.err.println(">= 1");
        nc = NumberComparator.get_comparator(LABEL_GE, 1);
        System.err.println(nc + " " + nc.compare("0"));
        System.err.println(nc + " " + nc.compare("1"));
        System.err.println(nc + " " + nc.compare("2"));
        System.err.println("");
        System.err.println("<= 1");
        nc = NumberComparator.get_comparator(LABEL_LE, 1);
        System.err.println(nc + " " + nc.compare("0"));
        System.err.println(nc + " " + nc.compare("1"));
        System.err.println(nc + " " + nc.compare("2"));
        System.err.println("");
        System.err.println("!= 1");
        nc = NumberComparator.get_comparator(LABEL_NE, 1);
        System.err.println(nc + " " + nc.compare("0"));
        System.err.println(nc + " " + nc.compare("1"));
        System.err.println(nc + " " + nc.compare("2"));
        System.err.println("");
    }
}

