/*
 * Decompiled with CFR 0.152.
 */
package Funk;

import Funk.DoWhatISayObservable;
import Funk.FocusHack;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Observer;

public class PromptFrame
extends Frame
implements WindowListener,
KeyListener,
ActionListener {
    private Font myfont = new Font("TimesRoman", 0, 16);
    private Button b_ok;
    private Button b_cancel;
    private Observer observer;
    private String message;
    private String title;
    private TextField tf;
    private DoWhatISayObservable dwis = new DoWhatISayObservable();
    private static final String L_OK = "OK";
    private static final String L_CANCEL = "Cancel";

    public PromptFrame(Observer observer, String message) {
        this.observer = observer;
        this.message = message;
        this.setup();
    }

    public PromptFrame(Observer observer, String message, String title) {
        this.observer = observer;
        this.message = message;
        this.title = title;
        this.setup();
    }

    private void setup() {
        this.dwis.addObserver(this.observer);
        this.addWindowListener(this);
        this.setTitle(this.title == null ? "Prompt" : this.title);
        this.setLayout(new BorderLayout());
        Panel p = new Panel();
        this.b_ok = new Button(L_OK);
        p.add(this.b_ok);
        this.b_cancel = new Button(L_CANCEL);
        p.add(this.b_cancel);
        this.b_ok.addActionListener(this);
        this.b_cancel.addActionListener(this);
        this.add("South", p);
        p = new Panel();
        p.add(new Label(this.message + ":"));
        this.tf = new TextField(20);
        this.tf.addKeyListener(this);
        p.add(this.tf);
        this.add("North", p);
        this.pack();
        this.setSize(this.getPreferredSize());
        this.setResizable(false);
        this.setVisible(true);
        new FocusHack(this.tf);
    }

    private void quit() {
        this.setVisible(false);
        this.dispose();
    }

    private void notifyObservers() {
        this.dwis.setChanged();
        this.dwis.notifyObservers(this);
        this.quit();
    }

    public static void main(String[] argv) {
        new PromptFrame(null, "Hi there", "Test");
    }

    public String get_value() {
        return this.tf.getText();
    }

    public void windowActivated(WindowEvent we) {
    }

    public void windowClosed(WindowEvent we) {
    }

    public void windowDeactivated(WindowEvent we) {
    }

    public void windowDeiconified(WindowEvent we) {
    }

    public void windowIconified(WindowEvent we) {
    }

    public void windowOpened(WindowEvent we) {
    }

    public void windowClosing(WindowEvent we) {
        this.quit();
    }

    public void keyPressed(KeyEvent ke) {
        if (ke.getKeyCode() == 10) {
            this.notifyObservers();
        }
    }

    public void keyReleased(KeyEvent ke) {
    }

    public void keyTyped(KeyEvent ke) {
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals(L_OK)) {
            this.notifyObservers();
        } else if (cmd.equals(L_CANCEL)) {
            this.quit();
        } else {
            System.out.println("WTF?");
        }
    }
}

