/*
 * Decompiled with CFR 0.152.
 */
package Funk;

import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.Scrollbar;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

public class ScrollCanvas
extends Canvas
implements AdjustmentListener,
KeyListener {
    private Scrollbar s_h = null;
    private Scrollbar s_v = null;

    public Scrollbar create_x_scrollbar() {
        this.s_h = new Scrollbar(0);
        this.s_h.addAdjustmentListener(this);
        return this.s_h;
    }

    public Scrollbar create_y_scrollbar() {
        this.s_v = new Scrollbar(1);
        this.s_v.addAdjustmentListener(this);
        return this.s_v;
    }

    public void adjustmentValueChanged(AdjustmentEvent e) {
        this.repaint();
    }

    public Scrollbar get_horizontal_scrollbar() {
        return this.s_h;
    }

    public Scrollbar get_vertical_scrollbar() {
        return this.s_v;
    }

    public void x_scroll_setup(int visible, int max_value) {
        this.scale_it(this.s_h, visible, max_value);
    }

    public void y_scroll_setup(int visible, int max_value) {
        this.scale_it(this.s_v, visible, max_value);
    }

    public void set_y_scroll_max(int max_value) {
        Dimension d = this.getSize();
        this.scale_it(this.s_v, d.height, max_value);
    }

    private void scale_it(Scrollbar sb, int visible, int max_value) {
        sb.setValues(sb.getValue(), visible, 0, max_value);
        sb.setBlockIncrement(visible);
        int unit = visible / 10;
        if (unit < 1) {
            unit = 1;
        }
        sb.setUnitIncrement(unit);
    }

    public int get_scroll_x() {
        return this.s_h.getValue();
    }

    public int get_scroll_y() {
        return this.s_v.getValue();
    }

    public void keyPressed(KeyEvent ke) {
        int code = ke.getKeyCode();
        Scrollbar bar = null;
        int inc_type = 0;
        boolean block = false;
        if (this.s_v != null) {
            bar = this.s_v;
            if (code == 33) {
                block = true;
                inc_type = -1;
            } else if (code == 34) {
                block = true;
                inc_type = 1;
            } else if (code == 38) {
                inc_type = -1;
            } else if (code == 40) {
                inc_type = 1;
            }
        }
        if (inc_type != 0) {
            bar.setValue(bar.getValue() + (block ? bar.getBlockIncrement() : bar.getUnitIncrement()) * inc_type);
            this.do_repaint();
        }
    }

    public void do_repaint() {
        this.repaint();
    }

    public void keyReleased(KeyEvent ke) {
    }

    public void keyTyped(KeyEvent ke) {
    }
}

