/*
 * Decompiled with CFR 0.152.
 */
package Funk;

import Funk.DoWhatISayObservable;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Observer;

public class Slider
extends Canvas
implements MouseMotionListener,
MouseListener {
    private static final int BAR_DELTA_Y = 1;
    private static final int GADGET_WIDTH = 8;
    private static final int BORDER = 2;
    private double min;
    private double max;
    private double value;
    private double value_range;
    private int slide_range;
    private int slide_left_border;
    private int slide_right_border;
    private Image offscreen;
    private Rectangle line;
    private Rectangle gadget;
    private Dimension size;
    private DoWhatISayObservable notifier = new DoWhatISayObservable();
    private Observer o;

    public Slider(int width, int height, double min, double max) {
        this.size = new Dimension(width, height);
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        this.value = this.min = min;
        this.max = max;
        this.value_range = max - min;
        int y_center = this.size.height / 2;
        this.slide_left_border = 2;
        int right = this.size.width - 4;
        this.line = new Rectangle(this.slide_left_border, y_center - 1, right - this.slide_left_border, 3);
        this.slide_right_border = right - 8;
        this.slide_range = this.slide_right_border - this.slide_left_border;
        this.gadget = new Rectangle(0, 2, 8, this.size.height - 4);
        this.setSize(this.size.width, this.size.height);
    }

    public void addObserver(Observer o) {
        this.notifier.addObserver(o);
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double i) {
        if (i < this.min) {
            i = this.min;
        }
        if (i > this.max) {
            i = this.max;
        }
        this.value = i;
        this.repaint();
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics g) {
        if (this.offscreen == null) {
            this.offscreen = this.createImage(this.size.width, this.size.height);
        }
        Dimension d = this.getSize();
        double fract = (this.value - this.min) / this.value_range;
        this.gadget.x = this.slide_left_border + (int)((double)this.slide_range * fract);
        Graphics og = this.offscreen.getGraphics();
        og.setColor(this.getBackground());
        og.fillRect(0, 0, this.size.width, this.size.height);
        this.draw_rect(this.line, og, Color.white);
        this.draw_rect(this.gadget, og, Color.white);
        g.drawImage(this.offscreen, 0, 0, this);
    }

    private void mousevalue(int x) {
        if (x < this.slide_left_border) {
            x = this.slide_left_border;
        }
        if (x > this.slide_right_border) {
            x = this.slide_right_border;
        }
        double mult = (double)(x - this.slide_left_border) / (double)this.slide_range;
        this.value = this.min + this.value_range * mult;
        this.notifier.setChanged();
        this.notifier.notifyObservers(new Double(this.value));
        this.repaint();
    }

    private void draw_rect(Rectangle r, Graphics g, Color c) {
        g.setColor(Color.black);
        g.drawRect(r.x, r.y, r.width, r.height);
        g.setColor(c);
        g.fillRect(r.x + 1, r.y + 1, r.width - 1, r.height - 1);
    }

    public void mouseDragged(MouseEvent e) {
        this.mousevalue(e.getX());
    }

    public void mousePressed(MouseEvent e) {
        this.mousevalue(e.getX());
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }
}

