/*
 * Decompiled with CFR 0.152.
 */
package Funk;

import java.util.ArrayList;
import java.util.HashSet;

public class StreamingDuplicateFilter {
    static int DEFAULT_QUEUE_MAX = 100000;
    static double TRIM_FRACTION = 0.25;
    boolean VERBOSE = false;
    int queue_max;
    ArrayList<String> queue;
    HashSet<String> queue_hash;

    public StreamingDuplicateFilter() {
        this.set_queue_max(DEFAULT_QUEUE_MAX);
    }

    public StreamingDuplicateFilter(int max) {
        this.set_queue_max(max);
    }

    public void set_queue_max(int queue_max) {
        this.queue_max = queue_max;
        this.queue = new ArrayList();
        this.queue_hash = new HashSet();
    }

    public boolean add(String item) {
        boolean result = this.is_duplicate(item);
        this.queue.add(item);
        this.queue_hash.add(item);
        this.trim_check();
        return result;
    }

    public boolean is_duplicate(String item) {
        return this.queue_hash.contains(item);
    }

    private void trim_check() {
        if (this.queue.size() > this.queue_max) {
            if (this.VERBOSE) {
                System.err.println("trim needed");
                System.err.println("before:" + this.queue);
            }
            int trim_index = (int)((double)this.queue.size() * TRIM_FRACTION);
            for (int i = 0; i < trim_index; ++i) {
                this.queue.remove(0);
            }
            if (this.VERBOSE) {
                System.err.println("after:" + this.queue);
            }
            this.queue_hash = new HashSet<String>(this.queue);
            if (this.VERBOSE) {
                System.err.println("hash=" + this.queue_hash);
            }
        }
    }

    public static void main(String[] argv) {
        StreamingDuplicateFilter sdf = new StreamingDuplicateFilter();
        sdf.set_queue_max(10);
        String[] values = new String[]{"a", "b", "c", "d", "e", "f", "a", "z"};
        for (int i = 0; i < values.length; ++i) {
            System.err.println(values[i] + " " + sdf.add(values[i]));
        }
    }
}

